/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.misc.utils.MappingUtils;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheValue;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class VirAttrHandlerImpl
implements VirAttrHandler {
    private static final Logger LOG = LoggerFactory.getLogger(VirAttrHandler.class);
    @Autowired
    private ConnectorFactory connFactory;
    @Autowired
    private VirAttrCache virAttrCache;
    @Autowired
    private MappingUtils mappingUtils;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    private Map<VirSchema, List<String>> getValues(Any<?> any, Set<VirSchema> schemas) {
        Set ownedResources = this.anyUtilsFactory.getInstance(any).getAllResources(any);
        HashMap<VirSchema, List<String>> result = new HashMap<VirSchema, List<String>>();
        HashMap<Provision, HashSet<VirSchema>> toRead = new HashMap<Provision, HashSet<VirSchema>>();
        for (VirSchema virSchema : schemas) {
            if (ownedResources.contains(virSchema.getProvision().getResource())) {
                VirAttrCacheValue virAttrCacheValue = this.virAttrCache.get((String)any.getType().getKey(), (Long)any.getKey(), (String)virSchema.getKey());
                if (this.virAttrCache.isValidEntry(virAttrCacheValue)) {
                    LOG.debug("Values for {} found in cache: {}", (Object)virSchema, (Object)virAttrCacheValue);
                    result.put(virSchema, virAttrCacheValue.getValues());
                    continue;
                }
                HashSet<VirSchema> schemasToRead = (HashSet<VirSchema>)toRead.get(virSchema.getProvision());
                if (schemasToRead == null) {
                    schemasToRead = new HashSet<VirSchema>();
                    toRead.put(virSchema.getProvision(), schemasToRead);
                }
                schemasToRead.add(virSchema);
                continue;
            }
            LOG.debug("Not considering {} since {} is not assigned to {}", new Object[]{virSchema, any, virSchema.getProvision().getResource()});
        }
        for (Map.Entry entry : toRead.entrySet()) {
            String connObjectKey;
            LOG.debug("About to read from {}: {}", entry.getKey(), entry.getValue());
            String string = connObjectKey = MappingUtils.getConnObjectKeyItem((Provision)((Provision)entry.getKey())) == null ? null : this.mappingUtils.getConnObjectKeyValue(any, (Provision)entry.getKey());
            if (StringUtils.isBlank(connObjectKey)) {
                LOG.error("No ConnObjectKey found for {}, ignoring...", entry.getKey());
                continue;
            }
            HashSet<MappingItem> linkingMappingItems = new HashSet<MappingItem>();
            for (VirSchema schema : (Set)entry.getValue()) {
                linkingMappingItems.add(schema.asLinkingMappingItem());
            }
            Connector connector = this.connFactory.getConnector(((Provision)entry.getKey()).getResource());
            try {
                ConnectorObject connectorObject = connector.getObject(((Provision)entry.getKey()).getObjectClass(), new Uid(connObjectKey), MappingUtils.buildOperationOptions(linkingMappingItems.iterator()));
                if (connectorObject == null) {
                    LOG.debug("No read from {} about {}", entry.getKey(), (Object)connObjectKey);
                    continue;
                }
                for (VirSchema schema : (Set)entry.getValue()) {
                    Attribute attr = connectorObject.getAttributeByName(schema.getExtAttrName());
                    if (attr == null) continue;
                    VirAttrCacheValue virAttrCacheValue = new VirAttrCacheValue();
                    virAttrCacheValue.setValues((Collection)attr.getValue());
                    this.virAttrCache.put((String)any.getType().getKey(), (Long)any.getKey(), (String)schema.getKey(), virAttrCacheValue);
                    LOG.debug("Values for {} set in cache: {}", (Object)schema, (Object)virAttrCacheValue);
                    result.put(schema, virAttrCacheValue.getValues());
                }
            }
            catch (Exception e) {
                LOG.error("Error reading from {}", entry.getKey(), (Object)e);
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    public List<String> getValues(Any<?> any, VirSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).getAllowedSchemas(any, VirSchema.class).contains(schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return Collections.emptyList();
        }
        return ListUtils.emptyIfNull(this.getValues(any, Collections.singleton(schema)).get(schema));
    }

    @Transactional(readOnly=true)
    public Map<VirSchema, List<String>> getValues(Any<?> any) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).getAllowedSchemas(any, VirSchema.class));
    }
}

