/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttr;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.conf.Conf;
import org.apache.syncope.core.provisioning.api.data.ConfigurationDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationDataBinderImpl
extends AbstractAnyDataBinder
implements ConfigurationDataBinder {
    public List<AttrTO> getConfTO(Conf conf) {
        ArrayList<AttrTO> attrTOs = new ArrayList<AttrTO>();
        for (CPlainAttr plainAttr : conf.getPlainAttrs()) {
            AttrTO attrTO = new AttrTO();
            attrTO.setSchema((String)plainAttr.getSchema().getKey());
            attrTO.getValues().addAll(plainAttr.getValuesAsStrings());
            attrTO.setReadonly(plainAttr.getSchema().isReadonly());
            attrTOs.add(attrTO);
        }
        return attrTOs;
    }

    public AttrTO getAttrTO(CPlainAttr attr) {
        AttrTO attributeTO = new AttrTO();
        attributeTO.setSchema((String)attr.getSchema().getKey());
        attributeTO.getValues().addAll(attr.getValuesAsStrings());
        attributeTO.setReadonly(attr.getSchema().isReadonly());
        return attributeTO;
    }

    private void fillAttribute(List<String> values, PlainSchema schema, CPlainAttr attr, SyncopeClientException invalidValues) {
        List<String> valuesProvided = schema.isMultivalue() ? values : (values.isEmpty() ? Collections.emptyList() : Collections.singletonList(values.iterator().next()));
        for (String value : valuesProvided) {
            if (value == null || value.isEmpty()) {
                LOG.debug("Null value for {}, ignoring", schema.getKey());
                continue;
            }
            try {
                PlainAttrValue attrValue;
                if (schema.isUniqueConstraint()) {
                    attrValue = (PlainAttrValue)this.entityFactory.newEntity(CPlainAttrUniqueValue.class);
                    ((PlainAttrUniqueValue)attrValue).setSchema(schema);
                } else {
                    attrValue = (PlainAttrValue)this.entityFactory.newEntity(CPlainAttrValue.class);
                }
                attr.add(value, attrValue);
            }
            catch (InvalidPlainAttrValueException e) {
                LOG.warn("Invalid value for attribute " + (String)schema.getKey() + ": " + value, (Throwable)e);
                invalidValues.getElements().add((String)schema.getKey() + ": " + value + " - " + e.getMessage());
            }
        }
    }

    public CPlainAttr getAttribute(AttrTO attributeTO) {
        PlainSchema schema = this.getPlainSchema(attributeTO.getSchema());
        if (schema == null) {
            throw new NotFoundException("Conf schema " + attributeTO.getSchema());
        }
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        CPlainAttr attr = (CPlainAttr)this.entityFactory.newEntity(CPlainAttr.class);
        attr.setSchema(schema);
        this.fillAttribute(attributeTO.getValues(), schema, attr, invalidValues);
        if (!invalidValues.isEmpty()) {
            throw invalidValues;
        }
        return attr;
    }
}

