/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.misc.utils.TemplateUtils;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplate;
import org.apache.syncope.core.persistence.api.entity.AnyTemplateRealm;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RealmDataBinderImpl
implements RealmDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(RealmDataBinder.class);
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private PolicyDAO policyDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private TemplateUtils templateUtils;

    private void setTemplates(final RealmTO realmTO, Realm realm) {
        this.templateUtils.check(realmTO.getTemplates(), ClientExceptionType.InvalidSyncTask);
        for (Map.Entry entry : realmTO.getTemplates().entrySet()) {
            AnyType type = this.anyTypeDAO.find((String)entry.getKey());
            if (type == null) {
                LOG.debug("Invalid AnyType {} specified, ignoring...", entry.getKey());
                continue;
            }
            AnyTemplateRealm anyTemplate = realm.getTemplate(type);
            if (anyTemplate == null) {
                anyTemplate = (AnyTemplateRealm)this.entityFactory.newEntity(AnyTemplateRealm.class);
                anyTemplate.setAnyType(type);
                anyTemplate.setRealm(realm);
                realm.add(anyTemplate);
            }
            anyTemplate.set((AnyTO)entry.getValue());
        }
        CollectionUtils.filter((Iterable)realm.getTemplates(), (Predicate)new Predicate<AnyTemplate>(){

            public boolean evaluate(AnyTemplate anyTemplate) {
                return realmTO.getTemplates().containsKey(anyTemplate.getAnyType().getKey());
            }
        });
    }

    public Realm create(String parentPath, RealmTO realmTO) {
        Realm realm = (Realm)this.entityFactory.newEntity(Realm.class);
        realm.setName(realmTO.getName());
        realm.setParent(this.realmDAO.find(parentPath));
        if (realmTO.getPasswordPolicy() != null) {
            realm.setPasswordPolicy((PasswordPolicy)this.policyDAO.find(realmTO.getPasswordPolicy()));
        }
        if (realmTO.getAccountPolicy() != null) {
            realm.setAccountPolicy((AccountPolicy)this.policyDAO.find(realmTO.getAccountPolicy()));
        }
        realm.getActionsClassNames().addAll(realmTO.getActionsClassNames());
        this.setTemplates(realmTO, realm);
        return realm;
    }

    public void update(Realm realm, RealmTO realmTO) {
        realm.setName(realmTO.getName());
        realm.setParent(realmTO.getParent() == 0L ? null : this.realmDAO.find(Long.valueOf(realmTO.getParent())));
        if (realmTO.getPasswordPolicy() != null) {
            realm.setPasswordPolicy((PasswordPolicy)this.policyDAO.find(realmTO.getPasswordPolicy()));
        }
        if (realmTO.getAccountPolicy() != null) {
            realm.setAccountPolicy((AccountPolicy)this.policyDAO.find(realmTO.getAccountPolicy()));
        }
        realm.getActionsClassNames().clear();
        realm.getActionsClassNames().addAll(realmTO.getActionsClassNames());
        this.setTemplates(realmTO, realm);
    }

    public RealmTO getRealmTO(Realm realm) {
        RealmTO realmTO = new RealmTO();
        realmTO.setKey(((Long)realm.getKey()).longValue());
        realmTO.setName(realm.getName());
        realmTO.setParent(realm.getParent() == null ? 0L : (Long)realm.getParent().getKey());
        realmTO.setFullPath(realm.getFullPath());
        realmTO.setAccountPolicy(realm.getAccountPolicy() == null ? null : (Long)realm.getAccountPolicy().getKey());
        realmTO.setPasswordPolicy(realm.getPasswordPolicy() == null ? null : (Long)realm.getPasswordPolicy().getKey());
        realmTO.getActionsClassNames().addAll(realm.getActionsClassNames());
        for (AnyTemplate template : realm.getTemplates()) {
            realmTO.getTemplates().put(template.getAnyType().getKey(), template.get());
        }
        return realmTO;
    }
}

