/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.misc.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.user.DynRoleMembership;
import org.apache.syncope.core.provisioning.api.data.RoleDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleDataBinderImpl
implements RoleDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(RoleDataBinder.class);
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private EntityFactory entityFactory;

    private void setDynMembership(Role role, String dynMembershipFIQL) {
        DynRoleMembership dynMembership;
        SearchCond dynMembershipCond = SearchCondConverter.convert((String)dynMembershipFIQL, (String[])new String[0]);
        if (!dynMembershipCond.isValid()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchExpression);
            sce.getElements().add(dynMembershipFIQL);
            throw sce;
        }
        if (role.getDynMembership() == null) {
            dynMembership = (DynRoleMembership)this.entityFactory.newEntity(DynRoleMembership.class);
            dynMembership.setRole(role);
            role.setDynMembership(dynMembership);
        } else {
            dynMembership = role.getDynMembership();
        }
        dynMembership.setFIQLCond(dynMembershipFIQL);
    }

    public Role create(RoleTO roleTO) {
        Role role = (Role)this.entityFactory.newEntity(Role.class);
        this.update(role, roleTO);
        return role;
    }

    public void update(Role role, RoleTO roleTO) {
        role.setKey(roleTO.getKey());
        role.getEntitlements().clear();
        role.getEntitlements().addAll(roleTO.getEntitlements());
        role.getRealms().clear();
        for (String realmFullPath : roleTO.getRealms()) {
            Realm realm = this.realmDAO.find(realmFullPath);
            if (realm == null) {
                LOG.debug("Invalid realm full path {}, ignoring", (Object)realmFullPath);
                continue;
            }
            role.add(realm);
        }
        if (role.getKey() == null && roleTO.getDynMembershipCond() != null) {
            this.setDynMembership(role, roleTO.getDynMembershipCond());
        } else if (role.getDynMembership() != null && roleTO.getDynMembershipCond() == null) {
            role.setDynMembership(null);
        } else if (role.getDynMembership() == null && roleTO.getDynMembershipCond() != null) {
            this.setDynMembership(role, roleTO.getDynMembershipCond());
        } else if (role.getDynMembership() != null && roleTO.getDynMembershipCond() != null && !role.getDynMembership().getFIQLCond().equals(roleTO.getDynMembershipCond())) {
            role.getDynMembership().getMembers().clear();
            this.setDynMembership(role, roleTO.getDynMembershipCond());
        }
    }

    public RoleTO getRoleTO(Role role) {
        RoleTO roleTO = new RoleTO();
        roleTO.setKey((String)role.getKey());
        roleTO.getEntitlements().addAll(role.getEntitlements());
        CollectionUtils.collect((Iterable)role.getRealms(), (Transformer)new Transformer<Realm, String>(){

            public String transform(Realm input) {
                return input.getFullPath();
            }
        }, (Collection)roleTO.getRealms());
        if (role.getDynMembership() != null) {
            roleTO.setDynMembershipCond(role.getDynMembership().getFIQLCond());
        }
        return roleTO;
    }
}

