/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.syncope.core.misc.AuditManager;
import org.apache.syncope.core.misc.spring.ApplicationContextProvider;
import org.apache.syncope.core.misc.utils.ConnObjectUtils;
import org.apache.syncope.core.misc.utils.ExceptionUtils2;
import org.apache.syncope.core.misc.utils.MappingUtils;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheValue;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public abstract class AbstractPropagationTaskExecutor
implements PropagationTaskExecutor {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationTaskExecutor.class);
    @Autowired
    protected ConnectorFactory connFactory;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected TaskDAO taskDAO;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected VirAttrCache virAttrCache;

    public TaskExec execute(PropagationTask task) {
        return this.execute(task, null);
    }

    protected List<PropagationActions> getPropagationActions(ExternalResource resource) {
        ArrayList<PropagationActions> result = new ArrayList<PropagationActions>();
        if (!resource.getPropagationActionsClassNames().isEmpty()) {
            for (String className : resource.getPropagationActionsClassNames()) {
                try {
                    Class<?> actionsClass = Class.forName(className);
                    result.add((PropagationActions)ApplicationContextProvider.getBeanFactory().createBean(actionsClass, 2, true));
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Invalid PropagationAction class name '{}' for resource {}", new Object[]{resource, className, e});
                }
            }
        }
        return result;
    }

    private Map<String, Attribute> toMap(Collection<? extends Attribute> attributes) {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : attributes) {
            map.put(attribute.getName().toUpperCase(), attribute);
        }
        return map;
    }

    protected void createOrUpdate(PropagationTask task, ConnectorObject beforeObj, Connector connector, Boolean[] propagationAttempted) {
        Attribute mandatoryNullOrEmpty;
        HashSet attributes = new HashSet(task.getAttributes());
        HashSet mandatoryAttrNames = new HashSet();
        Attribute mandatoryMissing = AttributeUtil.find((String)"__MANDATORY_MISSING__", (Set)task.getAttributes());
        if (mandatoryMissing != null) {
            attributes.remove(mandatoryMissing);
            if (beforeObj == null) {
                mandatoryAttrNames.addAll(mandatoryMissing.getValue());
            }
        }
        if ((mandatoryNullOrEmpty = AttributeUtil.find((String)"__MANDATORY_NULL_OR_EMPTY__", (Set)task.getAttributes())) != null) {
            attributes.remove(mandatoryNullOrEmpty);
            mandatoryAttrNames.addAll(mandatoryNullOrEmpty.getValue());
        }
        if (!mandatoryAttrNames.isEmpty()) {
            throw new IllegalArgumentException("Not attempted because there are mandatory attributes without value(s): " + mandatoryAttrNames);
        }
        if (beforeObj == null) {
            LOG.debug("Create {} on {}", attributes, task.getResource().getKey());
            connector.create(new ObjectClass(task.getObjectClassName()), attributes, null, propagationAttempted);
        } else {
            Name newName = (Name)AttributeUtil.find((String)Name.NAME, attributes);
            LOG.debug("Rename required with value {}", (Object)newName);
            if (newName != null && newName.equals((Object)beforeObj.getName()) && !newName.getNameValue().equals(beforeObj.getUid().getUidValue())) {
                LOG.debug("Remote object name unchanged");
                attributes.remove(newName);
            }
            Map<String, Attribute> originalAttrMap = this.toMap(beforeObj.getAttributes());
            Map<String, Attribute> updateAttrMap = this.toMap(attributes);
            Set<String> skipAttrNames = originalAttrMap.keySet();
            skipAttrNames.removeAll(updateAttrMap.keySet());
            for (String attrName : new HashSet<String>(skipAttrNames)) {
                originalAttrMap.remove(attrName);
            }
            HashSet<Attribute> originalAttrs = new HashSet<Attribute>(originalAttrMap.values());
            if (originalAttrs.equals(attributes)) {
                LOG.debug("Don't need to propagate anything: {} is equal to {}", originalAttrs, attributes);
            } else {
                LOG.debug("Attributes that would be updated {}", attributes);
                HashSet<Attribute> strictlyModified = new HashSet<Attribute>();
                for (Attribute attr : attributes) {
                    if (originalAttrs.contains(attr)) continue;
                    strictlyModified.add(attr);
                }
                LOG.debug("Update {} on {}", strictlyModified, task.getResource().getKey());
                connector.update(beforeObj.getObjectClass(), beforeObj.getUid(), strictlyModified, null, propagationAttempted);
            }
        }
    }

    protected Any<?> getAny(PropagationTask task) {
        Any any = null;
        if (task.getAnyKey() != null) {
            switch (task.getAnyTypeKind()) {
                case USER: {
                    try {
                        any = this.userDAO.authFind(task.getAnyKey());
                    }
                    catch (Exception e) {
                        LOG.error("Could not read user {}", (Object)task.getAnyKey(), (Object)e);
                    }
                    break;
                }
                case GROUP: {
                    try {
                        any = this.groupDAO.authFind(task.getAnyKey());
                    }
                    catch (Exception e) {
                        LOG.error("Could not read group {}", (Object)task.getAnyKey(), (Object)e);
                    }
                    break;
                }
                default: {
                    try {
                        any = this.anyObjectDAO.authFind(task.getAnyKey());
                        break;
                    }
                    catch (Exception e) {
                        LOG.error("Could not read any object {}", (Object)task.getAnyKey(), (Object)e);
                    }
                }
            }
        }
        return any;
    }

    protected void delete(PropagationTask task, ConnectorObject beforeObj, Connector connector, Boolean[] propagationAttempted) {
        if (beforeObj == null) {
            LOG.debug("{} not found on external resource: ignoring delete", (Object)task.getConnObjectKey());
        } else {
            Set resources;
            Any<?> any = this.getAny(task);
            Collection<Object> collection = any instanceof User ? this.userDAO.findAllResourceNames((User)any) : (any instanceof AnyObject ? this.anyObjectDAO.findAllResourceNames((AnyObject)any) : (resources = any instanceof Group ? ((Group)any).getResourceNames() : Collections.emptySet()));
            if (!resources.contains(task.getResource().getKey())) {
                LOG.debug("Delete {} on {}", (Object)beforeObj.getUid(), task.getResource().getKey());
                connector.delete(beforeObj.getObjectClass(), beforeObj.getUid(), null, propagationAttempted);
            } else {
                this.createOrUpdate(task, beforeObj, connector, propagationAttempted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TaskExec execute(PropagationTask task, PropagationReporter reporter) {
        AuditElements.Result result;
        ConnectorObject afterObj;
        ConnectorObject beforeObj;
        TaskExec execution;
        block30: {
            Connector connector;
            Provision provision;
            String failureReason;
            String taskExecutionMessage;
            Date start;
            List<PropagationActions> actions;
            block28: {
                actions = this.getPropagationActions(task.getResource());
                start = new Date();
                execution = (TaskExec)this.entityFactory.newEntity(TaskExec.class);
                execution.setStatus(PropagationTaskExecStatus.CREATED.name());
                taskExecutionMessage = null;
                failureReason = null;
                Boolean[] propagationAttempted = new Boolean[]{false};
                beforeObj = null;
                afterObj = null;
                provision = null;
                connector = null;
                provision = task.getResource().getProvision(new ObjectClass(task.getObjectClassName()));
                connector = this.connFactory.getConnector(task.getResource());
                beforeObj = this.getRemoteObject(task, connector, provision, false);
                for (PropagationActions action : actions) {
                    action.before(task, beforeObj);
                }
                switch (task.getOperation()) {
                    case CREATE: 
                    case UPDATE: {
                        this.createOrUpdate(task, beforeObj, connector, propagationAttempted);
                        break;
                    }
                    case DELETE: {
                        this.delete(task, beforeObj, connector, propagationAttempted);
                        break;
                    }
                }
                execution.setStatus(propagationAttempted[0] != false ? PropagationTaskExecStatus.SUCCESS.name() : PropagationTaskExecStatus.NOT_ATTEMPTED.name());
                for (PropagationActions action : actions) {
                    action.after(task, execution, afterObj);
                }
                LOG.debug("Successfully propagated to {}", (Object)task.getResource());
                result = AuditElements.Result.SUCCESS;
                if (connector == null) break block28;
                try {
                    afterObj = this.getRemoteObject(task, connector, provision, true);
                }
                catch (Exception ignore) {
                    LOG.error("Error retrieving after object", (Throwable)ignore);
                }
            }
            execution.setStart(start);
            execution.setMessage(taskExecutionMessage);
            execution.setEnd(new Date());
            LOG.debug("Execution finished: {}", (Object)execution);
            if (this.hasToBeregistered(task, execution)) {
                LOG.debug("Execution to be stored: {}", (Object)execution);
                execution.setTask((Task)task);
                task.addExec(execution);
                this.taskDAO.save((Task)task);
                this.taskDAO.flush();
            }
            if (reporter != null) {
                reporter.onSuccessOrNonPriorityResourceFailures(task, PropagationTaskExecStatus.valueOf((String)execution.getStatus()), failureReason, beforeObj, afterObj);
            }
            break block30;
            catch (Exception e) {
                block29: {
                    try {
                        result = AuditElements.Result.FAILURE;
                        LOG.error("Exception during provision on resource " + (String)task.getResource().getKey(), (Throwable)e);
                        if (e instanceof ConnectorException && e.getCause() != null) {
                            taskExecutionMessage = e.getCause().getMessage();
                            failureReason = e.getCause().getMessage() == null ? e.getMessage() : e.getMessage() + "\n\n Cause: " + e.getCause().getMessage().split("\n")[0];
                        } else {
                            taskExecutionMessage = ExceptionUtils2.getFullStackTrace((Throwable)e);
                            failureReason = e.getCause() == null ? e.getMessage() : e.getMessage() + "\n\n Cause: " + e.getCause().getMessage().split("\n")[0];
                        }
                        try {
                            execution.setStatus(PropagationTaskExecStatus.FAILURE.name());
                        }
                        catch (Exception wft) {
                            LOG.error("While executing KO action on {}", (Object)execution, (Object)wft);
                        }
                        propagationAttempted[0] = true;
                        for (PropagationActions action : actions) {
                            action.onError(task, execution, e);
                        }
                        if (connector == null) break block29;
                    }
                    catch (Throwable throwable) {
                        if (connector != null) {
                            try {
                                afterObj = this.getRemoteObject(task, connector, provision, true);
                            }
                            catch (Exception ignore) {
                                LOG.error("Error retrieving after object", (Throwable)ignore);
                            }
                        }
                        execution.setStart(start);
                        execution.setMessage(taskExecutionMessage);
                        execution.setEnd(new Date());
                        LOG.debug("Execution finished: {}", (Object)execution);
                        if (this.hasToBeregistered(task, execution)) {
                            LOG.debug("Execution to be stored: {}", (Object)execution);
                            execution.setTask((Task)task);
                            task.addExec(execution);
                            this.taskDAO.save((Task)task);
                            this.taskDAO.flush();
                        }
                        if (reporter != null) {
                            reporter.onSuccessOrNonPriorityResourceFailures(task, PropagationTaskExecStatus.valueOf((String)execution.getStatus()), failureReason, beforeObj, afterObj);
                        }
                        throw throwable;
                    }
                    try {
                        afterObj = this.getRemoteObject(task, connector, provision, true);
                    }
                    catch (Exception ignore) {
                        LOG.error("Error retrieving after object", (Throwable)ignore);
                    }
                }
                execution.setStart(start);
                execution.setMessage(taskExecutionMessage);
                execution.setEnd(new Date());
                LOG.debug("Execution finished: {}", (Object)execution);
                if (this.hasToBeregistered(task, execution)) {
                    LOG.debug("Execution to be stored: {}", (Object)execution);
                    execution.setTask((Task)task);
                    task.addExec(execution);
                    this.taskDAO.save((Task)task);
                    this.taskDAO.flush();
                }
                if (reporter != null) {
                    reporter.onSuccessOrNonPriorityResourceFailures(task, PropagationTaskExecStatus.valueOf((String)execution.getStatus()), failureReason, beforeObj, afterObj);
                }
            }
        }
        this.notificationManager.createTasks(AuditElements.EventCategoryType.PROPAGATION, task.getAnyTypeKind().name().toLowerCase(), (String)task.getResource().getKey(), task.getOperation().name().toLowerCase(), result, (Object)beforeObj, (Object)new Object[]{execution, afterObj}, new Object[]{task});
        this.auditManager.audit(AuditElements.EventCategoryType.PROPAGATION, task.getAnyTypeKind().name().toLowerCase(), (String)task.getResource().getKey(), task.getOperation().name().toLowerCase(), result, (Object)beforeObj, (Object)new Object[]{execution, afterObj}, new Object[]{task});
        return execution;
    }

    public void execute(Collection<PropagationTask> tasks) {
        this.execute(tasks, null, false);
    }

    protected abstract void doExecute(Collection<PropagationTask> var1, PropagationReporter var2, boolean var3);

    public void execute(Collection<PropagationTask> tasks, PropagationReporter reporter, boolean nullPriorityAsync) {
        try {
            this.doExecute(tasks, reporter, nullPriorityAsync);
        }
        catch (PropagationException e) {
            LOG.error("Error propagation priority resource", (Throwable)e);
            reporter.onPriorityResourceFailure(e.getResourceName(), tasks);
        }
    }

    protected boolean hasToBeregistered(PropagationTask task, TaskExec execution) {
        boolean result;
        boolean failed = PropagationTaskExecStatus.valueOf((String)execution.getStatus()) != PropagationTaskExecStatus.SUCCESS;
        switch (task.getOperation()) {
            case CREATE: {
                result = failed && task.getResource().getCreateTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getCreateTraceLevel() == TraceLevel.ALL;
                break;
            }
            case UPDATE: {
                result = failed && task.getResource().getUpdateTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getUpdateTraceLevel() == TraceLevel.ALL;
                break;
            }
            case DELETE: {
                result = failed && task.getResource().getDeleteTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getDeleteTraceLevel() == TraceLevel.ALL;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    protected ConnectorObject getRemoteObject(PropagationTask task, Connector connector, Provision provision, boolean latest) {
        String connObjectKey = latest || task.getOldConnObjectKey() == null ? task.getConnObjectKey() : task.getOldConnObjectKey();
        ArrayList<MappingItem> linkingMappingItems = new ArrayList<MappingItem>();
        for (Object schema : this.virSchemaDAO.findByProvision(provision)) {
            linkingMappingItems.add(schema.asLinkingMappingItem());
        }
        ConnectorObject obj = null;
        try {
            obj = connector.getObject(new ObjectClass(task.getObjectClassName()), new Uid(connObjectKey), MappingUtils.buildOperationOptions((Iterator)IteratorUtils.chainedIterator(MappingUtils.getPropagationMappingItems((Provision)provision).iterator(), linkingMappingItems.iterator())));
            for (MappingItem item : linkingMappingItems) {
                Attribute attr = obj.getAttributeByName(item.getExtAttrName());
                if (attr == null) {
                    this.virAttrCache.expire(task.getAnyType(), task.getAnyKey(), item.getIntAttrName());
                    continue;
                }
                VirAttrCacheValue cacheValue = new VirAttrCacheValue();
                cacheValue.setValues((Collection)attr.getValue());
                this.virAttrCache.put(task.getAnyType(), task.getAnyKey(), item.getIntAttrName(), cacheValue);
            }
        }
        catch (TimeoutException toe) {
            LOG.debug("Request timeout", (Throwable)toe);
            throw toe;
        }
        catch (RuntimeException ignore) {
            LOG.debug("While resolving {}", (Object)connObjectKey, (Object)ignore);
        }
        return obj;
    }
}

