/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.syncope.core.misc.spring.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskCallable;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.propagation.AbstractPropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.propagation.PropagationTaskCallableImpl;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class PriorityPropagationTaskExecutor
extends AbstractPropagationTaskExecutor {
    @Resource(name="propagationTaskExecutorAsyncExecutor")
    protected ThreadPoolTaskExecutor executor;

    public PropagationTaskCallable newPropagationTaskCallable(PropagationTask task, PropagationReporter reporter) {
        PropagationTaskCallable callable = (PropagationTaskCallable)ApplicationContextProvider.getBeanFactory().createBean(PropagationTaskCallableImpl.class, 2, false);
        callable.setExecutor((PropagationTaskExecutor)this);
        callable.setTask(task);
        callable.setReporter(reporter);
        return callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void doExecute(Collection<PropagationTask> tasks, PropagationReporter reporter, boolean nullPriorityAsync) {
        block15: {
            List prioritizedTasks = (List)CollectionUtils.select(tasks, (Predicate)new Predicate<PropagationTask>(){

                public boolean evaluate(PropagationTask task) {
                    return task.getResource().getPropagationPriority() != null;
                }
            }, new ArrayList());
            Collections.sort(prioritizedTasks, new PriorityComparator());
            LOG.debug("Propagation tasks sorted by priority, for serial execution: {}", (Object)prioritizedTasks);
            Collection concurrentTasks = CollectionUtils.subtract(tasks, (Iterable)prioritizedTasks);
            LOG.debug("Propagation tasks for concurrent execution: {}", (Object)concurrentTasks);
            for (PropagationTask task : prioritizedTasks) {
                void var9_9;
                Object execution = null;
                try {
                    execution = (TaskExec)this.newPropagationTaskCallable(task, reporter).call();
                    PropagationTaskExecStatus propagationTaskExecStatus = PropagationTaskExecStatus.valueOf((String)execution.getStatus());
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception", (Throwable)e);
                    PropagationTaskExecStatus propagationTaskExecStatus = PropagationTaskExecStatus.FAILURE;
                }
                if (var9_9 == PropagationTaskExecStatus.SUCCESS) continue;
                throw new PropagationException((String)task.getResource().getKey(), execution == null ? null : execution.getMessage());
            }
            final ExecutorCompletionService completionService = new ExecutorCompletionService((Executor)this.executor);
            HashMap nullPriority = new HashMap(concurrentTasks.size());
            for (PropagationTask propagationTask : concurrentTasks) {
                try {
                    nullPriority.put(propagationTask, completionService.submit(this.newPropagationTaskCallable(propagationTask, reporter)));
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception", (Throwable)e);
                }
            }
            if (nullPriority.isEmpty()) break block15;
            if (nullPriorityAsync) {
                for (Map.Entry entry : nullPriority.entrySet()) {
                    reporter.onSuccessOrNonPriorityResourceFailures((PropagationTask)entry.getKey(), PropagationTaskExecStatus.CREATED, null, null, null);
                }
            } else {
                final HashSet nullPriorityFutures = new HashSet(nullPriority.values());
                try {
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            while (!nullPriorityFutures.isEmpty()) {
                                try {
                                    nullPriorityFutures.remove(completionService.take());
                                }
                                catch (Exception e) {
                                    AbstractPropagationTaskExecutor.LOG.error("Unexpected exception", (Throwable)e);
                                }
                            }
                        }
                    }).get(60L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    LOG.error("Unexpected exception", (Throwable)exception);
                }
                finally {
                    for (Future future : nullPriorityFutures) {
                        future.cancel(true);
                    }
                    nullPriorityFutures.clear();
                    nullPriority.clear();
                }
            }
        }
    }

    protected static class PriorityComparator
    implements Comparator<PropagationTask>,
    Serializable {
        private static final long serialVersionUID = -1969355670784448878L;

        protected PriorityComparator() {
        }

        @Override
        public int compare(PropagationTask task1, PropagationTask task2) {
            int prop2;
            int prop1 = task1.getResource().getPropagationPriority();
            return prop1 > (prop2 = task2.getResource().getPropagationPriority().intValue()) ? 1 : (prop1 == prop2 ? 0 : -1);
        }
    }
}

