/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.Collection;
import org.apache.syncope.core.misc.security.AuthContextUtils;
import org.apache.syncope.core.misc.security.SyncopeAuthenticationDetails;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskCallable;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class PropagationTaskCallableImpl
implements PropagationTaskCallable {
    private static final Logger LOG = LoggerFactory.getLogger(PropagationTaskCallable.class);
    private final String domain;
    private final String username;
    private final Collection<? extends GrantedAuthority> authorities;
    private PropagationTaskExecutor executor;
    private PropagationTask task;
    private PropagationReporter reporter;

    public PropagationTaskCallableImpl() {
        SecurityContext ctx = SecurityContextHolder.getContext();
        this.domain = AuthContextUtils.getDomain();
        this.username = ctx.getAuthentication().getName();
        this.authorities = ctx.getAuthentication().getAuthorities();
    }

    public void setExecutor(PropagationTaskExecutor executor) {
        this.executor = executor;
    }

    public void setTask(PropagationTask task) {
        this.task = task;
    }

    public void setReporter(PropagationReporter reporter) {
        this.reporter = reporter;
    }

    public TaskExec call() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)new User(this.username, "FAKE_PASSWORD", this.authorities), (Object)"FAKE_PASSWORD", this.authorities);
        auth.setDetails((Object)new SyncopeAuthenticationDetails(this.domain));
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        LOG.debug("Execution started for {}", (Object)this.task);
        TaskExec execution = this.executor.execute(this.task, this.reporter);
        LOG.debug("Execution completed for {}, {}", (Object)this.task, (Object)execution);
        return execution;
    }
}

