/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.PropagationByResource;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.misc.security.DelegatedAdministrationException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.SyncTask;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheValue;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.sync.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.sync.SyncActions;
import org.apache.syncope.core.provisioning.api.sync.SyncopeSyncResultHandler;
import org.apache.syncope.core.provisioning.java.sync.AbstractSyncopeResultHandler;
import org.apache.syncope.core.provisioning.java.sync.SyncUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public abstract class AbstractSyncResultHandler
extends AbstractSyncopeResultHandler<SyncTask, SyncActions>
implements SyncopeSyncResultHandler {
    @Autowired
    protected SyncUtils syncUtilities;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected VirAttrCache virAttrCache;

    protected abstract String getName(AnyTO var1);

    protected abstract ProvisioningManager<?, ?> getProvisioningManager();

    protected abstract AnyTO doCreate(AnyTO var1, SyncDelta var2, ProvisioningReport var3);

    protected AnyTO doLink(AnyTO before, boolean unlink) {
        AnyPatch patch = this.newPatch(before.getKey());
        patch.setKey(before.getKey());
        patch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(unlink ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).value(((SyncTask)this.profile.getTask()).getResource().getKey())).build());
        return this.getAnyTO((Long)this.update(patch).getResult());
    }

    protected abstract AnyTO doUpdate(AnyTO var1, AnyPatch var2, SyncDelta var3, ProvisioningReport var4);

    protected void doDeprovision(AnyTypeKind kind, Long key, boolean unlink) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.DELETE, (String)((SyncTask)this.profile.getTask()).getResource().getKey());
        this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(kind, key, propByRes, null));
        if (unlink) {
            AnyPatch anyObjectPatch = this.newPatch(key);
            anyObjectPatch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(((SyncTask)this.profile.getTask()).getResource().getKey())).build());
        }
    }

    protected void doDelete(AnyTypeKind kind, Long key) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.DELETE, (String)((SyncTask)this.profile.getTask()).getResource().getKey());
        try {
            this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(kind, key, propByRes, null));
        }
        catch (Exception e) {
            LOG.error("Could not propagate anyObject " + key, (Throwable)e);
        }
        this.getProvisioningManager().delete(key, true);
    }

    public boolean handle(SyncDelta delta) {
        Provision provision = null;
        try {
            provision = ((SyncTask)this.profile.getTask()).getResource().getProvision(delta.getObject().getObjectClass());
            if (provision == null) {
                throw new JobExecutionException("No provision found on " + ((SyncTask)this.profile.getTask()).getResource() + " for " + delta.getObject().getObjectClass());
            }
            this.doHandle(delta, provision);
            return true;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType(provision == null ? this.getAnyUtils().getAnyTypeKind().name() : (String)provision.getAnyType().getKey());
            result.setStatus(ProvisioningReport.Status.IGNORE);
            result.setKey(Long.valueOf(0L));
            result.setName(delta.getObject().getName().getNameValue());
            this.profile.getResults().add(result);
            LOG.warn("Ignoring during synchronization", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Synchronization failed", (Throwable)e);
            return false;
        }
    }

    protected List<ProvisioningReport> assign(SyncDelta delta, Provision provision, AnyUtils anyUtils) throws JobExecutionException {
        if (!((SyncTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("SyncTask not configured for create");
            return Collections.emptyList();
        }
        AnyTO anyTO = this.connObjectUtils.getAnyTO(delta.getObject(), (SyncTask)this.profile.getTask(), provision, anyUtils);
        anyTO.getResources().add(((SyncTask)this.profile.getTask()).getResource().getKey());
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType((String)provision.getAnyType().getKey());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(this.getName(anyTO));
        if (this.profile.isDryRun()) {
            result.setKey(Long.valueOf(0L));
        } else {
            SyncDelta actionedDelta = delta;
            for (SyncActions action : this.profile.getActions()) {
                actionedDelta = action.beforeAssign(this.getProfile(), actionedDelta, anyTO);
            }
            this.create(anyTO, actionedDelta, UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), result);
        }
        return Collections.singletonList(result);
    }

    protected List<ProvisioningReport> provision(SyncDelta delta, Provision provision, AnyUtils anyUtils) throws JobExecutionException {
        if (!((SyncTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("SyncTask not configured for create");
            return Collections.emptyList();
        }
        AnyTO anyTO = this.connObjectUtils.getAnyTO(delta.getObject(), (SyncTask)this.profile.getTask(), provision, anyUtils);
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType((String)provision.getAnyType().getKey());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(this.getName(anyTO));
        if (this.profile.isDryRun()) {
            result.setKey(Long.valueOf(0L));
        } else {
            SyncDelta actionedDelta = delta;
            for (SyncActions action : this.profile.getActions()) {
                actionedDelta = action.beforeProvision(this.getProfile(), actionedDelta, anyTO);
            }
            this.create(anyTO, actionedDelta, UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), result);
        }
        return Collections.singletonList(result);
    }

    private void create(AnyTO anyTO, SyncDelta delta, String operation, ProvisioningReport result) throws JobExecutionException {
        AuditElements.Result resultStatus;
        Object output;
        try {
            AnyTO actual = this.doCreate(anyTO, delta, result);
            result.setName(this.getName(actual));
            output = actual;
            resultStatus = AuditElements.Result.SUCCESS;
            for (SyncActions action : this.profile.getActions()) {
                action.after(this.getProfile(), delta, actual, result);
            }
        }
        catch (IgnoreProvisionException e) {
            throw e;
        }
        catch (PropagationException e) {
            LOG.error("Could not propagate {} {}", new Object[]{anyTO.getType(), delta.getUid().getUidValue(), e});
            output = e;
            resultStatus = AuditElements.Result.FAILURE;
            for (SyncActions action : this.profile.getActions()) {
                action.onError(this.getProfile(), delta, result, (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOG.error("Could not create {} {} ", new Object[]{anyTO.getType(), delta.getUid().getUidValue(), e});
            output = e;
            resultStatus = AuditElements.Result.FAILURE;
            for (SyncActions action : this.profile.getActions()) {
                action.onError(this.getProfile(), delta, result, e);
            }
        }
        this.audit(operation, resultStatus, null, output, delta);
    }

    protected List<ProvisioningReport> update(SyncDelta delta, List<Long> anys, Provision provision) throws JobExecutionException {
        if (!((SyncTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("SyncTask not configured for update");
            return Collections.emptyList();
        }
        LOG.debug("About to update {}", anys);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        SyncDelta workingDelta = delta;
        for (Long key : anys) {
            LOG.debug("About to update {}", (Object)key);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.UPDATE);
            result.setAnyType((String)provision.getAnyType().getKey());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(key);
            AnyTO before = this.getAnyTO(key);
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%d)' not found", provision.getAnyType().getKey(), key));
            } else {
                result.setName(this.getName(before));
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                AuditElements.Result resultStatus;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    try {
                        Object action2;
                        AnyPatch anyPatch = this.connObjectUtils.getAnyPatch(Long.valueOf(before.getKey()), workingDelta.getObject(), before, (SyncTask)this.profile.getTask(), provision, this.getAnyUtils());
                        for (Object action2 : this.profile.getActions()) {
                            workingDelta = action2.beforeUpdate(this.getProfile(), workingDelta, before, anyPatch);
                        }
                        AnyTO updated = this.doUpdate(before, anyPatch, workingDelta, result);
                        action2 = this.profile.getActions().iterator();
                        while (action2.hasNext()) {
                            SyncActions action3 = (SyncActions)action2.next();
                            action3.after(this.getProfile(), workingDelta, updated, result);
                        }
                        output = updated;
                        resultStatus = AuditElements.Result.SUCCESS;
                        result.setName(this.getName(updated));
                        LOG.debug("{} {} successfully updated", provision.getAnyType().getKey(), (Object)key);
                    }
                    catch (IgnoreProvisionException e) {
                        throw e;
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType().getKey(), workingDelta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                        for (Object action2 : this.profile.getActions()) {
                            action2.onError(this.getProfile(), workingDelta, result, (Exception)((Object)e));
                        }
                    }
                    catch (Exception e) {
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType().getKey(), workingDelta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                        for (Object action2 : this.profile.getActions()) {
                            action2.onError(this.getProfile(), workingDelta, result, e);
                        }
                    }
                }
                this.audit(MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), resultStatus, before, output, workingDelta);
            }
            results.add(result);
        }
        return results;
    }

    protected List<ProvisioningReport> deprovision(SyncDelta delta, List<Long> anys, Provision provision, boolean unlink) throws JobExecutionException {
        if (!((SyncTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("SyncTask not configured for update");
            return Collections.emptyList();
        }
        LOG.debug("About to update {}", anys);
        ArrayList<ProvisioningReport> updResults = new ArrayList<ProvisioningReport>();
        for (Long key : anys) {
            LOG.debug("About to unassign resource {}", (Object)key);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.DELETE);
            result.setAnyType((String)provision.getAnyType().getKey());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(key);
            AnyTO before = this.getAnyTO(key);
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%d)' not found", provision.getAnyType().getKey(), key));
            }
            if (!this.profile.isDryRun()) {
                Object output;
                AuditElements.Result resultStatus;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    result.setName(this.getName(before));
                    try {
                        if (unlink) {
                            for (SyncActions action : this.profile.getActions()) {
                                action.beforeUnassign(this.getProfile(), delta, before);
                            }
                        } else {
                            for (SyncActions action : this.profile.getActions()) {
                                action.beforeDeprovision(this.getProfile(), delta, before);
                            }
                        }
                        this.doDeprovision(provision.getAnyType().getKind(), key, unlink);
                        output = this.getAnyTO(key);
                        for (SyncActions action : this.profile.getActions()) {
                            action.after(this.getProfile(), delta, (AnyTO)AnyTO.class.cast(output), result);
                        }
                        resultStatus = AuditElements.Result.SUCCESS;
                        LOG.debug("{} {} successfully updated", provision.getAnyType().getKey(), (Object)key);
                    }
                    catch (IgnoreProvisionException e) {
                        throw e;
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                        for (SyncActions action : this.profile.getActions()) {
                            action.onError(this.getProfile(), delta, result, (Exception)((Object)e));
                        }
                    }
                    catch (Exception e) {
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                        for (SyncActions action : this.profile.getActions()) {
                            action.onError(this.getProfile(), delta, result, e);
                        }
                    }
                }
                this.audit(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNASSIGN) : MatchingRule.toEventName((MatchingRule)MatchingRule.DEPROVISION), resultStatus, before, output, delta);
            }
            updResults.add(result);
        }
        return updResults;
    }

    protected List<ProvisioningReport> link(SyncDelta delta, List<Long> anys, Provision provision, boolean unlink) throws JobExecutionException {
        if (!((SyncTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("SyncTask not configured for update");
            return Collections.emptyList();
        }
        LOG.debug("About to update {}", anys);
        ArrayList<ProvisioningReport> updResults = new ArrayList<ProvisioningReport>();
        for (Long key : anys) {
            LOG.debug("About to unassign resource {}", (Object)key);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType((String)provision.getAnyType().getKey());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(key);
            AnyTO before = this.getAnyTO(key);
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%d)' not found", provision.getAnyType().getKey(), key));
            }
            if (!this.profile.isDryRun()) {
                Object output;
                AuditElements.Result resultStatus;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    result.setName(this.getName(before));
                    try {
                        if (unlink) {
                            for (SyncActions action : this.profile.getActions()) {
                                action.beforeUnlink(this.getProfile(), delta, before);
                            }
                        } else {
                            for (SyncActions action : this.profile.getActions()) {
                                action.beforeLink(this.getProfile(), delta, before);
                            }
                        }
                        output = this.doLink(before, unlink);
                        for (SyncActions action : this.profile.getActions()) {
                            action.after(this.getProfile(), delta, (AnyTO)AnyTO.class.cast(output), result);
                        }
                        resultStatus = AuditElements.Result.SUCCESS;
                        LOG.debug("{} {} successfully updated", provision.getAnyType().getKey(), (Object)key);
                    }
                    catch (IgnoreProvisionException e) {
                        throw e;
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                        for (SyncActions action : this.profile.getActions()) {
                            action.onError(this.getProfile(), delta, result, (Exception)((Object)e));
                        }
                    }
                    catch (Exception e) {
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                        for (SyncActions action : this.profile.getActions()) {
                            action.onError(this.getProfile(), delta, result, e);
                        }
                    }
                }
                this.audit(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), resultStatus, before, output, delta);
            }
            updResults.add(result);
        }
        return updResults;
    }

    protected List<ProvisioningReport> delete(SyncDelta delta, List<Long> anys, Provision provision) throws JobExecutionException {
        if (!((SyncTask)this.profile.getTask()).isPerformDelete()) {
            LOG.debug("SyncTask not configured for delete");
            return Collections.emptyList();
        }
        LOG.debug("About to delete {}", anys);
        ArrayList<ProvisioningReport> delResults = new ArrayList<ProvisioningReport>();
        SyncDelta workingDelta = delta;
        for (Long key : anys) {
            AuditElements.Result resultStatus = AuditElements.Result.FAILURE;
            ProvisioningReport result = new ProvisioningReport();
            try {
                AnyTO before = this.getAnyTO(key);
                result.setKey(key);
                result.setName(this.getName(before));
                result.setOperation(ResourceOperation.DELETE);
                result.setAnyType((String)provision.getAnyType().getKey());
                result.setStatus(ProvisioningReport.Status.SUCCESS);
                if (!this.profile.isDryRun()) {
                    Exception output;
                    for (SyncActions action : this.profile.getActions()) {
                        workingDelta = action.beforeDelete(this.getProfile(), workingDelta, before);
                    }
                    try {
                        this.doDelete(provision.getAnyType().getKind(), key);
                        output = null;
                        resultStatus = AuditElements.Result.SUCCESS;
                        for (SyncActions action : this.profile.getActions()) {
                            action.after(this.getProfile(), workingDelta, before, result);
                        }
                    }
                    catch (IgnoreProvisionException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not delete {} {}", new Object[]{provision.getAnyType().getKey(), key, e});
                        output = e;
                        for (SyncActions action : this.profile.getActions()) {
                            action.onError(this.getProfile(), workingDelta, result, e);
                        }
                    }
                    this.audit(ResourceOperation.DELETE.name().toLowerCase(), resultStatus, before, output, workingDelta);
                }
                delResults.add(result);
            }
            catch (NotFoundException e) {
                LOG.error("Could not find {} {}", new Object[]{provision.getAnyType().getKey(), key, e});
            }
            catch (DelegatedAdministrationException e) {
                LOG.error("Not allowed to read {} {}", new Object[]{provision.getAnyType().getKey(), key, e});
            }
            catch (Exception e) {
                LOG.error("Could not delete {} {}", new Object[]{provision.getAnyType().getKey(), key, e});
            }
        }
        return delResults;
    }

    private List<ProvisioningReport> ignore(SyncDelta delta, Provision provision, boolean matching) throws JobExecutionException {
        LOG.debug("Any to ignore {}", (Object)delta.getObject().getUid().getUidValue());
        ArrayList<ProvisioningReport> ignoreResults = new ArrayList<ProvisioningReport>();
        ProvisioningReport result = new ProvisioningReport();
        result.setKey(null);
        result.setName(delta.getObject().getUid().getUidValue());
        result.setOperation(ResourceOperation.NONE);
        result.setAnyType((String)provision.getAnyType().getKey());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        ignoreResults.add(result);
        if (!this.profile.isDryRun()) {
            this.audit(matching ? MatchingRule.toEventName((MatchingRule)MatchingRule.IGNORE) : UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.IGNORE), AuditElements.Result.SUCCESS, null, null, delta);
        }
        return ignoreResults;
    }

    protected void doHandle(SyncDelta delta, Provision provision) throws JobExecutionException {
        AnyUtils anyUtils = this.getAnyUtils();
        LOG.debug("Process {} for {} as {}", new Object[]{delta.getDeltaType(), delta.getUid().getUidValue(), delta.getObject().getObjectClass()});
        String uid = delta.getPreviousUid() == null ? delta.getUid().getUidValue() : delta.getPreviousUid().getUidValue();
        try {
            List<Long> anyKeys = this.syncUtilities.findExisting(uid, delta.getObject(), provision, anyUtils);
            LOG.debug("Match(es) found for {} as {}: {}", new Object[]{delta.getUid().getUidValue(), delta.getObject().getObjectClass(), anyKeys});
            if (anyKeys.size() > 1) {
                switch (this.profile.getResAct()) {
                    case IGNORE: {
                        throw new IllegalStateException("More than one match " + anyKeys);
                    }
                    case FIRSTMATCH: {
                        anyKeys = anyKeys.subList(0, 1);
                        break;
                    }
                    case LASTMATCH: {
                        anyKeys = anyKeys.subList(anyKeys.size() - 1, anyKeys.size());
                        break;
                    }
                }
            }
            if (SyncDeltaType.CREATE_OR_UPDATE == delta.getDeltaType()) {
                if (anyKeys.isEmpty()) {
                    switch (((SyncTask)this.profile.getTask()).getUnmatchingRule()) {
                        case ASSIGN: {
                            this.profile.getResults().addAll(this.assign(delta, provision, anyUtils));
                            break;
                        }
                        case PROVISION: {
                            this.profile.getResults().addAll(this.provision(delta, provision, anyUtils));
                            break;
                        }
                        case IGNORE: {
                            this.profile.getResults().addAll(this.ignore(delta, provision, false));
                            break;
                        }
                    }
                } else {
                    for (VirSchema virSchema : this.virSchemaDAO.findByProvision(provision)) {
                        Attribute attr = delta.getObject().getAttributeByName(virSchema.getExtAttrName());
                        for (Long anyKey : anyKeys) {
                            if (attr == null) {
                                this.virAttrCache.expire((String)provision.getAnyType().getKey(), anyKey, (String)virSchema.getKey());
                                continue;
                            }
                            VirAttrCacheValue cacheValue = new VirAttrCacheValue();
                            cacheValue.setValues((Collection)attr.getValue());
                            this.virAttrCache.put((String)provision.getAnyType().getKey(), anyKey, (String)virSchema.getKey(), cacheValue);
                        }
                    }
                    switch (((SyncTask)this.profile.getTask()).getMatchingRule()) {
                        case UPDATE: {
                            this.profile.getResults().addAll(this.update(delta, anyKeys, provision));
                            break;
                        }
                        case DEPROVISION: {
                            this.profile.getResults().addAll(this.deprovision(delta, anyKeys, provision, false));
                            break;
                        }
                        case UNASSIGN: {
                            this.profile.getResults().addAll(this.deprovision(delta, anyKeys, provision, true));
                            break;
                        }
                        case LINK: {
                            this.profile.getResults().addAll(this.link(delta, anyKeys, provision, false));
                            break;
                        }
                        case UNLINK: {
                            this.profile.getResults().addAll(this.link(delta, anyKeys, provision, true));
                            break;
                        }
                        case IGNORE: {
                            this.profile.getResults().addAll(this.ignore(delta, provision, true));
                            break;
                        }
                    }
                }
            } else if (SyncDeltaType.DELETE == delta.getDeltaType()) {
                if (anyKeys.isEmpty()) {
                    LOG.debug("No match found for deletion");
                } else {
                    this.profile.getResults().addAll(this.delete(delta, anyKeys, provision));
                }
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
    }

    private void audit(String event, AuditElements.Result result, Object before, Object output, Object ... input) {
        this.notificationManager.createTasks(AuditElements.EventCategoryType.SYNCHRONIZATION, this.getAnyUtils().getAnyTypeKind().name().toLowerCase(), (String)((SyncTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, input);
        this.auditManager.audit(AuditElements.EventCategoryType.SYNCHRONIZATION, this.getAnyUtils().getAnyTypeKind().name().toLowerCase(), (String)((SyncTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, input);
    }
}

