/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.misc.search.SearchCondConverter;
import org.apache.syncope.core.misc.spring.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.sync.AnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.api.sync.GroupPushResultHandler;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.sync.PushActions;
import org.apache.syncope.core.provisioning.api.sync.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.api.sync.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.sync.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.sync.AnyObjectPushResultHandlerImpl;
import org.apache.syncope.core.provisioning.java.sync.GroupPushResultHandlerImpl;
import org.apache.syncope.core.provisioning.java.sync.UserPushResultHandlerImpl;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class PushJobDelegate
extends AbstractProvisioningJobDelegate<PushTask> {
    private static final int PAGE_SIZE = 1000;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;

    private AnyDAO<?> getAnyDAO(AnyTypeKind anyTypeKind) {
        UserDAO result;
        switch (anyTypeKind) {
            case USER: {
                result = this.userDAO;
                break;
            }
            case GROUP: {
                result = this.groupDAO;
                break;
            }
            default: {
                result = this.anyObjectDAO;
            }
        }
        return result;
    }

    protected void handle(List<? extends Any<?>> anys, SyncopePushResultHandler handler, ExternalResource resource) throws JobExecutionException {
        for (Any<?> any : anys) {
            try {
                handler.handle(((Long)any.getKey()).longValue());
            }
            catch (Exception e) {
                LOG.warn("Failure pushing '{}' on '{}'", new Object[]{any, resource, e});
                throw new JobExecutionException("While pushing " + any + " on " + resource, (Throwable)e);
            }
        }
    }

    @Override
    protected String doExecuteProvisioning(PushTask pushTask, Connector connector, boolean dryRun) throws JobExecutionException {
        LOG.debug("Executing push on {}", (Object)pushTask.getResource());
        ArrayList<PushActions> actions = new ArrayList<PushActions>();
        for (String className : pushTask.getActionsClassNames()) {
            try {
                Class<?> actionsClass = Class.forName(className);
                PushActions syncActions = (PushActions)ApplicationContextProvider.getBeanFactory().createBean(actionsClass, 2, true);
                actions.add(syncActions);
            }
            catch (Exception e) {
                LOG.info("Class '{}' not found", (Object)className, (Object)e);
            }
        }
        ProvisioningProfile profile = new ProvisioningProfile(connector, (ProvisioningTask)pushTask);
        profile.setDryRun(dryRun);
        profile.setResAct(null);
        AnyObjectPushResultHandler ahandler = (AnyObjectPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(AnyObjectPushResultHandlerImpl.class, 1, false);
        ahandler.setProfile(profile);
        UserPushResultHandler uhandler = (UserPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(UserPushResultHandlerImpl.class, 1, false);
        uhandler.setProfile(profile);
        GroupPushResultHandler ghandler = (GroupPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(GroupPushResultHandlerImpl.class, 1, false);
        ghandler.setProfile(profile);
        if (!profile.isDryRun()) {
            for (PushActions action : actions) {
                action.beforeAll(profile);
            }
        }
        for (Provision provision : pushTask.getResource().getProvisions()) {
            String filter;
            UserPushResultHandler handler;
            if (provision.getMapping() == null) continue;
            AnyDAO<?> anyDAO = this.getAnyDAO(provision.getAnyType().getKind());
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = uhandler;
                    break;
                }
                case GROUP: {
                    handler = ghandler;
                    break;
                }
                default: {
                    handler = ahandler;
                }
            }
            String string = filter = pushTask.getFilter(provision.getAnyType()) == null ? null : pushTask.getFilter(provision.getAnyType()).getFIQLCond();
            if (StringUtils.isBlank(filter)) {
                this.handle(anyDAO.findAll(), (SyncopePushResultHandler)handler, pushTask.getResource());
                continue;
            }
            int count = anyDAO.count(SyncopeConstants.FULL_ADMIN_REALMS);
            for (int page = 1; page <= count / 1000 + 1; ++page) {
                List anys = this.searchDAO.search(SyncopeConstants.FULL_ADMIN_REALMS, SearchCondConverter.convert((String)filter, (String[])new String[0]), page, 1000, Collections.emptyList(), provision.getAnyType().getKind());
                this.handle(anys, (SyncopePushResultHandler)handler, pushTask.getResource());
            }
        }
        if (!profile.isDryRun()) {
            for (PushActions action : actions) {
                action.afterAll(profile);
            }
        }
        String result = this.createReport(profile.getResults(), pushTask.getResource().getSyncTraceLevel(), dryRun);
        LOG.debug("Sync result: {}", (Object)result);
        return result;
    }
}

