/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import java.util.Collections;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.task.SyncTask;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.sync.UserSyncResultHandler;
import org.apache.syncope.core.provisioning.java.sync.AbstractSyncResultHandler;
import org.identityconnectors.framework.common.objects.SyncDelta;

public class UserSyncResultHandlerImpl
extends AbstractSyncResultHandler
implements UserSyncResultHandler {
    @Override
    protected AnyUtils getAnyUtils() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
    }

    @Override
    protected String getName(AnyTO anyTO) {
        return ((UserTO)UserTO.class.cast(anyTO)).getUsername();
    }

    @Override
    protected ProvisioningManager<?, ?> getProvisioningManager() {
        return this.userProvisioningManager;
    }

    @Override
    protected Any<?> getAny(long key) {
        try {
            return this.userDAO.authFind(Long.valueOf(key));
        }
        catch (Exception e) {
            LOG.warn("Error retrieving user {}", (Object)key, (Object)e);
            return null;
        }
    }

    @Override
    protected AnyTO getAnyTO(long key) {
        return this.userDataBinder.getUserTO(Long.valueOf(key));
    }

    @Override
    protected AnyPatch newPatch(long key) {
        UserPatch patch = new UserPatch();
        patch.setKey(key);
        return patch;
    }

    @Override
    protected WorkflowResult<Long> update(AnyPatch patch) {
        WorkflowResult update = this.uwfAdapter.update((UserPatch)patch);
        return new WorkflowResult((Object)((UserPatch)((Pair)update.getResult()).getLeft()).getKey(), update.getPropByRes(), update.getPerformedTasks());
    }

    @Override
    protected AnyTO doCreate(AnyTO anyTO, SyncDelta delta, ProvisioningReport result) {
        UserTO userTO = (UserTO)UserTO.class.cast(anyTO);
        Boolean enabled = this.syncUtilities.readEnabled(delta.getObject(), this.profile.getTask());
        Pair created = this.userProvisioningManager.create(userTO, true, true, enabled, Collections.singleton(((SyncTask)this.profile.getTask()).getResource().getKey()), true);
        result.setKey((Long)created.getKey());
        result.setName(this.getName(anyTO));
        return this.getAnyTO((Long)created.getKey());
    }

    @Override
    protected AnyTO doUpdate(AnyTO before, AnyPatch anyPatch, SyncDelta delta, ProvisioningReport result) {
        UserPatch userPatch = (UserPatch)UserPatch.class.cast(anyPatch);
        Boolean enabled = this.syncUtilities.readEnabled(delta.getObject(), this.profile.getTask());
        Pair updated = this.userProvisioningManager.update(userPatch, result, enabled, Collections.singleton(((SyncTask)this.profile.getTask()).getResource().getKey()), true);
        return this.getAnyTO((Long)updated.getKey());
    }

    @Override
    protected void doDelete(AnyTypeKind kind, Long key) {
        try {
            this.userProvisioningManager.delete(key, Collections.singleton(((SyncTask)this.profile.getTask()).getResource().getKey()), true);
        }
        catch (Exception e) {
            LOG.error("Could not propagate user " + key, (Throwable)e);
        }
        this.uwfAdapter.delete(key);
    }
}

