/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.policy.AbstractAccountRuleConf;
import org.apache.syncope.common.lib.policy.AbstractPasswordRuleConf;
import org.apache.syncope.common.lib.policy.AbstractPolicyTO;
import org.apache.syncope.common.lib.policy.AccountPolicyTO;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.PasswordPolicyTO;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.policy.SyncPolicyTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Policy;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.SyncPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.provisioning.api.data.PolicyDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolicyDataBinderImpl
implements PolicyDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyDataBinder.class);
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private EntityFactory entityFactory;

    public <T extends AbstractPolicyTO> T getPolicyTO(Policy policy) {
        SyncPolicyTO policyTO;
        switch (policy.getType()) {
            case PASSWORD: {
                PasswordPolicy passwordPolicy = (PasswordPolicy)PasswordPolicy.class.cast(policy);
                PasswordPolicyTO passwordPolicyTO = new PasswordPolicyTO();
                policyTO = passwordPolicyTO;
                passwordPolicyTO.setAllowNullPassword(passwordPolicy.isAllowNullPassword());
                passwordPolicyTO.setHistoryLength(passwordPolicy.getHistoryLength());
                passwordPolicyTO.getRuleConfs().clear();
                for (PasswordRuleConf ruleConf : passwordPolicy.getRuleConfs()) {
                    passwordPolicyTO.getRuleConfs().add((AbstractPasswordRuleConf)ruleConf);
                }
                break;
            }
            case ACCOUNT: {
                AccountPolicy accountPolicy = (AccountPolicy)AccountPolicy.class.cast(policy);
                AccountPolicyTO accountPolicyTO = new AccountPolicyTO();
                policyTO = accountPolicyTO;
                accountPolicyTO.setMaxAuthenticationAttempts(accountPolicy.getMaxAuthenticationAttempts());
                accountPolicyTO.setPropagateSuspension(accountPolicy.isPropagateSuspension());
                accountPolicyTO.getRuleConfs().clear();
                for (AccountRuleConf ruleConf : accountPolicy.getRuleConfs()) {
                    accountPolicyTO.getRuleConfs().add((AbstractAccountRuleConf)ruleConf);
                }
                accountPolicyTO.getResources().addAll(accountPolicy.getResourceNames());
                break;
            }
            default: {
                policyTO = new SyncPolicyTO();
                policyTO.setSpecification(((SyncPolicy)policy).getSpecification());
            }
        }
        policyTO.setKey(((Long)policy.getKey()).longValue());
        policyTO.setDescription(policy.getDescription());
        for (ExternalResource resource : this.resourceDAO.findByPolicy(policy)) {
            policyTO.getUsedByResources().add(resource.getKey());
        }
        for (Realm realm : this.realmDAO.findByPolicy(policy)) {
            policyTO.getUsedByRealms().add(realm.getFullPath());
        }
        return (T)policyTO;
    }

    public <T extends Policy> T getPolicy(T policy, AbstractPolicyTO policyTO) {
        if (policy != null && policy.getType() != policyTO.getType()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
            sce.getElements().add(String.format("Cannot update %s from %s", policy.getType(), policyTO.getType()));
            throw sce;
        }
        Object result = policy;
        switch (policyTO.getType()) {
            case PASSWORD: {
                if (!(policyTO instanceof PasswordPolicyTO)) {
                    throw new ClassCastException("Expected " + PasswordPolicyTO.class.getName() + ", found " + policyTO.getClass().getName());
                }
                if (result == null) {
                    result = (Policy)this.entityFactory.newEntity(PasswordPolicy.class);
                }
                PasswordPolicy passwordPolicy = (PasswordPolicy)PasswordPolicy.class.cast(result);
                PasswordPolicyTO passwordPolicyTO = (PasswordPolicyTO)PasswordPolicyTO.class.cast(policyTO);
                passwordPolicy.setAllowNullPassword(passwordPolicyTO.isAllowNullPassword());
                passwordPolicy.setHistoryLength(passwordPolicyTO.getHistoryLength());
                passwordPolicy.removeAllRuleConfs();
                for (PasswordRuleConf conf : passwordPolicyTO.getRuleConfs()) {
                    passwordPolicy.add(conf);
                }
                break;
            }
            case ACCOUNT: {
                if (!(policyTO instanceof AccountPolicyTO)) {
                    throw new ClassCastException("Expected " + AccountPolicyTO.class.getName() + ", found " + policyTO.getClass().getName());
                }
                if (result == null) {
                    result = (Policy)this.entityFactory.newEntity(AccountPolicy.class);
                }
                AccountPolicy accountPolicy = (AccountPolicy)AccountPolicy.class.cast(result);
                AccountPolicyTO accountPolicyTO = (AccountPolicyTO)AccountPolicyTO.class.cast(policyTO);
                accountPolicy.setMaxAuthenticationAttempts(accountPolicyTO.getMaxAuthenticationAttempts());
                accountPolicy.setPropagateSuspension(accountPolicyTO.isPropagateSuspension());
                accountPolicy.removeAllRuleConfs();
                for (AccountRuleConf conf : accountPolicyTO.getRuleConfs()) {
                    accountPolicy.add(conf);
                }
                accountPolicy.getResources().clear();
                for (String resourceName : accountPolicyTO.getResources()) {
                    ExternalResource resource = this.resourceDAO.find(resourceName);
                    if (resource == null) {
                        LOG.debug("Ignoring invalid resource {} ", (Object)resourceName);
                        continue;
                    }
                    accountPolicy.add(resource);
                }
                break;
            }
            default: {
                if (!(policyTO instanceof SyncPolicyTO)) {
                    throw new ClassCastException("Expected " + SyncPolicyTO.class.getName() + ", found " + policyTO.getClass().getName());
                }
                if (result == null) {
                    result = (Policy)this.entityFactory.newEntity(SyncPolicy.class);
                }
                ((SyncPolicy)result).setSpecification(((SyncPolicyTO)policyTO).getSpecification());
            }
        }
        result.setDescription(policyTO.getDescription());
        return result;
    }
}

