/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.common.lib.report.AbstractReportletConf;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.to.ReportExecTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.core.misc.spring.BeanUtils;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.provisioning.api.data.ReportDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class ReportDataBinderImpl
implements ReportDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDataBinder.class);
    private static final String[] IGNORE_REPORT_PROPERTIES = new String[]{"key", "reportlets", "executions"};
    private static final String[] IGNORE_REPORT_EXECUTION_PROPERTIES = new String[]{"key", "report", "execResult"};
    @Autowired
    private ReportExecDAO reportExecDAO;
    @Autowired
    private SchedulerFactoryBean scheduler;

    public void getReport(Report report, ReportTO reportTO) {
        BeanUtils.copyProperties((Object)reportTO, (Object)report, (String[])IGNORE_REPORT_PROPERTIES);
        report.removeAllReportletConfs();
        for (ReportletConf conf : reportTO.getReportletConfs()) {
            report.add(conf);
        }
    }

    public ReportTO getReportTO(Report report) {
        Trigger trigger;
        ReportTO reportTO = new ReportTO();
        reportTO.setKey(((Long)report.getKey()).longValue());
        BeanUtils.copyProperties((Object)report, (Object)reportTO, (String[])IGNORE_REPORT_PROPERTIES);
        reportTO.getReportletConfs().clear();
        for (Object reportletConf : report.getReportletConfs()) {
            reportTO.getReportletConfs().add((AbstractReportletConf)reportletConf);
        }
        ReportExec latestExec = this.reportExecDAO.findLatestStarted(report);
        reportTO.setLatestExecStatus(latestExec == null ? "" : latestExec.getStatus());
        reportTO.setStart(latestExec == null ? null : latestExec.getStart());
        reportTO.setEnd(latestExec == null ? null : latestExec.getEnd());
        for (ReportExec reportExec : report.getExecs()) {
            reportTO.getExecutions().add(this.getReportExecTO(reportExec));
        }
        String triggerName = JobNamer.getTriggerName((String)JobNamer.getJobName((Report)report));
        try {
            trigger = this.scheduler.getScheduler().getTrigger(new TriggerKey(triggerName, "DEFAULT"));
        }
        catch (SchedulerException e) {
            LOG.warn("While trying to get to " + triggerName, (Throwable)e);
            trigger = null;
        }
        if (trigger != null) {
            reportTO.setLastExec(trigger.getPreviousFireTime());
            reportTO.setNextExec(trigger.getNextFireTime());
        }
        return reportTO;
    }

    public ReportExecTO getReportExecTO(ReportExec execution) {
        ReportExecTO executionTO = new ReportExecTO();
        executionTO.setKey(((Long)execution.getKey()).longValue());
        BeanUtils.copyProperties((Object)execution, (Object)executionTO, (String[])IGNORE_REPORT_EXECUTION_PROPERTIES);
        if (execution.getKey() != null) {
            executionTO.setKey(((Long)execution.getKey()).longValue());
        }
        executionTO.setReport(((Long)execution.getReport().getKey()).longValue());
        return executionTO;
    }
}

