/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.MappingItemTO;
import org.apache.syncope.common.lib.to.MappingTO;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.IntMappingType;
import org.apache.syncope.core.misc.jexl.JexlUtils;
import org.apache.syncope.core.misc.spring.BeanUtils;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.SyncPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Mapping;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.data.ResourceDataBinder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourceDataBinderImpl
implements ResourceDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDataBinder.class);
    private static final String[] MAPPINGITEM_IGNORE_PROPERTIES = new String[]{"key", "mapping"};
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private PolicyDAO policyDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private EntityFactory entityFactory;

    public ExternalResource create(ResourceTO resourceTO) {
        return this.update((ExternalResource)this.entityFactory.newEntity(ExternalResource.class), resourceTO);
    }

    public ExternalResource update(ExternalResource resource, ResourceTO resourceTO) {
        if (resourceTO == null) {
            return null;
        }
        resource.setKey(resourceTO.getKey());
        if (resourceTO.getConnector() != null) {
            ConnInstance connector = this.connInstanceDAO.find(resourceTO.getConnector());
            resource.setConnector(connector);
            if (!connector.getResources().contains(resource)) {
                connector.add(resource);
            }
        }
        resource.setEnforceMandatoryCondition(resourceTO.isEnforceMandatoryCondition());
        resource.setPropagationPriority(resourceTO.getPropagationPriority());
        resource.setRandomPwdIfNotProvided(resourceTO.isRandomPwdIfNotProvided());
        for (ProvisionTO provisionTO : resourceTO.getProvisions()) {
            AnyType anyType = this.anyTypeDAO.find(provisionTO.getAnyType());
            if (anyType == null) {
                LOG.debug("Invalid {} specified {}, ignoring...", (Object)AnyType.class.getSimpleName(), (Object)provisionTO.getAnyType());
                continue;
            }
            Provision provision = resource.getProvision(anyType);
            if (provision == null) {
                provision = (Provision)this.entityFactory.newEntity(Provision.class);
                provision.setResource(resource);
                resource.add(provision);
                provision.setAnyType(anyType);
            }
            if (provisionTO.getObjectClass() == null) {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidProvision);
                sce.getElements().add("Null " + ObjectClass.class.getSimpleName());
                throw sce;
            }
            provision.setObjectClass(new ObjectClass(provisionTO.getObjectClass()));
            if (provisionTO.getSyncToken() == null) {
                provision.setSyncToken(null);
            }
            if (provisionTO.getMapping() == null) {
                provision.setMapping(null);
            } else {
                Mapping mapping = provision.getMapping();
                if (mapping == null) {
                    mapping = (Mapping)this.entityFactory.newEntity(Mapping.class);
                    mapping.setProvision(provision);
                    provision.setMapping(mapping);
                } else {
                    mapping.getItems().clear();
                }
                this.populateMapping(provisionTO.getMapping(), mapping, (MappingItem)this.entityFactory.newEntity(MappingItem.class));
            }
            if (provisionTO.getVirSchemas().isEmpty()) {
                for (VirSchema schema : this.virSchemaDAO.findByProvision(provision)) {
                    this.virSchemaDAO.delete((String)schema.getKey());
                }
                continue;
            }
            for (String schemaName : provisionTO.getVirSchemas()) {
                VirSchema schema = (VirSchema)this.virSchemaDAO.find(schemaName);
                if (schema == null) {
                    LOG.debug("Invalid {} specified: {}, ignoring...", (Object)VirSchema.class.getSimpleName(), (Object)schemaName);
                    continue;
                }
                schema.setProvision(provision);
            }
        }
        Iterator itor = resource.getProvisions().iterator();
        while (itor.hasNext()) {
            Provision provision = (Provision)itor.next();
            if (resourceTO.getProvision((String)provision.getAnyType().getKey()) != null) continue;
            for (VirSchema schema : this.virSchemaDAO.findByProvision(provision)) {
                this.virSchemaDAO.delete((String)schema.getKey());
            }
            itor.remove();
        }
        resource.setCreateTraceLevel(resourceTO.getCreateTraceLevel());
        resource.setUpdateTraceLevel(resourceTO.getUpdateTraceLevel());
        resource.setDeleteTraceLevel(resourceTO.getDeleteTraceLevel());
        resource.setSyncTraceLevel(resourceTO.getSyncTraceLevel());
        resource.setPasswordPolicy(resourceTO.getPasswordPolicy() == null ? null : (PasswordPolicy)this.policyDAO.find(resourceTO.getPasswordPolicy()));
        resource.setAccountPolicy(resourceTO.getAccountPolicy() == null ? null : (AccountPolicy)this.policyDAO.find(resourceTO.getAccountPolicy()));
        resource.setSyncPolicy(resourceTO.getSyncPolicy() == null ? null : (SyncPolicy)this.policyDAO.find(resourceTO.getSyncPolicy()));
        resource.setConfOverride(new HashSet(resourceTO.getConfOverride()));
        resource.setOverrideCapabilities(resourceTO.isOverrideCapabilities());
        resource.getCapabilitiesOverride().clear();
        resource.getCapabilitiesOverride().addAll(resourceTO.getCapabilitiesOverride());
        resource.getPropagationActionsClassNames().clear();
        resource.getPropagationActionsClassNames().addAll(resourceTO.getPropagationActionsClassNames());
        return resource;
    }

    private void populateMapping(MappingTO mappingTO, Mapping mapping, MappingItem prototype) {
        mapping.setConnObjectLink(mappingTO.getConnObjectLink());
        for (MappingItem item : this.getMappingItems(mappingTO.getItems(), prototype)) {
            item.setMapping(mapping);
            if (item.isConnObjectKey()) {
                mapping.setConnObjectKeyItem(item);
                continue;
            }
            mapping.add(item);
        }
    }

    private Set<MappingItem> getMappingItems(Collection<MappingItemTO> itemTOs, MappingItem prototype) {
        HashSet<MappingItem> items = new HashSet<MappingItem>(itemTOs.size());
        for (MappingItemTO itemTO : itemTOs) {
            items.add(this.getMappingItem(itemTO, prototype));
        }
        return items;
    }

    private MappingItem getMappingItem(MappingItemTO itemTO, MappingItem prototype) {
        if (itemTO == null || itemTO.getIntMappingType() == null) {
            LOG.error("Null mappingTO provided");
            return null;
        }
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        if (itemTO.getIntAttrName() == null) {
            if (IntMappingType.getEmbedded().contains(itemTO.getIntMappingType())) {
                itemTO.setIntAttrName(itemTO.getIntMappingType().toString());
            } else {
                requiredValuesMissing.getElements().add("intAttrName");
            }
        }
        if (!requiredValuesMissing.isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        if (!JexlUtils.isExpressionValid((String)(itemTO.getMandatoryCondition() == null ? "false" : itemTO.getMandatoryCondition()))) {
            SyncopeClientException invalidMandatoryCondition = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
            invalidMandatoryCondition.getElements().add(itemTO.getMandatoryCondition());
            scce.addException(invalidMandatoryCondition);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        MappingItem item = (MappingItem)SerializationUtils.clone((Serializable)prototype);
        BeanUtils.copyProperties((Object)itemTO, (Object)item, (String[])MAPPINGITEM_IGNORE_PROPERTIES);
        return item;
    }

    private void populateMappingTO(Mapping mapping, MappingTO mappingTO) {
        mappingTO.setConnObjectLink(mapping.getConnObjectLink());
        for (MappingItem item : mapping.getItems()) {
            MappingItemTO itemTO = new MappingItemTO();
            itemTO.setKey((Long)item.getKey());
            BeanUtils.copyProperties((Object)item, (Object)itemTO, (String[])MAPPINGITEM_IGNORE_PROPERTIES);
            if (itemTO.isConnObjectKey()) {
                mappingTO.setConnObjectKeyItem(itemTO);
                continue;
            }
            mappingTO.add(itemTO);
        }
    }

    public ResourceTO getResourceTO(ExternalResource resource) {
        ResourceTO resourceTO = new ResourceTO();
        resourceTO.setCreator(resource.getCreator());
        resourceTO.setCreationDate(resource.getCreationDate());
        resourceTO.setLastModifier(resource.getLastModifier());
        resourceTO.setLastChangeDate(resource.getLastChangeDate());
        resourceTO.setKey((String)resource.getKey());
        ConnInstance connector = resource.getConnector();
        resourceTO.setConnector(connector == null ? null : (Long)connector.getKey());
        resourceTO.setConnectorDisplayName(connector == null ? null : connector.getDisplayName());
        for (Provision provision : resource.getProvisions()) {
            ProvisionTO provisionTO = new ProvisionTO();
            provisionTO.setKey(((Long)provision.getKey()).longValue());
            provisionTO.setAnyType((String)provision.getAnyType().getKey());
            provisionTO.setObjectClass(provision.getObjectClass().getObjectClassValue());
            provisionTO.setSyncToken(provision.getSerializedSyncToken());
            if (provision.getMapping() != null) {
                MappingTO mappingTO = new MappingTO();
                provisionTO.setMapping(mappingTO);
                this.populateMappingTO(provision.getMapping(), mappingTO);
            }
            for (VirSchema virSchema : this.virSchemaDAO.findByProvision(provision)) {
                provisionTO.getVirSchemas().add(virSchema.getKey());
                MappingItem linkingMappingItem = virSchema.asLinkingMappingItem();
                MappingItemTO itemTO = new MappingItemTO();
                itemTO.setKey((Long)linkingMappingItem.getKey());
                BeanUtils.copyProperties((Object)linkingMappingItem, (Object)itemTO, (String[])MAPPINGITEM_IGNORE_PROPERTIES);
                provisionTO.getMapping().getLinkingItems().add(itemTO);
            }
            resourceTO.getProvisions().add(provisionTO);
        }
        resourceTO.setEnforceMandatoryCondition(resource.isEnforceMandatoryCondition());
        resourceTO.setPropagationPriority(resource.getPropagationPriority());
        resourceTO.setRandomPwdIfNotProvided(resource.isRandomPwdIfNotProvided());
        resourceTO.setCreateTraceLevel(resource.getCreateTraceLevel());
        resourceTO.setUpdateTraceLevel(resource.getUpdateTraceLevel());
        resourceTO.setDeleteTraceLevel(resource.getDeleteTraceLevel());
        resourceTO.setSyncTraceLevel(resource.getSyncTraceLevel());
        resourceTO.setPasswordPolicy(resource.getPasswordPolicy() == null ? null : (Long)resource.getPasswordPolicy().getKey());
        resourceTO.setAccountPolicy(resource.getAccountPolicy() == null ? null : (Long)resource.getAccountPolicy().getKey());
        resourceTO.setSyncPolicy(resource.getSyncPolicy() == null ? null : (Long)resource.getSyncPolicy().getKey());
        resourceTO.getConfOverride().addAll(resource.getConfOverride());
        resourceTO.setOverrideCapabilities(resource.isOverrideCapabilities());
        resourceTO.getCapabilitiesOverride().addAll(resource.getCapabilitiesOverride());
        resourceTO.getPropagationActionsClassNames().addAll(resource.getPropagationActionsClassNames());
        return resourceTO;
    }
}

