/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.misc.jexl.JexlUtils;
import org.apache.syncope.core.misc.spring.BeanUtils;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.data.SchemaDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SchemaDataBinderImpl
implements SchemaDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaDataBinder.class);
    private static final String[] IGNORE_PROPERTIES = new String[]{"anyTypeClass", "provision", "resource"};
    @Autowired
    private AnyTypeClassDAO anyTypeClassDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    private PlainSchema fill(PlainSchema schema, PlainSchemaTO schemaTO) {
        if (!JexlUtils.isExpressionValid((String)schemaTO.getMandatoryCondition())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
            sce.getElements().add(schemaTO.getMandatoryCondition());
            throw sce;
        }
        BeanUtils.copyProperties((Object)schemaTO, (Object)schema, (String[])IGNORE_PROPERTIES);
        PlainSchema merged = (PlainSchema)this.plainSchemaDAO.save((Schema)schema);
        if (!(schemaTO.getAnyTypeClass() == null || merged.getAnyTypeClass() != null && schemaTO.getAnyTypeClass().equals(merged.getAnyTypeClass().getKey()))) {
            AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(schemaTO.getAnyTypeClass());
            if (anyTypeClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + "{}, ignoring...", (Object)schemaTO.getAnyTypeClass());
            } else {
                anyTypeClass.add(merged);
                merged.setAnyTypeClass(anyTypeClass);
            }
        } else if (schemaTO.getAnyTypeClass() == null && merged.getAnyTypeClass() != null) {
            merged.getAnyTypeClass().remove(merged);
            merged.setAnyTypeClass(null);
        }
        return merged;
    }

    public PlainSchema create(PlainSchemaTO schemaTO) {
        return this.fill((PlainSchema)this.entityFactory.newEntity(PlainSchema.class), schemaTO);
    }

    public PlainSchema update(PlainSchemaTO schemaTO, PlainSchema schema) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        boolean hasAttrs = false;
        for (AnyTypeKind anyTypeKind : AnyTypeKind.values()) {
            AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyTypeKind);
            hasAttrs |= this.plainSchemaDAO.findAttrs(schema, anyUtils.plainAttrClass()).isEmpty();
        }
        if (hasAttrs) {
            SyncopeClientException e;
            if (schema.getType() != schemaTO.getType()) {
                e = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPlainSchema);
                e.getElements().add("Cannot change type since " + (String)schema.getKey() + " has attributes");
                scce.addException(e);
            }
            if (schema.isUniqueConstraint() != schemaTO.isUniqueConstraint()) {
                e = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPlainSchema);
                e.getElements().add("Cannot alter unique contraint since " + (String)schema.getKey() + " has attributes");
                scce.addException(e);
            }
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        return this.fill(schema, schemaTO);
    }

    public PlainSchemaTO getPlainSchemaTO(PlainSchema schema) {
        PlainSchemaTO schemaTO = new PlainSchemaTO();
        BeanUtils.copyProperties((Object)schema, (Object)schemaTO, (String[])IGNORE_PROPERTIES);
        schemaTO.setAnyTypeClass(schema.getAnyTypeClass() == null ? null : (String)schema.getAnyTypeClass().getKey());
        return schemaTO;
    }

    private DerSchema fill(DerSchema schema, DerSchemaTO schemaTO) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        if (StringUtils.isBlank((CharSequence)schemaTO.getExpression())) {
            SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            requiredValuesMissing.getElements().add("expression");
            scce.addException(requiredValuesMissing);
        } else if (!JexlUtils.isExpressionValid((String)schemaTO.getExpression())) {
            SyncopeClientException e = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
            e.getElements().add(schemaTO.getExpression());
            scce.addException(e);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        BeanUtils.copyProperties((Object)schemaTO, (Object)schema, (String[])IGNORE_PROPERTIES);
        DerSchema merged = (DerSchema)this.derSchemaDAO.save((Schema)schema);
        if (!(schemaTO.getAnyTypeClass() == null || merged.getAnyTypeClass() != null && schemaTO.getAnyTypeClass().equals(merged.getAnyTypeClass().getKey()))) {
            AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(schemaTO.getAnyTypeClass());
            if (anyTypeClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + "{}, ignoring...", (Object)schemaTO.getAnyTypeClass());
            } else {
                anyTypeClass.add(merged);
                merged.setAnyTypeClass(anyTypeClass);
            }
        } else if (schemaTO.getAnyTypeClass() == null && merged.getAnyTypeClass() != null) {
            merged.getAnyTypeClass().remove(merged);
            merged.setAnyTypeClass(null);
        }
        return merged;
    }

    public DerSchema create(DerSchemaTO schemaTO) {
        return this.fill((DerSchema)this.entityFactory.newEntity(DerSchema.class), schemaTO);
    }

    public DerSchema update(DerSchemaTO schemaTO, DerSchema schema) {
        return this.fill(schema, schemaTO);
    }

    public DerSchemaTO getDerSchemaTO(DerSchema schema) {
        DerSchemaTO schemaTO = new DerSchemaTO();
        BeanUtils.copyProperties((Object)schema, (Object)schemaTO, (String[])IGNORE_PROPERTIES);
        schemaTO.setAnyTypeClass(schema.getAnyTypeClass() == null ? null : (String)schema.getAnyTypeClass().getKey());
        return schemaTO;
    }

    private VirSchema fill(VirSchema schema, VirSchemaTO schemaTO) {
        BeanUtils.copyProperties((Object)schemaTO, (Object)schema, (String[])IGNORE_PROPERTIES);
        if (!(schemaTO.getAnyTypeClass() == null || schema.getAnyTypeClass() != null && schemaTO.getAnyTypeClass().equals(schema.getAnyTypeClass().getKey()))) {
            AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(schemaTO.getAnyTypeClass());
            if (anyTypeClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + "{}, ignoring...", (Object)schemaTO.getAnyTypeClass());
            } else {
                anyTypeClass.add(schema);
                schema.setAnyTypeClass(anyTypeClass);
            }
        } else if (schemaTO.getAnyTypeClass() == null && schema.getAnyTypeClass() != null) {
            schema.getAnyTypeClass().remove(schema);
            schema.setAnyTypeClass(null);
        }
        Provision provision = this.resourceDAO.findProvision(Long.valueOf(schemaTO.getProvision()));
        if (provision == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSchemaDefinition);
            sce.getElements().add("Provision " + schemaTO.getProvision() + " not found");
            throw sce;
        }
        schema.setProvision(provision);
        return (VirSchema)this.virSchemaDAO.save((Schema)schema);
    }

    public VirSchema create(VirSchemaTO schemaTO) {
        return this.fill((VirSchema)this.entityFactory.newEntity(VirSchema.class), schemaTO);
    }

    public VirSchema update(VirSchemaTO schemaTO, VirSchema schema) {
        return this.fill(schema, schemaTO);
    }

    public VirSchemaTO getVirSchemaTO(VirSchema schema) {
        VirSchemaTO schemaTO = new VirSchemaTO();
        BeanUtils.copyProperties((Object)schema, (Object)schemaTO, (String[])IGNORE_PROPERTIES);
        schemaTO.setAnyTypeClass(schema.getAnyTypeClass() == null ? null : (String)schema.getAnyTypeClass().getKey());
        schemaTO.setResource((String)schema.getProvision().getResource().getKey());
        schemaTO.setProvision(((Long)schema.getProvision().getKey()).longValue());
        return schemaTO;
    }
}

