/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.PropagationByResource;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.misc.security.AuthContextUtils;
import org.apache.syncope.core.misc.security.Encryptor;
import org.apache.syncope.core.misc.spring.BeanUtils;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.search.AssignableCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class UserDataBinderImpl
extends AbstractAnyDataBinder
implements UserDataBinder {
    private static final String[] IGNORE_PROPERTIES = new String[]{"type", "realm", "auxClasses", "roles", "dynRoles", "relationships", "memberships", "dynGroups", "plainAttrs", "derAttrs", "virAttrs", "resources", "securityQuestion", "securityAnswer"};
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private SecurityQuestionDAO securityQuestionDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Resource(name="adminUser")
    private String adminUser;
    @Resource(name="anonymousUser")
    private String anonymousUser;
    private final Encryptor encryptor = Encryptor.getInstance();

    @Transactional(readOnly=true)
    public UserTO returnUserTO(UserTO userTO) {
        if (!((CPlainAttrValue)this.confDAO.find("return.password.value", "false").getValues().get(0)).getBooleanValue().booleanValue()) {
            userTO.setPassword(null);
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getAuthenticatedUserTO() {
        UserTO authUserTO;
        String authUsername = AuthContextUtils.getUsername();
        if (this.anonymousUser.equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(-2L);
            authUserTO.setUsername(this.anonymousUser);
        } else if (this.adminUser.equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(-1L);
            authUserTO.setUsername(this.adminUser);
        } else {
            User authUser = this.userDAO.find(authUsername);
            authUserTO = this.getUserTO(authUser, true);
        }
        return authUserTO;
    }

    @Transactional(readOnly=true)
    public boolean verifyPassword(String username, String password) {
        return this.verifyPassword(this.userDAO.authFind(username), password);
    }

    @Transactional(readOnly=true)
    public boolean verifyPassword(User user, String password) {
        return this.encryptor.verify(password, user.getCipherAlgorithm(), user.getPassword());
    }

    private void setPassword(User user, String password, SyncopeClientCompositeException scce) {
        try {
            String algorithm = ((CPlainAttrValue)this.confDAO.find("password.cipher.algorithm", CipherAlgorithm.AES.name()).getValues().get(0)).getStringValue();
            CipherAlgorithm predefined = CipherAlgorithm.valueOf((String)algorithm);
            user.setPassword(password, predefined);
        }
        catch (IllegalArgumentException e) {
            SyncopeClientException invalidCiperAlgorithm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.NotFound);
            invalidCiperAlgorithm.getElements().add(e.getMessage());
            scce.addException(invalidCiperAlgorithm);
            throw scce;
        }
    }

    public void create(User user, UserTO userTO, boolean storePassword) {
        SecurityQuestion securityQuestion;
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        for (String roleKey : userTO.getRoles()) {
            Role role = this.roleDAO.find(roleKey);
            if (role == null) {
                LOG.warn("Ignoring unknown role with id {}", (Object)roleKey);
                continue;
            }
            user.add(role);
        }
        Realm realm = this.realmDAO.find(userTO.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + userTO.getRealm());
            scce.addException(noRealm);
        }
        user.setRealm(realm);
        if (user.getRealm() != null) {
            AssignableCond assignableCond = new AssignableCond();
            assignableCond.setRealmFullPath(user.getRealm().getFullPath());
            List assignableAnyObjects = this.searchDAO.search(SearchCond.getLeafCond((AssignableCond)assignableCond), AnyTypeKind.ANY_OBJECT);
            for (RelationshipTO relationshipTO : userTO.getRelationships()) {
                AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(Long.valueOf(relationshipTO.getRightKey()));
                if (otherEnd == null) {
                    LOG.debug("Ignoring invalid anyObject " + relationshipTO.getRightKey());
                    continue;
                }
                if (assignableAnyObjects.contains(otherEnd)) {
                    RelationshipType relationshipType = this.relationshipTypeDAO.find(relationshipTO.getType());
                    if (relationshipType == null) {
                        LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType());
                        continue;
                    }
                    URelationship relationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                    relationship.setType(relationshipType);
                    relationship.setRightEnd((Any)otherEnd);
                    relationship.setLeftEnd((Any)user);
                    user.add(relationship);
                    continue;
                }
                LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)user);
                SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                unassignabled.getElements().add("Cannot be assigned: " + otherEnd);
                scce.addException(unassignabled);
            }
            List assignableGroups = this.searchDAO.search(SearchCond.getLeafCond((AssignableCond)assignableCond), AnyTypeKind.GROUP);
            for (MembershipTO membershipTO : userTO.getMemberships()) {
                Group group = (Group)this.groupDAO.find(Long.valueOf(membershipTO.getRightKey()));
                if (group == null) {
                    LOG.debug("Ignoring invalid group " + membershipTO.getGroupName());
                    continue;
                }
                if (assignableGroups.contains(group)) {
                    UMembership membership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                    membership.setRightEnd((Any)group);
                    membership.setLeftEnd((Any)user);
                    user.add(membership);
                    continue;
                }
                LOG.error("{} cannot be assigned to {}", (Object)group, (Object)user);
                SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                unassignabled.getElements().add("Cannot be assigned: " + group);
                scce.addException(unassignabled);
            }
        }
        this.fill((Any)user, (AnyTO)userTO, this.anyUtilsFactory.getInstance(AnyTypeKind.USER), scce);
        if (StringUtils.isBlank((CharSequence)userTO.getPassword()) || !storePassword) {
            LOG.debug("Password was not provided or not required to be stored");
        } else {
            this.setPassword(user, userTO.getPassword(), scce);
        }
        user.setUsername(userTO.getUsername());
        if (userTO.getSecurityQuestion() != null && (securityQuestion = this.securityQuestionDAO.find(userTO.getSecurityQuestion())) != null) {
            user.setSecurityQuestion(securityQuestion);
        }
        user.setSecurityAnswer(userTO.getSecurityAnswer());
        user.setMustChangePassword(userTO.isMustChangePassword());
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    private boolean isPasswordMapped(ExternalResource resource) {
        boolean result = false;
        Provision provision = resource.getProvision(this.anyTypeDAO.findUser());
        if (provision != null && provision.getMapping() != null) {
            result = IterableUtils.matchesAny((Iterable)provision.getMapping().getItems(), (Predicate)new Predicate<MappingItem>(){

                public boolean evaluate(MappingItem item) {
                    return item.isPassword();
                }
            });
        }
        return result;
    }

    public PropagationByResource update(User toBeUpdated, UserPatch userPatch) {
        Object unassignabled;
        User user = (User)this.userDAO.save((Any)toBeUpdated);
        PropagationByResource propByRes = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        Collection currentResources = this.userDAO.findAllResourceNames(user);
        Map<String, String> oldConnObjectKeys = this.getConnObjectKeys((Any<?>)user);
        this.setRealm((Any<?>)user, (AnyPatch)userPatch);
        if (userPatch.getPassword() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)userPatch.getPassword().getValue()))) {
            if (userPatch.getPassword().isOnSyncope()) {
                this.setPassword(user, (String)userPatch.getPassword().getValue(), scce);
                user.setChangePwdDate(new Date());
            }
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)userPatch.getPassword().getResources());
        }
        if (userPatch.getUsername() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)userPatch.getUsername().getValue()))) {
            String oldUsername = user.getUsername();
            user.setUsername((String)userPatch.getUsername().getValue());
            if (oldUsername.equals(AuthContextUtils.getUsername())) {
                AuthContextUtils.updateUsername((String)((String)userPatch.getUsername().getValue()));
            }
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        if (userPatch.getSecurityQuestion() != null) {
            if (userPatch.getSecurityQuestion().getValue() == null) {
                user.setSecurityQuestion(null);
                user.setSecurityAnswer(null);
            } else {
                SecurityQuestion securityQuestion = this.securityQuestionDAO.find((Long)userPatch.getSecurityQuestion().getValue());
                if (securityQuestion != null) {
                    user.setSecurityQuestion(securityQuestion);
                    user.setSecurityAnswer((String)userPatch.getSecurityAnswer().getValue());
                }
            }
        }
        if (userPatch.getMustChangePassword() != null) {
            user.setMustChangePassword(((Boolean)userPatch.getMustChangePassword().getValue()).booleanValue());
        }
        block3: for (StringPatchItem patch : userPatch.getRoles()) {
            Role role = this.roleDAO.find((String)patch.getValue());
            if (role == null) {
                LOG.warn("Ignoring unknown role with key {}", patch.getValue());
                continue;
            }
            switch (patch.getOperation()) {
                case ADD_REPLACE: {
                    user.add(role);
                    continue block3;
                }
            }
            user.remove(role);
        }
        propByRes.merge(this.fill((Any<?>)user, (AnyPatch)userPatch, this.anyUtilsFactory.getInstance(AnyTypeKind.USER), scce));
        HashSet toBeDeprovisioned = new HashSet();
        HashSet toBeProvisioned = new HashSet();
        List assignableAnyObjects = this.searchDAO.searchAssignable(user.getRealm().getFullPath(), AnyTypeKind.ANY_OBJECT);
        for (Object patch : userPatch.getRelationships()) {
            if (patch.getRelationshipTO() == null) continue;
            RelationshipType relationshipType = this.relationshipTypeDAO.find(patch.getRelationshipTO().getType());
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch.getRelationshipTO().getType());
                continue;
            }
            URelationship relationship = user.getRelationship(relationshipType, Long.valueOf(patch.getRelationshipTO().getRightKey()));
            if (relationship != null) {
                user.remove(relationship);
                toBeDeprovisioned.addAll(((AnyObject)relationship.getRightEnd()).getResourceNames());
            }
            if (patch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(Long.valueOf(patch.getRelationshipTO().getRightKey()));
            if (otherEnd == null) {
                LOG.debug("Ignoring invalid any object {}", (Object)patch.getRelationshipTO().getRightKey());
                continue;
            }
            if (assignableAnyObjects.contains(otherEnd)) {
                relationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                relationship.setType(relationshipType);
                relationship.setRightEnd((Any)otherEnd);
                relationship.setLeftEnd((Any)user);
                user.add(relationship);
                toBeProvisioned.addAll(otherEnd.getResourceNames());
                continue;
            }
            LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)user);
            unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
            unassignabled.getElements().add("Cannot be assigned: " + otherEnd);
            scce.addException((SyncopeClientException)unassignabled);
        }
        List assignableGroups = this.searchDAO.searchAssignable(user.getRealm().getFullPath(), AnyTypeKind.GROUP);
        for (MembershipPatch patch : userPatch.getMemberships()) {
            if (patch.getMembershipTO() == null) continue;
            UMembership membership = user.getMembership(Long.valueOf(patch.getMembershipTO().getRightKey()));
            if (membership != null) {
                user.remove(membership);
                toBeDeprovisioned.addAll(((Group)membership.getRightEnd()).getResourceNames());
            }
            if (patch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            Group group = (Group)this.groupDAO.find(Long.valueOf(patch.getMembershipTO().getRightKey()));
            if (group == null) {
                LOG.debug("Ignoring invalid group {}", (Object)patch.getMembershipTO().getRightKey());
                continue;
            }
            if (assignableGroups.contains(group)) {
                membership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                membership.setRightEnd((Any)group);
                membership.setLeftEnd((Any)user);
                user.add(membership);
                toBeProvisioned.addAll(group.getResourceNames());
                if (!toBeUpdated.canDecodePassword()) continue;
                if (userPatch.getPassword() == null) {
                    userPatch.setPassword(new PasswordPatch());
                }
                for (ExternalResource resource : group.getResources()) {
                    if (!this.isPasswordMapped(resource)) continue;
                    userPatch.getPassword().getResources().add(resource.getKey());
                }
                continue;
            }
            LOG.error("{} cannot be assigned to {}", (Object)group, (Object)user);
            unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
            unassignabled.getElements().add("Cannot be assigned: " + group);
            scce.addException((SyncopeClientException)unassignabled);
        }
        propByRes.addAll(ResourceOperation.DELETE, toBeDeprovisioned);
        propByRes.addAll(ResourceOperation.UPDATE, toBeProvisioned);
        if (!toBeDeprovisioned.isEmpty() || !toBeProvisioned.isEmpty()) {
            currentResources.removeAll(toBeDeprovisioned);
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        Map<String, String> newcCnnObjectKeys = this.getConnObjectKeys((Any<?>)user);
        for (Map.Entry<String, String> entry : oldConnObjectKeys.entrySet()) {
            if (!newcCnnObjectKeys.containsKey(entry.getKey()) || entry.getValue().equals(newcCnnObjectKeys.get(entry.getKey()))) continue;
            propByRes.addOldConnObjectKey(entry.getKey(), entry.getValue());
            propByRes.add(ResourceOperation.UPDATE, entry.getKey());
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        return propByRes;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(User user, boolean details) {
        UserTO userTO = new UserTO();
        BeanUtils.copyProperties((Object)user, (Object)userTO, (String[])IGNORE_PROPERTIES);
        if (user.getSecurityQuestion() != null) {
            userTO.setSecurityQuestion((Long)user.getSecurityQuestion().getKey());
        }
        Map derAttrValues = this.derAttrHandler.getValues((Any)user);
        Map virAttrValues = details ? this.virAttrHander.getValues((Any)user) : Collections.emptyMap();
        this.fillTO((AnyTO)userTO, user.getRealm().getFullPath(), user.getAuxClasses(), user.getPlainAttrs(), derAttrValues, virAttrValues, this.userDAO.findAllResources(user));
        if (details) {
            CollectionUtils.collect((Iterable)user.getRoles(), (Transformer)new Transformer<Role, String>(){

                public String transform(Role role) {
                    return (String)role.getKey();
                }
            }, (Collection)userTO.getRoles());
            CollectionUtils.collect((Iterable)user.getRelationships(), (Transformer)new Transformer<URelationship, RelationshipTO>(){

                public RelationshipTO transform(URelationship relationship) {
                    return UserDataBinderImpl.this.getRelationshipTO((Relationship<? extends Any<?>, AnyObject>)relationship);
                }
            }, (Collection)userTO.getRelationships());
            CollectionUtils.collect((Iterable)user.getMemberships(), (Transformer)new Transformer<UMembership, MembershipTO>(){

                public MembershipTO transform(UMembership membership) {
                    return UserDataBinderImpl.this.getMembershipTO((Membership<? extends Any<?>>)membership);
                }
            }, (Collection)userTO.getMemberships());
            CollectionUtils.collect((Iterable)this.userDAO.findDynRoleMemberships(user), (Transformer)new Transformer<Role, String>(){

                public String transform(Role role) {
                    return (String)role.getKey();
                }
            }, (Collection)userTO.getDynRoles());
            CollectionUtils.collect((Iterable)this.userDAO.findDynGroupMemberships(user), (Transformer)new Transformer<Group, Long>(){

                public Long transform(Group group) {
                    return (Long)group.getKey();
                }
            }, (Collection)userTO.getDynGroups());
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(String username) {
        return this.getUserTO(this.userDAO.authFind(username), true);
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(Long key) {
        return this.getUserTO((User)this.userDAO.authFind(key), true);
    }
}

