/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationActions;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DBPasswordPropagationActions
extends DefaultPropagationActions {
    private static final String CLEARTEXT = "CLEARTEXT";
    @Autowired
    private UserDAO userDAO;

    @Override
    @Transactional(readOnly=true)
    public void before(PropagationTask task, ConnectorObject beforeObj) {
        User user;
        super.before(task, beforeObj);
        if (AnyTypeKind.USER == task.getAnyTypeKind() && (user = (User)this.userDAO.find(task.getAnyKey())) != null && user.getPassword() != null) {
            Attribute missing = AttributeUtil.find((String)"__MANDATORY_MISSING__", (Set)task.getAttributes());
            ConnInstance connInstance = task.getResource().getConnector();
            if (missing != null && missing.getValue() != null && missing.getValue().size() == 1 && missing.getValue().get(0).equals(OperationalAttributes.PASSWORD_NAME) && this.cipherAlgorithmMatches(this.getCipherAlgorithm(connInstance), user.getCipherAlgorithm())) {
                Attribute passwordAttribute = AttributeBuilder.buildPassword((GuardedString)new GuardedString(user.getPassword().toCharArray()));
                HashSet<Attribute> attributes = new HashSet<Attribute>(task.getAttributes());
                attributes.add(passwordAttribute);
                attributes.remove(missing);
                Attribute hashedPasswordAttribute = AttributeBuilder.build((String)AttributeUtil.createSpecialName((String)"HASHED_PASSWORD"), (Object[])new Object[]{Boolean.TRUE});
                attributes.add(hashedPasswordAttribute);
                task.setAttributes(attributes);
            }
        }
    }

    private String getCipherAlgorithm(ConnInstance connInstance) {
        ConnConfProperty cipherAlgorithm = (ConnConfProperty)IterableUtils.find((Iterable)connInstance.getConf(), (Predicate)new Predicate<ConnConfProperty>(){

            public boolean evaluate(ConnConfProperty property) {
                return "cipherAlgorithm".equals(property.getSchema().getName()) && property.getValues() != null && !property.getValues().isEmpty();
            }
        });
        return cipherAlgorithm == null ? CLEARTEXT : (String)cipherAlgorithm.getValues().get(0);
    }

    private boolean cipherAlgorithmMatches(String connectorAlgorithm, CipherAlgorithm userAlgorithm) {
        if (userAlgorithm == null) {
            return false;
        }
        if (connectorAlgorithm.equals(userAlgorithm.name())) {
            return true;
        }
        return "SHA1".equals(connectorAlgorithm) && "SHA".equals(userAlgorithm.name());
    }
}

