/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PropagationByResource;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.misc.jexl.JexlUtils;
import org.apache.syncope.core.misc.utils.ConnObjectUtils;
import org.apache.syncope.core.misc.utils.MappingUtils;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class PropagationManagerImpl
implements PropagationManager {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationManager.class);
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected ExternalResourceDAO resourceDAO;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected MappingUtils mappingUtils;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;

    protected Any<?> find(AnyTypeKind kind, Long key) {
        AnyObjectDAO dao;
        switch (kind) {
            case ANY_OBJECT: {
                dao = this.anyObjectDAO;
                break;
            }
            case GROUP: {
                dao = this.groupDAO;
                break;
            }
            default: {
                dao = this.userDAO;
            }
        }
        return dao.authFind(key);
    }

    public List<PropagationTask> getCreateTasks(AnyTypeKind kind, Long key, PropagationByResource propByRes, Collection<AttrTO> vAttrs, Collection<String> noPropResourceNames) {
        return this.getCreateTasks(this.find(kind, key), null, null, propByRes, vAttrs, noPropResourceNames);
    }

    public List<PropagationTask> getUserCreateTasks(Long key, String password, Boolean enable, PropagationByResource propByRes, Collection<AttrTO> vAttrs, Collection<String> noPropResourceNames) {
        return this.getCreateTasks(this.userDAO.authFind(key), password, enable, propByRes, vAttrs, noPropResourceNames);
    }

    protected List<PropagationTask> getCreateTasks(Any<?> any, String password, Boolean enable, PropagationByResource propByRes, Collection<AttrTO> vAttrs, Collection<String> noPropResourceNames) {
        if (propByRes == null || propByRes.isEmpty()) {
            return Collections.emptyList();
        }
        if (noPropResourceNames != null) {
            propByRes.get(ResourceOperation.CREATE).removeAll(noPropResourceNames);
        }
        return this.createTasks(any, password, true, enable, false, propByRes, vAttrs);
    }

    public List<PropagationTask> getUpdateTasks(AnyTypeKind kind, Long key, boolean changePwd, Boolean enable, PropagationByResource propByRes, Collection<AttrTO> vAttrs, Collection<String> noPropResourceNames) {
        return this.getUpdateTasks(this.find(kind, key), null, changePwd, enable, propByRes, vAttrs, noPropResourceNames);
    }

    public List<PropagationTask> getUserUpdateTasks(WorkflowResult<Pair<UserPatch, Boolean>> wfResult, boolean changePwd, Collection<String> noPropResourceNames) {
        return this.getUpdateTasks(this.userDAO.authFind(Long.valueOf(((UserPatch)((Pair)wfResult.getResult()).getKey()).getKey())), ((UserPatch)((Pair)wfResult.getResult()).getKey()).getPassword() == null ? null : (String)((UserPatch)((Pair)wfResult.getResult()).getKey()).getPassword().getValue(), changePwd, (Boolean)((Pair)wfResult.getResult()).getValue(), wfResult.getPropByRes(), (Collection<AttrTO>)((UserPatch)((Pair)wfResult.getResult()).getKey()).getVirAttrs(), noPropResourceNames);
    }

    public List<PropagationTask> getUserUpdateTasks(WorkflowResult<Pair<UserPatch, Boolean>> wfResult) {
        UserPatch userPatch = (UserPatch)((Pair)wfResult.getResult()).getKey();
        ArrayList<PropagationTask> tasks = new ArrayList();
        if (userPatch.getPassword() == null) {
            tasks = this.getUserUpdateTasks(wfResult, false, null);
        } else {
            PropagationByResource origPropByRes = new PropagationByResource();
            origPropByRes.merge(wfResult.getPropByRes());
            HashSet<String> pwdResourceNames = new HashSet<String>(userPatch.getPassword().getResources());
            Collection currentResourceNames = this.userDAO.findAllResourceNames((User)this.userDAO.authFind(Long.valueOf(userPatch.getKey())));
            pwdResourceNames.retainAll(currentResourceNames);
            PropagationByResource pwdPropByRes = new PropagationByResource();
            pwdPropByRes.addAll(ResourceOperation.UPDATE, pwdResourceNames);
            if (!pwdPropByRes.isEmpty()) {
                HashSet<String> toBeExcluded = new HashSet<String>(currentResourceNames);
                toBeExcluded.addAll(CollectionUtils.collect((Iterable)userPatch.getResources(), (Transformer)new Transformer<StringPatchItem, String>(){

                    public String transform(StringPatchItem input) {
                        return (String)input.getValue();
                    }
                }));
                toBeExcluded.removeAll(pwdResourceNames);
                tasks.addAll(this.getUserUpdateTasks(wfResult, true, toBeExcluded));
            }
            PropagationByResource nonPwdPropByRes = new PropagationByResource();
            nonPwdPropByRes.merge(origPropByRes);
            nonPwdPropByRes.removeAll(pwdResourceNames);
            nonPwdPropByRes.purge();
            if (!nonPwdPropByRes.isEmpty()) {
                tasks.addAll(this.getUserUpdateTasks(wfResult, false, pwdResourceNames));
            }
        }
        return tasks;
    }

    protected List<PropagationTask> getUpdateTasks(Any<?> any, String password, boolean changePwd, Boolean enable, PropagationByResource propByRes, Collection<AttrTO> vAttrs, Collection<String> noPropResourceNames) {
        if (noPropResourceNames != null) {
            propByRes.removeAll(noPropResourceNames);
        }
        return this.createTasks(any, password, changePwd, enable, false, propByRes, vAttrs);
    }

    public List<PropagationTask> getDeleteTasks(AnyTypeKind kind, Long key, PropagationByResource propByRes, Collection<String> noPropResourceNames) {
        Any<?> any = this.find(kind, key);
        PropagationByResource localPropByRes = new PropagationByResource();
        if (propByRes == null || propByRes.isEmpty()) {
            localPropByRes.addAll(ResourceOperation.DELETE, (Collection)any.getResourceNames());
        } else {
            localPropByRes.merge(propByRes);
        }
        if (noPropResourceNames != null) {
            localPropByRes.removeAll(noPropResourceNames);
        }
        return this.getDeleteTasks(any, localPropByRes, noPropResourceNames);
    }

    protected List<PropagationTask> getDeleteTasks(Any<?> any, PropagationByResource propByRes, Collection<String> noPropResourceNames) {
        return this.createTasks(any, null, false, false, true, propByRes, null);
    }

    protected List<PropagationTask> createTasks(Any<?> any, String password, boolean changePwd, Boolean enable, boolean deleteOnResource, PropagationByResource propByRes, Collection<AttrTO> vAttrs) {
        LOG.debug("Provisioning {}:\n{}", any, (Object)propByRes);
        propByRes.purge();
        LOG.debug("After purge {}:\n{}", any, (Object)propByRes);
        HashSet virtualResources = new HashSet();
        virtualResources.addAll(propByRes.get(ResourceOperation.CREATE));
        virtualResources.addAll(propByRes.get(ResourceOperation.UPDATE));
        if (any instanceof User) {
            virtualResources.addAll(this.userDAO.findAllResourceNames((User)any));
        } else if (any instanceof AnyObject) {
            virtualResources.addAll(this.anyObjectDAO.findAllResourceNames((AnyObject)any));
        } else {
            virtualResources.addAll(((Group)any).getResourceNames());
        }
        HashMap<Object, HashSet<Attribute>> vAttrMap = new HashMap<Object, HashSet<Attribute>>();
        for (AttrTO vAttr : CollectionUtils.emptyIfNull(vAttrs)) {
            VirSchema schema = (VirSchema)this.virSchemaDAO.find(vAttr.getSchema());
            if (schema == null) {
                LOG.warn("Ignoring invalid {} {}", (Object)VirSchema.class.getSimpleName(), (Object)vAttr.getSchema());
                continue;
            }
            if (schema.isReadonly()) {
                LOG.warn("Ignoring read-only {} {}", (Object)VirSchema.class.getSimpleName(), (Object)vAttr.getSchema());
                continue;
            }
            if (this.anyUtilsFactory.getInstance(any).getAllowedSchemas(any, VirSchema.class).contains(schema) && virtualResources.contains(schema.getProvision().getResource().getKey())) {
                HashSet<Attribute> values = (HashSet<Attribute>)vAttrMap.get(schema.getProvision().getResource().getKey());
                if (values == null) {
                    values = new HashSet<Attribute>();
                    vAttrMap.put(schema.getProvision().getResource().getKey(), values);
                }
                values.add(AttributeBuilder.build((String)schema.getExtAttrName(), (Collection)vAttr.getValues()));
                propByRes.add(ResourceOperation.UPDATE, (String)schema.getProvision().getResource().getKey());
                continue;
            }
            LOG.warn("{} not owned by or {} not allowed for {}", new Object[]{schema.getProvision().getResource(), schema, any});
        }
        LOG.debug("With virtual attributes {}:\n{}\n{}", new Object[]{any, propByRes, vAttrMap});
        ArrayList<PropagationTask> tasks = new ArrayList<PropagationTask>();
        for (Map.Entry entry : propByRes.asMap().entrySet()) {
            List mappingItems;
            ExternalResource resource = this.resourceDAO.find((String)entry.getKey());
            Provision provision = resource == null ? null : resource.getProvision(any.getType());
            List list = mappingItems = provision == null ? Collections.emptyList() : MappingUtils.getPropagationMappingItems((Provision)provision);
            if (resource == null) {
                LOG.error("Invalid resource name specified: {}, ignoring...", entry.getKey());
                continue;
            }
            if (provision == null) {
                LOG.error("No provision specified on resource {} for type {}, ignoring...", (Object)resource, (Object)any.getType());
                continue;
            }
            if (mappingItems.isEmpty()) {
                LOG.warn("Requesting propagation for {} but no propagation mapping provided for {}", (Object)any.getType(), (Object)resource);
                continue;
            }
            PropagationTask task = (PropagationTask)this.entityFactory.newEntity(PropagationTask.class);
            task.setResource(resource);
            task.setObjectClassName(resource.getProvision(any.getType()).getObjectClass().getObjectClassValue());
            task.setAnyTypeKind(any.getType().getKind());
            task.setAnyType((String)any.getType().getKey());
            if (!deleteOnResource) {
                task.setAnyKey((Long)any.getKey());
            }
            task.setOperation((ResourceOperation)entry.getValue());
            task.setOldConnObjectKey(propByRes.getOldConnObjectKey((String)resource.getKey()));
            Pair preparedAttrs = this.mappingUtils.prepareAttrs(any, password, changePwd, enable, provision);
            task.setConnObjectKey((String)preparedAttrs.getKey());
            ArrayList<String> mandatoryMissing = new ArrayList<String>();
            ArrayList<String> mandatoryNullOrEmpty = new ArrayList<String>();
            for (MappingItem item : mappingItems) {
                if (item.isConnObjectKey() || !JexlUtils.evaluateMandatoryCondition((String)item.getMandatoryCondition(), any)) continue;
                Attribute attr = AttributeUtil.find((String)item.getExtAttrName(), (Set)((Set)preparedAttrs.getValue()));
                if (attr == null) {
                    mandatoryMissing.add(item.getExtAttrName());
                    continue;
                }
                if (attr.getValue() != null && !attr.getValue().isEmpty()) continue;
                mandatoryNullOrEmpty.add(item.getExtAttrName());
            }
            if (!mandatoryMissing.isEmpty()) {
                ((Set)preparedAttrs.getValue()).add(AttributeBuilder.build((String)"__MANDATORY_MISSING__", mandatoryMissing));
            }
            if (!mandatoryNullOrEmpty.isEmpty()) {
                ((Set)preparedAttrs.getValue()).add(AttributeBuilder.build((String)"__MANDATORY_NULL_OR_EMPTY__", mandatoryNullOrEmpty));
            }
            if (vAttrMap.containsKey(resource.getKey())) {
                ((Set)preparedAttrs.getValue()).addAll((Collection)vAttrMap.get(resource.getKey()));
            }
            task.setAttributes((Set)preparedAttrs.getValue());
            tasks.add(task);
            LOG.debug("PropagationTask created: {}", (Object)task);
        }
        return tasks;
    }
}

