/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.SyncPolicySpec;
import org.apache.syncope.core.misc.spring.ApplicationContextProvider;
import org.apache.syncope.core.misc.utils.MappingUtils;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.SyncTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.sync.AnyObjectSyncResultHandler;
import org.apache.syncope.core.provisioning.api.sync.GroupSyncResultHandler;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.sync.ReconciliationFilterBuilder;
import org.apache.syncope.core.provisioning.api.sync.SyncActions;
import org.apache.syncope.core.provisioning.api.sync.UserSyncResultHandler;
import org.apache.syncope.core.provisioning.java.sync.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.sync.AnyObjectSyncResultHandlerImpl;
import org.apache.syncope.core.provisioning.java.sync.GroupSyncResultHandlerImpl;
import org.apache.syncope.core.provisioning.java.sync.SyncUtils;
import org.apache.syncope.core.provisioning.java.sync.UserSyncResultHandlerImpl;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncJobDelegate
extends AbstractProvisioningJobDelegate<SyncTask> {
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    protected SyncUtils syncUtils;

    protected void setGroupOwners(GroupSyncResultHandler ghandler) {
        for (Map.Entry entry : ghandler.getGroupOwnerMap().entrySet()) {
            Group group = (Group)this.groupDAO.find((Long)entry.getKey());
            if (group == null) {
                throw new NotFoundException("Group " + entry.getKey());
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) {
                group.setGroupOwner(null);
                group.setUserOwner(null);
            } else {
                Long userKey = this.syncUtils.findMatchingAnyKey(this.anyTypeDAO.findUser(), (String)entry.getValue(), ((SyncTask)ghandler.getProfile().getTask()).getResource(), ghandler.getProfile().getConnector());
                if (userKey == null) {
                    Long groupKey = this.syncUtils.findMatchingAnyKey(this.anyTypeDAO.findGroup(), (String)entry.getValue(), ((SyncTask)ghandler.getProfile().getTask()).getResource(), ghandler.getProfile().getConnector());
                    if (groupKey != null) {
                        group.setGroupOwner((Group)this.groupDAO.find(groupKey));
                    }
                } else {
                    group.setUserOwner((User)this.userDAO.find(userKey));
                }
            }
            this.groupDAO.save((Any)group);
        }
    }

    @Override
    protected String doExecuteProvisioning(SyncTask syncTask, Connector connector, boolean dryRun) throws JobExecutionException {
        LOG.debug("Executing sync on {}", (Object)syncTask.getResource());
        ArrayList<SyncActions> actions = new ArrayList<SyncActions>();
        for (String className : syncTask.getActionsClassNames()) {
            try {
                Class<?> actionsClass = Class.forName(className);
                SyncActions syncActions = (SyncActions)ApplicationContextProvider.getBeanFactory().createBean(actionsClass, 2, true);
                actions.add(syncActions);
            }
            catch (Exception e) {
                LOG.warn("Class '{}' not found", (Object)className, (Object)e);
            }
        }
        ProvisioningProfile profile = new ProvisioningProfile(connector, (ProvisioningTask)syncTask);
        profile.getActions().addAll(actions);
        profile.setDryRun(dryRun);
        profile.setResAct(this.getSyncPolicySpec((ProvisioningTask)syncTask).getConflictResolutionAction());
        AnyObjectSyncResultHandler ahandler = (AnyObjectSyncResultHandler)ApplicationContextProvider.getBeanFactory().createBean(AnyObjectSyncResultHandlerImpl.class, 1, false);
        ahandler.setProfile(profile);
        UserSyncResultHandler uhandler = (UserSyncResultHandler)ApplicationContextProvider.getBeanFactory().createBean(UserSyncResultHandlerImpl.class, 1, false);
        uhandler.setProfile(profile);
        GroupSyncResultHandler ghandler = (GroupSyncResultHandler)ApplicationContextProvider.getBeanFactory().createBean(GroupSyncResultHandlerImpl.class, 1, false);
        ghandler.setProfile(profile);
        if (!profile.isDryRun()) {
            for (SyncActions action : actions) {
                action.beforeAll(profile);
            }
        }
        block16: for (Provision provision : syncTask.getResource().getProvisions()) {
            UserSyncResultHandler handler;
            if (provision.getMapping() == null) continue;
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = uhandler;
                    break;
                }
                case GROUP: {
                    handler = ghandler;
                    break;
                }
                default: {
                    handler = ahandler;
                }
            }
            try {
                HashSet<MappingItem> linkinMappingItems = new HashSet<MappingItem>();
                for (VirSchema virSchema : this.virSchemaDAO.findByProvision(provision)) {
                    linkinMappingItems.add(virSchema.asLinkingMappingItem());
                }
                Iterator mapItems = IteratorUtils.chainedIterator(provision.getMapping().getItems().iterator(), linkinMappingItems.iterator());
                switch (syncTask.getSyncMode()) {
                    case INCREMENTAL: {
                        SyncToken latestSyncToken = connector.getLatestSyncToken(provision.getObjectClass());
                        connector.sync(provision.getObjectClass(), provision.getSyncToken(), (SyncResultsHandler)handler, MappingUtils.buildOperationOptions((Iterator)mapItems));
                        if (dryRun) continue block16;
                        provision.setSyncToken(latestSyncToken);
                        this.resourceDAO.save(provision.getResource());
                        break;
                    }
                    case FILTERED_RECONCILIATION: {
                        ReconciliationFilterBuilder filterBuilder = (ReconciliationFilterBuilder)ApplicationContextProvider.getBeanFactory().createBean(Class.forName(syncTask.getReconciliationFilterBuilderClassName()), 1, false);
                        connector.filteredReconciliation(provision.getObjectClass(), filterBuilder, (SyncResultsHandler)handler, MappingUtils.buildOperationOptions((Iterator)mapItems));
                        break;
                    }
                    default: {
                        connector.fullReconciliation(provision.getObjectClass(), (SyncResultsHandler)handler, MappingUtils.buildOperationOptions((Iterator)mapItems));
                        break;
                    }
                }
            }
            catch (Throwable t) {
                throw new JobExecutionException("While syncing from connector", t);
            }
        }
        try {
            this.setGroupOwners(ghandler);
        }
        catch (Exception e) {
            LOG.error("While setting group owners", (Throwable)e);
        }
        if (!profile.isDryRun()) {
            for (SyncActions action : actions) {
                action.afterAll(profile);
            }
        }
        String result = this.createReport(profile.getResults(), syncTask.getResource().getSyncTraceLevel(), dryRun);
        LOG.debug("Sync result: {}", (Object)result);
        return result;
    }

    private SyncPolicySpec getSyncPolicySpec(ProvisioningTask task) {
        SyncPolicySpec syncPolicySpec = task instanceof SyncTask ? (task.getResource().getSyncPolicy() == null ? null : task.getResource().getSyncPolicy().getSpecification()) : null;
        return syncPolicySpec == null ? new SyncPolicySpec() : syncPolicySpec;
    }
}

