/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.apache.syncope.core.misc.security.AuthContextUtils;
import org.apache.syncope.core.misc.spring.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.ConnectorRegistry;
import org.apache.syncope.core.provisioning.java.ConnectorFacadeProxy;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConnectorManager
implements ConnectorRegistry,
ConnectorFactory,
SyncopeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorManager.class);
    @Autowired
    private ConnIdBundleManager connIdBundleManager;
    @Autowired
    private ExternalResourceDAO resourceDAO;

    public Integer getPriority() {
        return 100;
    }

    private String getBeanName(ExternalResource resource) {
        return String.format("connInstance-%s-%d-%s", AuthContextUtils.getDomain(), resource.getConnector().getKey(), resource.getKey());
    }

    public Connector getConnector(ExternalResource resource) {
        if (!ApplicationContextProvider.getBeanFactory().containsBean(this.getBeanName(resource))) {
            this.registerConnector(resource);
        }
        return (Connector)ApplicationContextProvider.getBeanFactory().getBean(this.getBeanName(resource));
    }

    public ConnInstance buildConnInstanceOverride(ConnInstance connInstance, Set<ConnConfProperty> confOverride, Set<ConnectorCapability> capabilitiesOverride) {
        ConnInstance override = (ConnInstance)SerializationUtils.clone((Serializable)connInstance);
        HashMap<String, ConnConfProperty> overridable = new HashMap<String, ConnConfProperty>();
        HashSet<Object> conf = new HashSet<Object>();
        for (ConnConfProperty prop : override.getConf()) {
            if (prop.isOverridable()) {
                overridable.put(prop.getSchema().getName(), prop);
                continue;
            }
            conf.add(prop);
        }
        for (ConnConfProperty prop : confOverride) {
            if (!overridable.containsKey(prop.getSchema().getName()) || prop.getValues().isEmpty()) continue;
            conf.add(prop);
            overridable.remove(prop.getSchema().getName());
        }
        conf.addAll(overridable.values());
        override.setConf(conf);
        if (capabilitiesOverride != null) {
            override.getCapabilities().clear();
            override.getCapabilities().addAll(capabilitiesOverride);
        }
        return override;
    }

    public Connector createConnector(ConnInstance connInstance) {
        ConnectorFacadeProxy connector = new ConnectorFacadeProxy(connInstance);
        ApplicationContextProvider.getBeanFactory().autowireBean((Object)connector);
        return connector;
    }

    public void registerConnector(ExternalResource resource) {
        ConnInstance connInstance = this.buildConnInstanceOverride(resource.getConnector(), resource.getConfOverride(), resource.isOverrideCapabilities() ? resource.getCapabilitiesOverride() : null);
        Connector connector = this.createConnector(connInstance);
        LOG.debug("Connector to be registered: {}", (Object)connector);
        String beanName = this.getBeanName(resource);
        if (ApplicationContextProvider.getBeanFactory().containsSingleton(beanName)) {
            this.unregisterConnector(beanName);
        }
        ApplicationContextProvider.getBeanFactory().registerSingleton(beanName, (Object)connector);
        LOG.debug("Successfully registered bean {}", (Object)beanName);
    }

    public void unregisterConnector(String id) {
        ApplicationContextProvider.getBeanFactory().destroySingleton(id);
    }

    @Transactional(readOnly=true)
    public void load() {
        CurrentLocale.set((Locale)Locale.ENGLISH);
        this.connIdBundleManager.getConnManagers();
        int connectors = 0;
        for (ExternalResource resource : this.resourceDAO.findAll()) {
            LOG.info("Registering resource-connector pair {}-{}", (Object)resource, (Object)resource.getConnector());
            try {
                this.registerConnector(resource);
                ++connectors;
            }
            catch (Exception e) {
                LOG.error("While registering resource-connector pair {}-{}", new Object[]{resource, resource.getConnector(), e});
            }
        }
        LOG.info("Done loading {} connectors", (Object)connectors);
    }

    @Transactional(readOnly=true)
    public void unload() {
        int connectors = 0;
        for (ExternalResource resource : this.resourceDAO.findAll()) {
            String beanName = this.getBeanName(resource);
            if (!ApplicationContextProvider.getBeanFactory().containsSingleton(beanName)) continue;
            LOG.info("Unegistering resource-connector pair {}-{}", (Object)resource, (Object)resource.getConnector());
            this.unregisterConnector(beanName);
            ++connectors;
        }
        LOG.info("Done unloading {} connectors", (Object)connectors);
        ConnectorFacadeFactory.getInstance().dispose();
        this.connIdBundleManager.resetConnManagers();
        LOG.info("All connector resources disposed");
    }
}

