/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.PropagationByResource;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.StatusPatchType;
import org.apache.syncope.core.misc.spring.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningReport;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultUserProvisioningManager
implements UserProvisioningManager {
    private static final Logger LOG = LoggerFactory.getLogger(UserProvisioningManager.class);
    @Autowired
    protected UserWorkflowAdapter uwfAdapter;
    @Autowired
    protected PropagationManager propagationManager;
    @Autowired
    protected PropagationTaskExecutor taskExecutor;
    @Autowired
    protected VirAttrHandler virtAttrHandler;
    @Autowired
    protected UserDAO userDAO;

    public Pair<Long, List<PropagationStatus>> create(UserTO userTO, boolean nullPriorityAsync) {
        return this.create(userTO, true, false, null, Collections.emptySet(), nullPriorityAsync);
    }

    public Pair<Long, List<PropagationStatus>> create(UserTO userTO, boolean storePassword, boolean nullPriorityAsync) {
        return this.create(userTO, storePassword, false, null, Collections.emptySet(), nullPriorityAsync);
    }

    public Pair<Long, List<PropagationStatus>> create(UserTO userTO, Set<String> excludedResources, boolean nullPriorityAsync) {
        return this.create(userTO, false, false, null, excludedResources, nullPriorityAsync);
    }

    public Pair<Long, List<PropagationStatus>> create(UserTO userTO, boolean storePassword, boolean disablePwdPolicyCheck, Boolean enabled, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult created = this.uwfAdapter.create(userTO, disablePwdPolicyCheck, enabled, storePassword);
        List tasks = this.propagationManager.getUserCreateTasks((Long)((Pair)created.getResult()).getKey(), userTO.getPassword(), (Boolean)((Pair)created.getResult()).getValue(), created.getPropByRes(), (Collection)userTO.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return new ImmutablePair(((Pair)created.getResult()).getKey(), (Object)propagationReporter.getStatuses());
    }

    public Pair<Long, List<PropagationStatus>> update(UserPatch userPatch, boolean nullPriorityAsync) {
        WorkflowResult updated = this.uwfAdapter.update(userPatch);
        List tasks = this.propagationManager.getUserUpdateTasks(updated);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return new ImmutablePair((Object)((UserPatch)((Pair)updated.getResult()).getKey()).getKey(), (Object)propagationReporter.getStatuses());
    }

    public Pair<Long, List<PropagationStatus>> update(UserPatch userPatch, Set<String> excludedResources, boolean nullPriorityAsync) {
        return this.update(userPatch, new ProvisioningReport(), null, excludedResources, nullPriorityAsync);
    }

    public Pair<Long, List<PropagationStatus>> update(UserPatch userPatch, ProvisioningReport result, Boolean enabled, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult updated;
        try {
            updated = this.uwfAdapter.update(userPatch);
        }
        catch (Exception e) {
            LOG.error("Update of user {} failed, trying to sync its status anyway (if configured)", (Object)userPatch.getKey(), (Object)e);
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage("Update failed, trying to sync status anyway (if configured)\n" + e.getMessage());
            updated = new WorkflowResult((Object)new ImmutablePair((Object)userPatch, (Object)false), new PropagationByResource(), new HashSet());
        }
        if (enabled != null) {
            User user = (User)this.userDAO.find(Long.valueOf(userPatch.getKey()));
            WorkflowResult enableUpdate = null;
            if (user.isSuspended() == null) {
                enableUpdate = this.uwfAdapter.activate(Long.valueOf(userPatch.getKey()), null);
            } else if (enabled.booleanValue() && user.isSuspended().booleanValue()) {
                enableUpdate = this.uwfAdapter.reactivate(Long.valueOf(userPatch.getKey()));
            } else if (!enabled.booleanValue() && !user.isSuspended().booleanValue()) {
                enableUpdate = this.uwfAdapter.suspend(Long.valueOf(userPatch.getKey()));
            }
            if (enableUpdate != null) {
                if (enableUpdate.getPropByRes() != null) {
                    updated.getPropByRes().merge(enableUpdate.getPropByRes());
                    updated.getPropByRes().purge();
                }
                updated.getPerformedTasks().addAll(enableUpdate.getPerformedTasks());
            }
        }
        List tasks = this.propagationManager.getUserUpdateTasks(updated, ((UserPatch)((Pair)updated.getResult()).getKey()).getPassword() != null, excludedResources);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return new ImmutablePair((Object)((UserPatch)((Pair)updated.getResult()).getKey()).getKey(), (Object)propagationReporter.getStatuses());
    }

    public List<PropagationStatus> delete(Long key, boolean nullPriorityAsync) {
        return this.delete(key, Collections.emptySet(), nullPriorityAsync);
    }

    public List<PropagationStatus> delete(Long key, Set<String> excludedResources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.DELETE, this.userDAO.findAllResourceNames((User)this.userDAO.authFind(key)));
        List tasks = this.propagationManager.getDeleteTasks(AnyTypeKind.USER, key, propByRes, excludedResources);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        this.uwfAdapter.delete(key);
        return propagationReporter.getStatuses();
    }

    public Long unlink(UserPatch userPatch) {
        WorkflowResult updated = this.uwfAdapter.update(userPatch);
        return ((UserPatch)((Pair)updated.getResult()).getKey()).getKey();
    }

    public Long link(UserPatch userPatch) {
        return ((UserPatch)((Pair)this.uwfAdapter.update(userPatch).getResult()).getKey()).getKey();
    }

    public Pair<Long, List<PropagationStatus>> activate(StatusPatch statusPatch, boolean nullPriorityAsync) {
        WorkflowResult updated = statusPatch.isOnSyncope() ? this.uwfAdapter.activate(Long.valueOf(statusPatch.getKey()), statusPatch.getToken()) : new WorkflowResult((Object)statusPatch.getKey(), null, statusPatch.getType().name().toLowerCase());
        return new ImmutablePair(updated.getResult(), this.propagateStatus(statusPatch, nullPriorityAsync));
    }

    public Pair<Long, List<PropagationStatus>> reactivate(StatusPatch statusPatch, boolean nullPriorityAsync) {
        WorkflowResult updated = statusPatch.isOnSyncope() ? this.uwfAdapter.reactivate(Long.valueOf(statusPatch.getKey())) : new WorkflowResult((Object)statusPatch.getKey(), null, statusPatch.getType().name().toLowerCase());
        return new ImmutablePair(updated.getResult(), this.propagateStatus(statusPatch, nullPriorityAsync));
    }

    public Pair<Long, List<PropagationStatus>> suspend(StatusPatch statusPatch, boolean nullPriorityAsync) {
        WorkflowResult updated = statusPatch.isOnSyncope() ? this.uwfAdapter.suspend(Long.valueOf(statusPatch.getKey())) : new WorkflowResult((Object)statusPatch.getKey(), null, statusPatch.getType().name().toLowerCase());
        return new ImmutablePair(updated.getResult(), this.propagateStatus(statusPatch, nullPriorityAsync));
    }

    protected List<PropagationStatus> propagateStatus(StatusPatch statusPatch, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.UPDATE, (Collection)statusPatch.getResources());
        List tasks = this.propagationManager.getUpdateTasks(AnyTypeKind.USER, Long.valueOf(statusPatch.getKey()), false, Boolean.valueOf(statusPatch.getType() != StatusPatchType.SUSPEND), propByRes, null, null);
        PropagationReporter propReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propReporter, nullPriorityAsync);
        return propReporter.getStatuses();
    }

    public void internalSuspend(Long key) {
        Pair updated = this.uwfAdapter.internalSuspend(key);
        if (updated != null && ((Boolean)updated.getValue()).booleanValue()) {
            UserPatch userPatch = new UserPatch();
            userPatch.setKey(((Long)((WorkflowResult)updated.getKey()).getResult()).longValue());
            List tasks = this.propagationManager.getUserUpdateTasks(new WorkflowResult((Object)new ImmutablePair((Object)userPatch, (Object)Boolean.FALSE), ((WorkflowResult)updated.getKey()).getPropByRes(), ((WorkflowResult)updated.getKey()).getPerformedTasks()));
            this.taskExecutor.execute((Collection)tasks);
        }
    }

    public List<PropagationStatus> provision(Long key, boolean changePwd, String password, Collection<String> resources, boolean nullPriorityAsync) {
        UserPatch userPatch = new UserPatch();
        userPatch.setKey(key.longValue());
        userPatch.getResources().addAll(CollectionUtils.collect(resources, (Transformer)new Transformer<String, StringPatchItem>(){

            public StringPatchItem transform(String input) {
                return (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value((Object)input)).build();
            }
        }, new HashSet()));
        if (changePwd) {
            PasswordPatch passwordPatch = new PasswordPatch();
            passwordPatch.setOnSyncope(false);
            passwordPatch.getResources().addAll(resources);
            passwordPatch.setValue((Object)password);
            userPatch.setPassword(passwordPatch);
        }
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.UPDATE, resources);
        WorkflowResult wfResult = new WorkflowResult((Object)ImmutablePair.of((Object)userPatch, (Object)null), propByRes, "update");
        List tasks = this.propagationManager.getUserUpdateTasks(wfResult, changePwd, null);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return propagationReporter.getStatuses();
    }

    public List<PropagationStatus> deprovision(Long key, Collection<String> resources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.DELETE, resources);
        List tasks = this.propagationManager.getDeleteTasks(AnyTypeKind.USER, key, propByRes, CollectionUtils.removeAll((Collection)this.userDAO.findAllResourceNames((User)this.userDAO.authFind(key)), resources));
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return propagationReporter.getStatuses();
    }

    public void requestPasswordReset(Long key) {
        this.uwfAdapter.requestPasswordReset(key);
    }

    public void confirmPasswordReset(Long key, String token, String password) {
        WorkflowResult updated = this.uwfAdapter.confirmPasswordReset(key, token, password);
        List tasks = this.propagationManager.getUserUpdateTasks(updated);
        PropagationReporter propReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propReporter, false);
    }
}

