/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.IntMappingType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.common.lib.types.PropagationByResource;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.misc.jexl.JexlUtils;
import org.apache.syncope.core.misc.utils.ConnObjectUtils;
import org.apache.syncope.core.misc.utils.MappingUtils;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

abstract class AbstractAnyDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractAnyDataBinder.class);
    private static final IntMappingType[] FOR_MANDATORY = new IntMappingType[]{IntMappingType.AnyObjectPlainSchema, IntMappingType.AnyObjectDerivedSchema, IntMappingType.UserPlainSchema, IntMappingType.UserDerivedSchema, IntMappingType.GroupPlainSchema, IntMappingType.GroupDerivedSchema};
    @Autowired
    protected RealmDAO realmDAO;
    @Autowired
    protected AnyTypeClassDAO anyTypeClassDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected PlainSchemaDAO plainSchemaDAO;
    @Autowired
    protected DerSchemaDAO derSchemaDAO;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected PlainAttrDAO plainAttrDAO;
    @Autowired
    protected PlainAttrValueDAO plainAttrValueDAO;
    @Autowired
    protected ExternalResourceDAO resourceDAO;
    @Autowired
    protected PolicyDAO policyDAO;
    @Autowired
    protected RelationshipTypeDAO relationshipTypeDAO;
    @Autowired
    protected AnySearchDAO searchDAO;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;
    @Autowired
    protected DerAttrHandler derAttrHandler;
    @Autowired
    protected VirAttrHandler virAttrHander;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected MappingUtils mappingUtils;

    AbstractAnyDataBinder() {
    }

    protected void setRealm(Any<?> any, AnyPatch anyPatch) {
        if (anyPatch.getRealm() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)anyPatch.getRealm().getValue()))) {
            Realm newRealm = this.realmDAO.find((String)anyPatch.getRealm().getValue());
            if (newRealm == null) {
                LOG.debug("Invalid realm specified: {}, ignoring", anyPatch.getRealm().getValue());
            } else {
                any.setRealm(newRealm);
            }
        }
    }

    protected PlainSchema getPlainSchema(String schemaName) {
        PlainSchema schema = null;
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            schema = (PlainSchema)this.plainSchemaDAO.find(schemaName);
            if (schema == null) {
                LOG.debug("Ignoring invalid schema {}", (Object)schemaName);
            } else if (schema.isReadonly()) {
                schema = null;
                LOG.debug("Ignoring readonly schema {}", (Object)schemaName);
            }
        }
        return schema;
    }

    private DerSchema getDerSchema(String derSchemaName) {
        DerSchema schema = null;
        if (StringUtils.isNotBlank((CharSequence)derSchemaName) && (schema = (DerSchema)this.derSchemaDAO.find(derSchemaName)) == null) {
            LOG.debug("Ignoring invalid derived schema {}", (Object)derSchemaName);
        }
        return schema;
    }

    private void fillAttr(List<String> values, AnyUtils anyUtils, PlainSchema schema, PlainAttr<?> attr, SyncopeClientException invalidValues) {
        List<String> valuesProvided = schema.isMultivalue() ? values : (values.isEmpty() ? Collections.emptyList() : Collections.singletonList(values.iterator().next()));
        for (String value : valuesProvided) {
            if (value == null || value.isEmpty()) {
                LOG.debug("Null value for {}, ignoring", schema.getKey());
                continue;
            }
            try {
                attr.add(value, anyUtils);
            }
            catch (InvalidPlainAttrValueException e) {
                LOG.warn("Invalid value for attribute " + (String)schema.getKey() + ": " + value, (Throwable)e);
                invalidValues.getElements().add((String)schema.getKey() + ": " + value + " - " + e.getMessage());
            }
        }
    }

    private List<String> evaluateMandatoryCondition(Provision provision, Any<?> any) {
        ArrayList<String> missingAttrNames = new ArrayList<String>();
        if (provision != null) {
            for (MappingItem item : provision.getMapping().getItems()) {
                List values;
                if (!ArrayUtils.contains((Object[])FOR_MANDATORY, (Object)item.getIntMappingType()) || item.getPurpose() != MappingPurpose.PROPAGATION && item.getPurpose() != MappingPurpose.BOTH || !(values = this.mappingUtils.getIntValues(provision, item, Collections.singletonList(any))).isEmpty() || !JexlUtils.evaluateMandatoryCondition((String)item.getMandatoryCondition(), any)) continue;
                missingAttrNames.add(item.getIntAttrName());
            }
        }
        return missingAttrNames;
    }

    private SyncopeClientException checkMandatoryOnResources(Any<?> any, Set<ExternalResource> resources) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        for (ExternalResource resource : resources) {
            List<String> missingAttrNames;
            Provision provision = resource.getProvision(any.getType());
            if (!resource.isEnforceMandatoryCondition() || provision == null || (missingAttrNames = this.evaluateMandatoryCondition(provision, any)).isEmpty()) continue;
            LOG.error("Mandatory schemas {} not provided with values", missingAttrNames);
            reqValMissing.getElements().addAll(missingAttrNames);
        }
        return reqValMissing;
    }

    private SyncopeClientException checkMandatory(Any<?> any, AnyUtils anyUtils) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        for (PlainSchema schema : anyUtils.getAllowedSchemas(any, PlainSchema.class)) {
            if (any.getPlainAttr((String)schema.getKey()) != null || schema.isReadonly() || !JexlUtils.evaluateMandatoryCondition((String)schema.getMandatoryCondition(), any)) continue;
            LOG.error("Mandatory schema " + (String)schema.getKey() + " not provided with values");
            reqValMissing.getElements().add(schema.getKey());
        }
        return reqValMissing;
    }

    private void processAttrPatch(Any any, AttrPatch patch, PlainSchema schema, AnyUtils anyUtils, Set<ExternalResource> resources, PropagationByResource propByRes, SyncopeClientException invalidValues) {
        PlainAttr attr = any.getPlainAttr((String)schema.getKey());
        if (attr == null) {
            LOG.debug("No plain attribute found for schema {}", (Object)schema);
            switch (patch.getOperation()) {
                case ADD_REPLACE: {
                    attr = anyUtils.newPlainAttr();
                    attr.setOwner(any);
                    attr.setSchema(schema);
                    any.add(attr);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        switch (patch.getOperation()) {
            case ADD_REPLACE: {
                List valuesToBeAdded;
                if (attr.getSchema().isUniqueConstraint()) {
                    if (attr.getUniqueValue() != null && !patch.getAttrTO().getValues().isEmpty() && !((String)patch.getAttrTO().getValues().get(0)).equals(attr.getUniqueValue().getValueAsString())) {
                        this.plainAttrValueDAO.delete((Long)attr.getUniqueValue().getKey(), anyUtils.plainAttrUniqueValueClass());
                    }
                } else {
                    Collection valuesToBeRemoved = CollectionUtils.collect((Iterable)attr.getValues(), (Transformer)new Transformer<PlainAttrValue, Long>(){

                        public Long transform(PlainAttrValue input) {
                            return (Long)input.getKey();
                        }
                    });
                    for (Long attrValueKey : valuesToBeRemoved) {
                        this.plainAttrValueDAO.delete(attrValueKey, anyUtils.plainAttrValueClass());
                    }
                }
                if (!((valuesToBeAdded = patch.getAttrTO().getValues()).isEmpty() || schema.isUniqueConstraint() && attr.getUniqueValue() != null && ((String)valuesToBeAdded.iterator().next()).equals(attr.getUniqueValue().getValueAsString()))) {
                    this.fillAttr(valuesToBeAdded, anyUtils, schema, attr, invalidValues);
                }
                if (!attr.getValuesAsStrings().isEmpty()) break;
                this.plainAttrDAO.delete(attr);
                break;
            }
            default: {
                any.remove(attr);
                this.plainAttrDAO.delete((Long)attr.getKey(), anyUtils.plainAttrClass());
            }
        }
        for (ExternalResource resource : resources) {
            for (MappingItem mapItem : MappingUtils.getPropagationMappingItems((Provision)resource.getProvision(any.getType()))) {
                if (!((String)schema.getKey()).equals(mapItem.getIntAttrName()) || mapItem.getIntMappingType() != anyUtils.plainIntMappingType()) continue;
                propByRes.add(ResourceOperation.UPDATE, (String)resource.getKey());
                if (!mapItem.isConnObjectKey() || attr.getValuesAsStrings().isEmpty()) continue;
                propByRes.addOldConnObjectKey((String)resource.getKey(), (String)attr.getValuesAsStrings().get(0));
            }
        }
    }

    protected PropagationByResource fill(Any<?> any, AnyPatch anyPatch, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException requiredValuesMissing;
        PropagationByResource propByRes = new PropagationByResource();
        block6: for (StringPatchItem patch : anyPatch.getAuxClasses()) {
            AnyTypeClass auxClass = this.anyTypeClassDAO.find((String)patch.getValue());
            if (auxClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + "{}, ignoring...", patch.getValue());
                continue;
            }
            switch (patch.getOperation()) {
                case ADD_REPLACE: {
                    any.add(auxClass);
                    continue block6;
                }
            }
            any.remove(auxClass);
        }
        block7: for (StringPatchItem patch : anyPatch.getResources()) {
            ExternalResource resource = this.resourceDAO.find((String)patch.getValue());
            if (resource == null) {
                LOG.debug("Invalid " + ExternalResource.class.getSimpleName() + "{}, ignoring...", patch.getValue());
                continue;
            }
            switch (patch.getOperation()) {
                case ADD_REPLACE: {
                    propByRes.add(ResourceOperation.CREATE, (String)resource.getKey());
                    any.add(resource);
                    continue block7;
                }
            }
            propByRes.add(ResourceOperation.DELETE, (String)resource.getKey());
            any.remove(resource);
        }
        Set resources = anyUtils.getAllResources(any);
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        for (AttrPatch patch : anyPatch.getPlainAttrs()) {
            if (patch.getAttrTO() == null) continue;
            PlainSchema schema = this.getPlainSchema(patch.getAttrTO().getSchema());
            if (schema == null) {
                LOG.debug("Invalid " + PlainSchema.class.getSimpleName() + "{}, ignoring...", (Object)patch.getAttrTO().getSchema());
                continue;
            }
            this.processAttrPatch(any, patch, schema, anyUtils, resources, propByRes, invalidValues);
        }
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(requiredValuesMissing = this.checkMandatory(any, anyUtils)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        if (!(requiredValuesMissing = this.checkMandatoryOnResources(any, resources)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        return propByRes;
    }

    protected void fill(Any any, AnyTO anyTO, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException requiredValuesMissing;
        any.getAuxClasses().clear();
        for (Object className : anyTO.getAuxClasses()) {
            AnyTypeClass auxClass = this.anyTypeClassDAO.find((String)className);
            if (auxClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + "{}, ignoring...", (Object)auxClass);
                continue;
            }
            any.add(auxClass);
        }
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        for (AttrTO attrTO : anyTO.getPlainAttrs()) {
            PlainSchema schema;
            if (attrTO.getValues() == null || attrTO.getValues().isEmpty() || (schema = this.getPlainSchema(attrTO.getSchema())) == null) continue;
            PlainAttr attr = any.getPlainAttr((String)schema.getKey());
            if (attr == null) {
                attr = anyUtils.newPlainAttr();
                attr.setOwner(any);
                attr.setSchema(schema);
            }
            this.fillAttr(attrTO.getValues(), anyUtils, schema, attr, invalidValues);
            if (attr.getValuesAsStrings().isEmpty()) {
                attr.setOwner(null);
                continue;
            }
            any.add(attr);
        }
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(requiredValuesMissing = this.checkMandatory(any, anyUtils)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        for (String resourceName : anyTO.getResources()) {
            ExternalResource resource = this.resourceDAO.find(resourceName);
            if (resource == null) {
                LOG.debug("Invalid " + ExternalResource.class.getSimpleName() + "{}, ignoring...", (Object)resourceName);
                continue;
            }
            any.add(resource);
        }
        requiredValuesMissing = this.checkMandatoryOnResources(any, anyUtils.getAllResources(any));
        if (!requiredValuesMissing.isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
    }

    protected void fillTO(AnyTO anyTO, String realmFullPath, Collection<? extends AnyTypeClass> auxClasses, Collection<? extends PlainAttr<?>> plainAttrs, Map<DerSchema, String> derAttrs, Map<VirSchema, List<String>> virAttrs, Collection<? extends ExternalResource> resources) {
        AttrTO attrTO;
        anyTO.setRealm(realmFullPath);
        CollectionUtils.collect(auxClasses, (Transformer)new Transformer<AnyTypeClass, String>(){

            public String transform(AnyTypeClass role) {
                return (String)role.getKey();
            }
        }, (Collection)anyTO.getAuxClasses());
        for (PlainAttr<?> plainAttr : plainAttrs) {
            attrTO = new AttrTO();
            attrTO.setSchema((String)plainAttr.getSchema().getKey());
            attrTO.getValues().addAll(plainAttr.getValuesAsStrings());
            attrTO.setReadonly(plainAttr.getSchema().isReadonly());
            anyTO.getPlainAttrs().add(attrTO);
        }
        for (Map.Entry entry : derAttrs.entrySet()) {
            attrTO = new AttrTO();
            attrTO.setSchema((String)((DerSchema)entry.getKey()).getKey());
            attrTO.getValues().add(entry.getValue());
            attrTO.setReadonly(true);
            anyTO.getDerAttrs().add(attrTO);
        }
        for (Map.Entry entry : virAttrs.entrySet()) {
            attrTO = new AttrTO();
            attrTO.setSchema((String)((VirSchema)entry.getKey()).getKey());
            attrTO.getValues().addAll((Collection)entry.getValue());
            attrTO.setReadonly(((VirSchema)entry.getKey()).isReadonly());
            anyTO.getVirAttrs().add(attrTO);
        }
        for (ExternalResource externalResource : resources) {
            anyTO.getResources().add(externalResource.getKey());
        }
    }

    protected RelationshipTO getRelationshipTO(Relationship<? extends Any<?>, AnyObject> relationship) {
        return new RelationshipTO.Builder().type((String)relationship.getType().getKey()).left((String)relationship.getLeftEnd().getType().getKey(), ((Long)relationship.getLeftEnd().getKey()).longValue()).right((String)((AnyObject)relationship.getRightEnd()).getType().getKey(), ((Long)((AnyObject)relationship.getRightEnd()).getKey()).longValue()).build();
    }

    protected MembershipTO getMembershipTO(Membership<? extends Any<?>> membership) {
        return new MembershipTO.Builder().left((String)membership.getLeftEnd().getType().getKey(), ((Long)membership.getLeftEnd().getKey()).longValue()).group(((Long)((Group)membership.getRightEnd()).getKey()).longValue(), ((Group)membership.getRightEnd()).getName()).build();
    }

    protected Map<String, String> getConnObjectKeys(Any<?> any) {
        HashMap<String, String> connObjectKeys = new HashMap<String, String>();
        Collection iterable = any instanceof User ? this.userDAO.findAllResources((User)any) : (any instanceof AnyObject ? this.anyObjectDAO.findAllResources((AnyObject)any) : ((Group)any).getResources());
        for (ExternalResource resource : iterable) {
            Provision provision = resource.getProvision(any.getType());
            if (provision == null || provision.getMapping() == null) continue;
            MappingItem connObjectKeyItem = MappingUtils.getConnObjectKeyItem((Provision)provision);
            if (connObjectKeyItem == null) {
                throw new NotFoundException("ConnObjectKey mapping for " + (String)any.getType().getKey() + " " + any.getKey() + " on resource '" + (String)resource.getKey() + "'");
            }
            String connObjectKey = this.mappingUtils.getConnObjectKeyValue(any, provision);
            if (connObjectKey == null) continue;
            connObjectKeys.put((String)resource.getKey(), connObjectKey);
        }
        return connObjectKeys;
    }
}

