/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.PropagationByResource;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.misc.spring.BeanUtils;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.search.AssignableCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.ARelationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class AnyObjectDataBinderImpl
extends AbstractAnyDataBinder
implements AnyObjectDataBinder {
    private static final String[] IGNORE_PROPERTIES = new String[]{"type", "realm", "auxClasses", "relationships", "memberships", "dynGroups", "plainAttrs", "derAttrs", "virAttrs", "resources"};
    @Autowired
    private AnyTypeDAO anyTypeDAO;

    @Transactional(readOnly=true)
    public AnyObjectTO getAnyObjectTO(Long key) {
        return this.getAnyObjectTO((AnyObject)this.anyObjectDAO.authFind(key), true);
    }

    public AnyObjectTO getAnyObjectTO(AnyObject anyObject, boolean details) {
        AnyObjectTO anyObjectTO = new AnyObjectTO();
        anyObjectTO.setType((String)anyObject.getType().getKey());
        BeanUtils.copyProperties((Object)anyObject, (Object)anyObjectTO, (String[])IGNORE_PROPERTIES);
        Map derAttrValues = this.derAttrHandler.getValues((Any)anyObject);
        Map virAttrValues = details ? this.virAttrHander.getValues((Any)anyObject) : Collections.emptyMap();
        this.fillTO((AnyTO)anyObjectTO, anyObject.getRealm().getFullPath(), anyObject.getAuxClasses(), anyObject.getPlainAttrs(), derAttrValues, virAttrValues, this.anyObjectDAO.findAllResources(anyObject));
        if (details) {
            CollectionUtils.collect((Iterable)anyObject.getRelationships(), (Transformer)new Transformer<ARelationship, RelationshipTO>(){

                public RelationshipTO transform(ARelationship relationship) {
                    return AnyObjectDataBinderImpl.this.getRelationshipTO((Relationship<? extends Any<?>, AnyObject>)relationship);
                }
            }, (Collection)anyObjectTO.getRelationships());
            CollectionUtils.collect((Iterable)anyObject.getMemberships(), (Transformer)new Transformer<AMembership, MembershipTO>(){

                public MembershipTO transform(AMembership membership) {
                    return AnyObjectDataBinderImpl.this.getMembershipTO((Membership<? extends Any<?>>)membership);
                }
            }, (Collection)anyObjectTO.getMemberships());
            CollectionUtils.collect((Iterable)this.anyObjectDAO.findDynGroupMemberships(anyObject), (Transformer)new Transformer<Group, Long>(){

                public Long transform(Group group) {
                    return (Long)group.getKey();
                }
            }, (Collection)anyObjectTO.getDynGroups());
        }
        return anyObjectTO;
    }

    public void create(AnyObject anyObject, AnyObjectTO anyObjectTO) {
        AnyType type = this.anyTypeDAO.find(anyObjectTO.getType());
        if (type == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(anyObjectTO.getType());
            throw sce;
        }
        anyObject.setType(type);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        Realm realm = this.realmDAO.find(anyObjectTO.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + anyObjectTO.getRealm());
            scce.addException(noRealm);
        }
        anyObject.setRealm(realm);
        if (anyObject.getRealm() != null) {
            AssignableCond assignableCond = new AssignableCond();
            assignableCond.setRealmFullPath(anyObject.getRealm().getFullPath());
            List assignableAnyObjects = this.searchDAO.search(SearchCond.getLeafCond((AssignableCond)assignableCond), AnyTypeKind.ANY_OBJECT);
            for (RelationshipTO relationshipTO : anyObjectTO.getRelationships()) {
                AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(Long.valueOf(relationshipTO.getRightKey()));
                if (otherEnd == null) {
                    LOG.debug("Ignoring invalid anyObject " + relationshipTO.getRightKey());
                    continue;
                }
                if (assignableAnyObjects.contains(otherEnd)) {
                    RelationshipType relationshipType = this.relationshipTypeDAO.find(relationshipTO.getType());
                    if (relationshipType == null) {
                        LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType());
                        continue;
                    }
                    ARelationship relationship = (ARelationship)this.entityFactory.newEntity(ARelationship.class);
                    relationship.setType(relationshipType);
                    relationship.setRightEnd((Any)anyObject);
                    relationship.setLeftEnd((Any)anyObject);
                    anyObject.add(relationship);
                    continue;
                }
                LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)anyObject);
                SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                unassignabled.getElements().add("Cannot be assigned: " + otherEnd);
                scce.addException(unassignabled);
            }
            List assignableGroups = this.searchDAO.search(SearchCond.getLeafCond((AssignableCond)assignableCond), AnyTypeKind.GROUP);
            for (MembershipTO membershipTO : anyObjectTO.getMemberships()) {
                Group group = (Group)this.groupDAO.find(Long.valueOf(membershipTO.getRightKey()));
                if (group == null) {
                    LOG.debug("Ignoring invalid group " + membershipTO.getGroupName());
                    continue;
                }
                if (assignableGroups.contains(group)) {
                    AMembership membership = (AMembership)this.entityFactory.newEntity(AMembership.class);
                    membership.setRightEnd((Any)group);
                    membership.setLeftEnd((Any)anyObject);
                    anyObject.add(membership);
                    continue;
                }
                LOG.error("{} cannot be assigned to {}", (Object)group, (Object)anyObject);
                SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                unassignabled.getElements().add("Cannot be assigned: " + group);
                scce.addException(unassignabled);
            }
        }
        this.fill((Any)anyObject, (AnyTO)anyObjectTO, this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT), scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public PropagationByResource update(AnyObject toBeUpdated, AnyObjectPatch anyObjectPatch) {
        SyncopeClientException unassignabled;
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.save((Any)toBeUpdated);
        PropagationByResource propByRes = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        Collection currentResources = this.anyObjectDAO.findAllResourceNames(anyObject);
        Map<String, String> oldConnObjectKeys = this.getConnObjectKeys((Any<?>)anyObject);
        propByRes.merge(this.fill((Any<?>)anyObject, (AnyPatch)anyObjectPatch, this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT), scce));
        HashSet toBeDeprovisioned = new HashSet();
        HashSet toBeProvisioned = new HashSet();
        List assignableAnyObjects = this.searchDAO.searchAssignable(anyObject.getRealm().getFullPath(), AnyTypeKind.ANY_OBJECT);
        for (Object patch : anyObjectPatch.getRelationships()) {
            if (patch.getRelationshipTO() == null) continue;
            RelationshipType relationshipType = this.relationshipTypeDAO.find(patch.getRelationshipTO().getType());
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch.getRelationshipTO().getType());
                continue;
            }
            ARelationship relationship = anyObject.getRelationship(relationshipType, Long.valueOf(patch.getRelationshipTO().getRightKey()));
            if (relationship != null) {
                anyObject.remove(relationship);
                toBeDeprovisioned.addAll(((AnyObject)relationship.getRightEnd()).getResourceNames());
            }
            if (patch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(Long.valueOf(patch.getRelationshipTO().getRightKey()));
            if (otherEnd == null) {
                LOG.debug("Ignoring invalid any object {}", (Object)patch.getRelationshipTO().getRightKey());
                continue;
            }
            if (assignableAnyObjects.contains(otherEnd)) {
                relationship = (ARelationship)this.entityFactory.newEntity(ARelationship.class);
                relationship.setType(relationshipType);
                relationship.setRightEnd((Any)otherEnd);
                relationship.setLeftEnd((Any)anyObject);
                anyObject.add(relationship);
                toBeProvisioned.addAll(otherEnd.getResourceNames());
                continue;
            }
            LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)anyObject);
            unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
            unassignabled.getElements().add("Cannot be assigned: " + otherEnd);
            scce.addException(unassignabled);
        }
        List assignableGroups = this.searchDAO.searchAssignable(anyObject.getRealm().getFullPath(), AnyTypeKind.GROUP);
        for (MembershipPatch patch : anyObjectPatch.getMemberships()) {
            if (patch.getMembershipTO() == null) continue;
            AMembership membership = anyObject.getMembership(Long.valueOf(patch.getMembershipTO().getRightKey()));
            if (membership != null) {
                anyObject.remove(membership);
                toBeDeprovisioned.addAll(((Group)membership.getRightEnd()).getResourceNames());
            }
            if (patch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            Group group = (Group)this.groupDAO.find(Long.valueOf(patch.getMembershipTO().getRightKey()));
            if (group == null) {
                LOG.debug("Ignoring invalid group {}", (Object)patch.getMembershipTO().getRightKey());
                continue;
            }
            if (assignableGroups.contains(group)) {
                membership = (AMembership)this.entityFactory.newEntity(AMembership.class);
                membership.setRightEnd((Any)group);
                membership.setLeftEnd((Any)anyObject);
                anyObject.add(membership);
                toBeProvisioned.addAll(group.getResourceNames());
                continue;
            }
            LOG.error("{} cannot be assigned to {}", (Object)group, (Object)anyObject);
            unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
            unassignabled.getElements().add("Cannot be assigned: " + group);
            scce.addException(unassignabled);
        }
        propByRes.addAll(ResourceOperation.DELETE, toBeDeprovisioned);
        propByRes.addAll(ResourceOperation.UPDATE, toBeProvisioned);
        if (!toBeDeprovisioned.isEmpty() || !toBeProvisioned.isEmpty()) {
            currentResources.removeAll(toBeDeprovisioned);
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        Map<String, String> newcCnnObjectKeys = this.getConnObjectKeys((Any<?>)anyObject);
        for (Map.Entry<String, String> entry : oldConnObjectKeys.entrySet()) {
            if (!newcCnnObjectKeys.containsKey(entry.getKey()) || entry.getValue().equals(newcCnnObjectKeys.get(entry.getKey()))) continue;
            propByRes.addOldConnObjectKey(entry.getKey(), entry.getValue());
            propByRes.add(ResourceOperation.UPDATE, entry.getKey());
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        return propByRes;
    }
}

