/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.DomainTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.entity.Domain;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.provisioning.api.data.DomainDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DomainDataBinderImpl
implements DomainDataBinder {
    @Autowired
    private EntityFactory entityFactory;

    public Domain create(DomainTO domainTO) {
        Domain domain = (Domain)this.entityFactory.newEntity(Domain.class);
        this.update(domain, domainTO);
        return domain;
    }

    public void update(Domain domain, DomainTO domainTO) {
        if (domain.getKey() == null) {
            domain.setKey(domainTO.getKey());
        }
        if (StringUtils.isBlank((CharSequence)domainTO.getAdminPwd()) || domainTO.getAdminCipherAlgorithm() == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("Actual password value and / or cipher algorithm");
        }
        domain.setPassword(domainTO.getAdminPwd(), domainTO.getAdminCipherAlgorithm());
    }

    public DomainTO getDomainTO(Domain domain) {
        DomainTO domainTO = new DomainTO();
        domainTO.setKey((String)domain.getKey());
        domainTO.setAdminCipherAlgorithm(domain.getAdminCipherAlgorithm());
        domainTO.setAdminPwd(domainTO.getAdminPwd());
        return domainTO;
    }
}

