/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.AbstractProvisioningTaskTO;
import org.apache.syncope.common.lib.to.AbstractTaskTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.SyncTaskTO;
import org.apache.syncope.common.lib.to.TaskExecTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.misc.spring.BeanUtils;
import org.apache.syncope.core.misc.utils.TemplateUtils;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplate;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplateSyncTask;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTaskAnyFilter;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.SyncTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.java.sync.PushJobDelegate;
import org.apache.syncope.core.provisioning.java.sync.SyncJobDelegate;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class TaskDataBinderImpl
implements TaskDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDataBinder.class);
    private static final String[] IGNORE_TASK_PROPERTIES = new String[]{"destinationRealm", "templates", "filters", "executions", "resource", "matchingRule", "unmatchingRule"};
    private static final String[] IGNORE_TASK_EXECUTION_PROPERTIES = new String[]{"key", "task"};
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private TaskExecDAO taskExecDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private TemplateUtils templateUtils;
    @Autowired
    private SchedulerFactoryBean scheduler;

    private void fill(ProvisioningTask task, AbstractProvisioningTaskTO taskTO) {
        if (task instanceof PushTask && taskTO instanceof PushTaskTO) {
            PushTask pushTask = (PushTask)task;
            final PushTaskTO pushTaskTO = (PushTaskTO)taskTO;
            pushTask.setJobDelegateClassName(PushJobDelegate.class.getName());
            pushTask.setMatchingRule(pushTaskTO.getMatchingRule() == null ? MatchingRule.LINK : pushTaskTO.getMatchingRule());
            pushTask.setUnmatchingRule(pushTaskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTaskTO.getUnmatchingRule());
            for (Map.Entry entry : pushTaskTO.getFilters().entrySet()) {
                AnyType type = this.anyTypeDAO.find((String)entry.getKey());
                if (type == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", entry.getKey());
                    continue;
                }
                PushTaskAnyFilter filter = pushTask.getFilter(type);
                if (filter == null) {
                    filter = (PushTaskAnyFilter)this.entityFactory.newEntity(PushTaskAnyFilter.class);
                    filter.setAnyType(this.anyTypeDAO.find((String)entry.getKey()));
                    filter.setPushTask(pushTask);
                    pushTask.add(filter);
                }
                filter.setFIQLCond((String)entry.getValue());
            }
            CollectionUtils.filter((Iterable)pushTask.getFilters(), (Predicate)new Predicate<PushTaskAnyFilter>(){

                public boolean evaluate(PushTaskAnyFilter anyFilter) {
                    return pushTaskTO.getFilters().containsKey(anyFilter.getAnyType().getKey());
                }
            });
        } else if (task instanceof SyncTask && taskTO instanceof SyncTaskTO) {
            SyncTask syncTask = (SyncTask)task;
            final SyncTaskTO syncTaskTO = (SyncTaskTO)taskTO;
            syncTask.setSyncMode(syncTaskTO.getSyncMode());
            syncTask.setReconciliationFilterBuilderClassName(syncTaskTO.getReconciliationFilterBuilderClassName());
            syncTask.setDestinationRealm(this.realmDAO.find(syncTaskTO.getDestinationRealm()));
            syncTask.setJobDelegateClassName(SyncJobDelegate.class.getName());
            syncTask.setMatchingRule(syncTaskTO.getMatchingRule() == null ? MatchingRule.UPDATE : syncTaskTO.getMatchingRule());
            syncTask.setUnmatchingRule(syncTaskTO.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : syncTaskTO.getUnmatchingRule());
            this.templateUtils.check(syncTaskTO.getTemplates(), ClientExceptionType.InvalidSyncTask);
            for (Map.Entry entry : syncTaskTO.getTemplates().entrySet()) {
                AnyType type = this.anyTypeDAO.find((String)entry.getKey());
                if (type == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", entry.getKey());
                    continue;
                }
                AnyTemplateSyncTask anyTemplate = syncTask.getTemplate(type);
                if (anyTemplate == null) {
                    anyTemplate = (AnyTemplateSyncTask)this.entityFactory.newEntity(AnyTemplateSyncTask.class);
                    anyTemplate.setAnyType(type);
                    anyTemplate.setSyncTask(syncTask);
                    syncTask.add(anyTemplate);
                }
                anyTemplate.set((AnyTO)entry.getValue());
            }
            CollectionUtils.filter((Iterable)syncTask.getTemplates(), (Predicate)new Predicate<AnyTemplate>(){

                public boolean evaluate(AnyTemplate anyTemplate) {
                    return syncTaskTO.getTemplates().containsKey(anyTemplate.getAnyType().getKey());
                }
            });
        }
        task.setPerformCreate(taskTO.isPerformCreate());
        task.setPerformUpdate(taskTO.isPerformUpdate());
        task.setPerformDelete(taskTO.isPerformDelete());
        task.setSyncStatus(taskTO.isSyncStatus());
        task.getActionsClassNames().clear();
        task.getActionsClassNames().addAll(taskTO.getActionsClassNames());
    }

    public SchedTask createSchedTask(SchedTaskTO taskTO, TaskUtils taskUtils) {
        Class taskTOClass = taskUtils.taskTOClass();
        if (taskTOClass == null || !taskTOClass.equals(taskTO.getClass())) {
            throw new IllegalArgumentException(String.format("taskUtils is type %s but task is not: %s", taskTOClass, taskTO.getClass()));
        }
        SchedTask task = (SchedTask)taskUtils.newTask();
        task.setStartAt(taskTO.getStartAt());
        task.setCronExpression(taskTO.getCronExpression());
        task.setName(taskTO.getName());
        task.setDescription(taskTO.getDescription());
        task.setActive(taskTO.isActive());
        if (taskUtils.getType() == TaskType.SCHEDULED) {
            task.setJobDelegateClassName(taskTO.getJobDelegateClassName());
        } else if (taskTO instanceof AbstractProvisioningTaskTO) {
            AbstractProvisioningTaskTO provisioningTaskTO = (AbstractProvisioningTaskTO)taskTO;
            ExternalResource resource = this.resourceDAO.find(provisioningTaskTO.getResource());
            if (resource == null) {
                throw new NotFoundException("Resource " + provisioningTaskTO.getResource());
            }
            ((ProvisioningTask)task).setResource(resource);
            this.fill((ProvisioningTask)task, provisioningTaskTO);
        }
        return task;
    }

    public void updateSchedTask(SchedTask task, SchedTaskTO taskTO, TaskUtils taskUtils) {
        Class taskClass = taskUtils.taskClass();
        Class taskTOClass = taskUtils.taskTOClass();
        if (taskClass == null || !taskClass.isAssignableFrom(task.getClass())) {
            throw new IllegalArgumentException(String.format("taskUtils is type %s but task is not: %s", taskClass, task.getClass()));
        }
        if (taskTOClass == null || !taskTOClass.equals(taskTO.getClass())) {
            throw new IllegalArgumentException(String.format("taskUtils is type %s but task is not: %s", taskTOClass, taskTO.getClass()));
        }
        task.setCronExpression(taskTO.getCronExpression());
        if (StringUtils.isNotBlank((CharSequence)taskTO.getName())) {
            task.setName(taskTO.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)taskTO.getDescription())) {
            task.setDescription(taskTO.getDescription());
        }
        if (task instanceof ProvisioningTask) {
            this.fill((ProvisioningTask)task, (AbstractProvisioningTaskTO)taskTO);
        }
    }

    public TaskExecTO getTaskExecTO(TaskExec execution) {
        TaskExecTO executionTO = new TaskExecTO();
        BeanUtils.copyProperties((Object)execution, (Object)executionTO, (String[])IGNORE_TASK_EXECUTION_PROPERTIES);
        if (execution.getKey() != null) {
            executionTO.setKey(((Long)execution.getKey()).longValue());
        }
        if (execution.getTask() != null && execution.getTask().getKey() != null) {
            executionTO.setTask(((Long)execution.getTask().getKey()).longValue());
        }
        return executionTO;
    }

    private void setExecTime(SchedTaskTO taskTO, Task task) {
        String triggerName = JobNamer.getTriggerName((String)JobNamer.getJobName((Task)task));
        Trigger trigger = null;
        try {
            trigger = this.scheduler.getScheduler().getTrigger(new TriggerKey(triggerName, "DEFAULT"));
        }
        catch (SchedulerException e) {
            LOG.warn("While trying to get to " + triggerName, (Throwable)e);
        }
        if (trigger != null) {
            taskTO.setLastExec(trigger.getPreviousFireTime());
            taskTO.setNextExec(trigger.getNextFireTime());
        }
    }

    public <T extends AbstractTaskTO> T getTaskTO(Task task, TaskUtils taskUtils, boolean details) {
        AbstractTaskTO taskTO = taskUtils.newTaskTO();
        BeanUtils.copyProperties((Object)task, (Object)taskTO, (String[])IGNORE_TASK_PROPERTIES);
        TaskExec latestExec = this.taskExecDAO.findLatestStarted(task);
        taskTO.setLatestExecStatus(latestExec == null ? "" : latestExec.getStatus());
        taskTO.setStart(latestExec == null ? null : latestExec.getStart());
        taskTO.setEnd(latestExec == null ? null : latestExec.getEnd());
        if (details) {
            for (TaskExec execution : task.getExecs()) {
                if (execution == null) continue;
                taskTO.getExecutions().add(this.getTaskExecTO(execution));
            }
        }
        switch (taskUtils.getType()) {
            case PROPAGATION: {
                if (!(task instanceof PropagationTask)) {
                    throw new IllegalArgumentException("taskUtils is type Propagation but task is not PropagationTask: " + task.getClass().getName());
                }
                ((PropagationTaskTO)taskTO).setResource((String)((PropagationTask)task).getResource().getKey());
                ((PropagationTaskTO)taskTO).setAttributes(((PropagationTask)task).getSerializedAttributes());
                break;
            }
            case SCHEDULED: {
                if (!(task instanceof SchedTask)) {
                    throw new IllegalArgumentException("taskUtils is type Sched but task is not SchedTask: " + task.getClass().getName());
                }
                this.setExecTime((SchedTaskTO)taskTO, task);
                break;
            }
            case SYNCHRONIZATION: {
                if (!(task instanceof SyncTask)) {
                    throw new IllegalArgumentException("taskUtils is type Sync but task is not SyncTask: " + task.getClass().getName());
                }
                this.setExecTime((SchedTaskTO)taskTO, task);
                ((SyncTaskTO)taskTO).setDestinationRealm(((SyncTask)task).getDestinatioRealm().getFullPath());
                ((SyncTaskTO)taskTO).setResource((String)((SyncTask)task).getResource().getKey());
                ((SyncTaskTO)taskTO).setMatchingRule(((SyncTask)task).getMatchingRule() == null ? MatchingRule.UPDATE : ((SyncTask)task).getMatchingRule());
                ((SyncTaskTO)taskTO).setUnmatchingRule(((SyncTask)task).getUnmatchingRule() == null ? UnmatchingRule.PROVISION : ((SyncTask)task).getUnmatchingRule());
                for (AnyTemplate template : ((SyncTask)task).getTemplates()) {
                    ((SyncTaskTO)taskTO).getTemplates().put(template.getAnyType().getKey(), template.get());
                }
                break;
            }
            case PUSH: {
                if (!(task instanceof PushTask)) {
                    throw new IllegalArgumentException("taskUtils is type Push but task is not PushTask: " + task.getClass().getName());
                }
                this.setExecTime((SchedTaskTO)taskTO, task);
                ((PushTaskTO)taskTO).setResource((String)((PushTask)task).getResource().getKey());
                ((PushTaskTO)taskTO).setMatchingRule(((PushTask)task).getMatchingRule() == null ? MatchingRule.LINK : ((PushTask)task).getMatchingRule());
                ((PushTaskTO)taskTO).setUnmatchingRule(((PushTask)task).getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : ((PushTask)task).getUnmatchingRule());
                for (PushTaskAnyFilter filter : ((PushTask)task).getFilters()) {
                    ((PushTaskTO)taskTO).getFilters().put(filter.getAnyType().getKey(), filter.getFIQLCond());
                }
                break;
            }
            case NOTIFICATION: {
                if (!((NotificationTask)task).isExecuted() || !StringUtils.isBlank((CharSequence)taskTO.getLatestExecStatus())) break;
                taskTO.setLatestExecStatus("[EXECUTED]");
                break;
            }
        }
        return (T)taskTO;
    }
}

