/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ClassUtils;
import org.apache.syncope.core.misc.security.AuthContextUtils;
import org.apache.syncope.core.misc.spring.ApplicationContextProvider;
import org.apache.syncope.core.misc.utils.FormatUtils;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public class TaskJob
implements InterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(TaskJob.class);
    public static final String DRY_RUN_JOBDETAIL_KEY = "dryRun";
    public static final String DELEGATE_CLASS_KEY = "delegateClass";
    public static final String INTERRUPT_MAX_RETRIES_KEY = "interruptMaxRetries";
    private final AtomicReference<Thread> runningThread = new AtomicReference();
    private Long taskKey;
    private long interruptMaxRetries = 1L;

    public void setTaskKey(Long taskKey) {
        this.taskKey = taskKey;
    }

    public void execute(final JobExecutionContext context) throws JobExecutionException {
        this.runningThread.set(Thread.currentThread());
        this.interruptMaxRetries = context.getMergedJobDataMap().getLong(INTERRUPT_MAX_RETRIES_KEY);
        try {
            AuthContextUtils.execWithAuthContext((String)context.getMergedJobDataMap().getString("domain"), (AuthContextUtils.Executable)new AuthContextUtils.Executable<Void>(){

                public Void exec() {
                    try {
                        Class delegateClass = ClassUtils.getClass((String)context.getMergedJobDataMap().getString(TaskJob.DELEGATE_CLASS_KEY));
                        ((SchedTaskJobDelegate)ApplicationContextProvider.getBeanFactory().createBean(delegateClass, 1, false)).execute(TaskJob.this.taskKey, context.getMergedJobDataMap().getBoolean(TaskJob.DRY_RUN_JOBDETAIL_KEY));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            throw new JobExecutionException(e.getCause());
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        Thread thread = this.runningThread.getAndSet(null);
        if (thread == null) {
            LOG.warn("Unable to retrieve the thread of the current job execution");
        } else {
            LOG.info("Interrupting job from thread {} at {} ", (Object)thread.getId(), (Object)FormatUtils.format((Date)new Date()));
            if (this.interruptMaxRetries < 1L) {
                this.interruptMaxRetries = 1L;
            }
            int i = 0;
            while ((long)i < this.interruptMaxRetries && thread.isAlive()) {
                thread.interrupt();
                ++i;
            }
            if (thread.isAlive()) {
                this.runningThread.set(thread);
            }
        }
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

