/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.notification;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.IntMappingType;
import org.apache.syncope.core.misc.search.SearchCondConverter;
import org.apache.syncope.core.misc.spring.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyAbout;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.notification.NotificationRecipientsProvider;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class NotificationManagerImpl
implements NotificationManager {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationManager.class);
    public static final String MAIL_TEMPLATES = "mailTemplates/";
    public static final String MAIL_TEMPLATE_HTML_SUFFIX = ".html.vm";
    public static final String MAIL_TEMPLATE_TEXT_SUFFIX = ".txt.vm";
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private VelocityEngine velocityEngine;
    @Autowired
    private ToolManager velocityToolManager;
    @Autowired
    private DerAttrHandler derAttrHander;
    @Autowired
    private VirAttrHandler virAttrHander;
    @Autowired
    private UserDataBinder userDataBinder;
    @Autowired
    private GroupDataBinder groupDataBinder;
    @Autowired
    private EntityFactory entityFactory;

    @Transactional(readOnly=true)
    public long getMaxRetries() {
        return ((CPlainAttrValue)this.confDAO.find("notification.maxRetries", "0").getValues().get(0)).getLongValue();
    }

    private NotificationTask getNotificationTask(Notification notification, Any<?> any, Map<String, Object> model) {
        if (any != null) {
            this.virAttrHander.getValues(any);
        }
        ArrayList<User> recipients = new ArrayList<User>();
        if (notification.getRecipientsFIQL() != null) {
            recipients.addAll(this.searchDAO.search(SearchCondConverter.convert((String)notification.getRecipientsFIQL(), (String[])new String[0]), Collections.emptyList(), AnyTypeKind.USER));
        }
        if (notification.isSelfAsRecipient() && any instanceof User) {
            recipients.add((User)any);
        }
        HashSet<String> recipientEmails = new HashSet<String>();
        ArrayList<UserTO> recipientTOs = new ArrayList<UserTO>(recipients.size());
        for (User recipient : recipients) {
            this.virAttrHander.getValues((Any)recipient);
            String email = this.getRecipientEmail(notification.getRecipientAttrType(), notification.getRecipientAttrName(), recipient);
            if (email == null) {
                LOG.warn("{} cannot be notified: {} not found", (Object)recipient, (Object)notification.getRecipientAttrName());
                continue;
            }
            recipientEmails.add(email);
            recipientTOs.add(this.userDataBinder.getUserTO(recipient, true));
        }
        if (notification.getStaticRecipients() != null) {
            recipientEmails.addAll(notification.getStaticRecipients());
        }
        if (notification.getRecipientsProviderClassName() != null) {
            try {
                NotificationRecipientsProvider recipientsProvider = (NotificationRecipientsProvider)ApplicationContextProvider.getBeanFactory().createBean(Class.forName(notification.getRecipientsProviderClassName()), 1, false);
                recipientEmails.addAll(recipientsProvider.provideRecipients(notification));
            }
            catch (Exception e) {
                LOG.error("Could not fetch recipients from {}", (Object)notification.getRecipientsProviderClassName(), (Object)e);
            }
        }
        model.put("recipients", recipientTOs);
        model.put("syncopeConf", this.findAllSyncopeConfs());
        model.put("events", notification.getEvents());
        NotificationTask task = (NotificationTask)this.entityFactory.newEntity(NotificationTask.class);
        task.setTraceLevel(notification.getTraceLevel());
        task.getRecipients().addAll(recipientEmails);
        task.setSender(notification.getSender());
        task.setSubject(notification.getSubject());
        String htmlBody = this.mergeTemplateIntoString(MAIL_TEMPLATES + notification.getTemplate() + MAIL_TEMPLATE_HTML_SUFFIX, model);
        String textBody = this.mergeTemplateIntoString(MAIL_TEMPLATES + notification.getTemplate() + MAIL_TEMPLATE_TEXT_SUFFIX, model);
        task.setHtmlBody(htmlBody);
        task.setTextBody(textBody);
        return task;
    }

    private String mergeTemplateIntoString(String templateLocation, Map<String, Object> model) {
        StringWriter result = new StringWriter();
        try {
            Context velocityContext = this.createVelocityContext(model);
            this.velocityEngine.mergeTemplate(templateLocation, "UTF-8", velocityContext, (Writer)result);
        }
        catch (VelocityException e) {
            LOG.error("Could not get mail body", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Could not get mail body", (Throwable)e);
        }
        return result.toString();
    }

    protected Context createVelocityContext(Map<String, Object> model) {
        ToolContext toolContext = this.velocityToolManager.createContext();
        return new VelocityContext(model, (Context)toolContext);
    }

    public List<NotificationTask> createTasks(AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result condition, Object before, Object output, Object ... input) {
        Any any = null;
        if (before instanceof UserTO) {
            any = this.userDAO.find(Long.valueOf(((UserTO)before).getKey()));
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getAny() instanceof UserTO) {
            any = this.userDAO.find(Long.valueOf(((ProvisioningResult)output).getAny().getKey()));
        } else if (before instanceof AnyObjectTO) {
            any = this.anyObjectDAO.find(Long.valueOf(((AnyObjectTO)before).getKey()));
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getAny() instanceof AnyObjectTO) {
            any = this.anyObjectDAO.find(Long.valueOf(((ProvisioningResult)output).getAny().getKey()));
        } else if (before instanceof GroupTO) {
            any = this.groupDAO.find(Long.valueOf(((GroupTO)before).getKey()));
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getAny() instanceof GroupTO) {
            any = this.groupDAO.find(Long.valueOf(((ProvisioningResult)output).getAny().getKey()));
        }
        AnyType anyType = any == null ? null : any.getType();
        LOG.debug("Search notification for [{}]{}", (Object)anyType, (Object)any);
        ArrayList<NotificationTask> notifications = new ArrayList<NotificationTask>();
        for (Notification notification : this.notificationDAO.findAll()) {
            if (LOG.isDebugEnabled()) {
                for (AnyAbout about : notification.getAbouts()) {
                    LOG.debug("Notification about {} defined: {}", (Object)about.getAnyType(), (Object)about.get());
                }
            }
            if (notification.isActive()) {
                String currentEvent = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)type, (String)category, (String)subcategory, (String)event, (AuditElements.Result)condition);
                if (!notification.getEvents().contains(currentEvent)) {
                    LOG.debug("No events found about {}", (Object)any);
                    continue;
                }
                if (anyType != null && any != null && notification.getAbout(anyType) != null && !this.searchDAO.matches(any, SearchCondConverter.convert((String)notification.getAbout(anyType).get(), (String[])new String[0]), anyType.getKind())) continue;
                LOG.debug("Creating notification task for event {} about {}", (Object)currentEvent, (Object)any);
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("type", type);
                model.put("category", category);
                model.put("subcategory", subcategory);
                model.put("event", event);
                model.put("condition", condition);
                model.put("before", before);
                model.put("output", output);
                model.put("input", input);
                if (any instanceof User) {
                    model.put("user", this.userDataBinder.getUserTO((User)any, true));
                } else if (any instanceof Group) {
                    model.put("group", this.groupDataBinder.getGroupTO((Group)any, true));
                }
                NotificationTask notificationTask = this.getNotificationTask(notification, any, model);
                notificationTask = (NotificationTask)this.taskDAO.save((Task)notificationTask);
                notifications.add(notificationTask);
                continue;
            }
            LOG.debug("Notification {} is not active, task will not be created", notification.getKey());
        }
        return notifications;
    }

    private String getRecipientEmail(IntMappingType recipientAttrType, String recipientAttrName, User user) {
        String email = null;
        switch (recipientAttrType) {
            case Username: {
                email = user.getUsername();
                break;
            }
            case UserPlainSchema: {
                UPlainAttr attr = user.getPlainAttr(recipientAttrName);
                if (attr == null) break;
                email = attr.getValuesAsStrings().isEmpty() ? null : (String)attr.getValuesAsStrings().get(0);
                break;
            }
            case UserDerivedSchema: {
                DerSchema schema = (DerSchema)this.derSchemaDAO.find(recipientAttrName);
                if (schema == null) {
                    LOG.warn("Ignoring non existing {} {}", (Object)DerSchema.class.getSimpleName(), (Object)recipientAttrName);
                    break;
                }
                email = this.derAttrHander.getValue((Any)user, schema);
                break;
            }
            case UserVirtualSchema: {
                VirSchema virSchema = (VirSchema)this.virSchemaDAO.find(recipientAttrName);
                if (virSchema == null) {
                    LOG.warn("Ignoring non existing {} {}", (Object)VirSchema.class.getSimpleName(), (Object)recipientAttrName);
                    break;
                }
                List virAttrValues = this.virAttrHander.getValues((Any)user, virSchema);
                email = virAttrValues.isEmpty() ? null : (String)virAttrValues.get(0);
                break;
            }
        }
        return email;
    }

    public TaskExec storeExec(TaskExec execution) {
        NotificationTask task = (NotificationTask)this.taskDAO.find((Long)execution.getTask().getKey());
        task.addExec(execution);
        task.setExecuted(true);
        this.taskDAO.save((Task)task);
        this.taskDAO.flush();
        return execution;
    }

    public void setTaskExecuted(Long taskKey, boolean executed) {
        NotificationTask task = (NotificationTask)this.taskDAO.find(taskKey);
        task.setExecuted(executed);
        this.taskDAO.save((Task)task);
    }

    public long countExecutionsWithStatus(Long taskKey, String status) {
        NotificationTask task = (NotificationTask)this.taskDAO.find(taskKey);
        long count = 0L;
        for (TaskExec taskExec : task.getExecs()) {
            if (status == null) {
                if (taskExec.getStatus() != null) continue;
                ++count;
                continue;
            }
            if (!status.equals(taskExec.getStatus())) continue;
            ++count;
        }
        return count;
    }

    protected Map<String, String> findAllSyncopeConfs() {
        HashMap<String, String> syncopeConfMap = new HashMap<String, String>();
        for (PlainAttr attr : this.confDAO.get().getPlainAttrs()) {
            syncopeConfMap.put((String)attr.getSchema().getKey(), (String)attr.getValuesAsStrings().get(0));
        }
        return syncopeConfMap;
    }
}

