/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.PropagationByResource;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.misc.utils.MappingUtils;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.sync.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.sync.PushActions;
import org.apache.syncope.core.provisioning.api.sync.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.java.sync.AbstractSyncopeResultHandler;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractPushResultHandler
extends AbstractSyncopeResultHandler<PushTask, PushActions>
implements SyncopePushResultHandler {
    @Autowired
    protected MappingUtils mappingUtils;

    protected abstract String getName(Any<?> var1);

    protected void deprovision(Any<?> any) {
        AnyTO before = this.getAnyTO((Long)any.getKey());
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(any.getType().getKind(), (Long)any.getKey(), null, noPropResources));
    }

    protected void provision(Any<?> any, Boolean enabled) {
        AnyTO before = this.getAnyTO((Long)any.getKey());
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.CREATE, (String)((PushTask)this.profile.getTask()).getResource().getKey());
        this.taskExecutor.execute((Collection)this.propagationManager.getCreateTasks(any.getType().getKind(), (Long)any.getKey(), propByRes, (Collection)before.getVirAttrs(), noPropResources));
    }

    protected void link(Any<?> any, Boolean unlink) {
        AnyPatch patch = this.newPatch((Long)any.getKey());
        patch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(unlink != false ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).value(((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.update(patch);
    }

    protected void unassign(Any<?> any) {
        AnyPatch patch = this.newPatch((Long)any.getKey());
        patch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.update(patch);
        this.deprovision(any);
    }

    protected void assign(Any<?> any, Boolean enabled) {
        AnyPatch patch = this.newPatch((Long)any.getKey());
        patch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.update(patch);
        this.provision(any, enabled);
    }

    protected ConnectorObject getRemoteObject(String connObjectKey, ObjectClass objectClass) {
        ConnectorObject obj = null;
        try {
            Uid uid = new Uid(connObjectKey);
            obj = this.profile.getConnector().getObject(objectClass, uid, MappingUtils.buildOperationOptions((Iterator)IteratorUtils.emptyIterator()));
        }
        catch (TimeoutException toe) {
            LOG.debug("Request timeout", (Throwable)toe);
            throw toe;
        }
        catch (RuntimeException ignore) {
            LOG.debug("While resolving {}", (Object)connObjectKey, (Object)ignore);
        }
        return obj;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean handle(long anyKey) {
        Any<?> any = null;
        try {
            any = this.getAny(anyKey);
            this.doHandle(any);
            return true;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType(any == null ? null : (String)any.getType().getKey());
            result.setStatus(ProvisioningReport.Status.IGNORE);
            result.setKey(Long.valueOf(anyKey));
            this.profile.getResults().add(result);
            LOG.warn("Ignoring during push", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Push failed", (Throwable)e);
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void doHandle(Any<?> any) throws JobExecutionException {
        Boolean status;
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(any);
        ProvisioningReport result = new ProvisioningReport();
        this.profile.getResults().add(result);
        result.setKey((Long)any.getKey());
        result.setAnyType((String)any.getType().getKey());
        result.setName(this.getName(any));
        Boolean enabled = any instanceof User && ((PushTask)this.profile.getTask()).isSyncStatus() ? (((User)any).isSuspended().booleanValue() ? Boolean.FALSE : Boolean.TRUE) : null;
        LOG.debug("Propagating {} with key {} towards {}", new Object[]{anyUtils.getAnyTypeKind(), any.getKey(), ((PushTask)this.profile.getTask()).getResource()});
        Exception output = null;
        AuditElements.Result resultStatus = null;
        String operation = null;
        Provision provision = ((PushTask)this.profile.getTask()).getResource().getProvision(any.getType());
        String connObjecKey = this.mappingUtils.getConnObjectKeyValue(any, provision);
        ConnectorObject beforeObj = this.getRemoteObject(connObjecKey, provision.getObjectClass());
        Boolean bl = status = ((PushTask)this.profile.getTask()).isSyncStatus() ? enabled : null;
        if (this.profile.isDryRun()) {
            if (beforeObj == null) {
                result.setOperation(this.getResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
            } else {
                result.setOperation(this.getResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
            }
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            return;
        }
        try {
            if (beforeObj == null) {
                operation = UnmatchingRule.toEventName((UnmatchingRule)((PushTask)this.profile.getTask()).getUnmatchingRule());
                result.setOperation(this.getResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
                switch (((PushTask)this.profile.getTask()).getUnmatchingRule()) {
                    case ASSIGN: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeAssign(this.getProfile(), any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            LOG.debug("PushTask not configured for create");
                            break;
                        }
                        this.assign(any, status);
                        break;
                    }
                    case PROVISION: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeProvision(this.getProfile(), any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            LOG.debug("PushTask not configured for create");
                            break;
                        }
                        this.provision(any, status);
                        break;
                    }
                    case UNLINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.getProfile(), any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            break;
                        }
                        this.link(any, true);
                        break;
                    }
                    case IGNORE: {
                        LOG.debug("Ignored any: {}", any);
                        break;
                    }
                }
            } else {
                operation = MatchingRule.toEventName((MatchingRule)((PushTask)this.profile.getTask()).getMatchingRule());
                result.setOperation(this.getResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
                switch (((PushTask)this.profile.getTask()).getMatchingRule()) {
                    case UPDATE: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.getProfile(), any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            break;
                        }
                        this.update(any, status);
                        break;
                    }
                    case DEPROVISION: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeDeprovision(this.getProfile(), any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            LOG.debug("PushTask not configured for delete");
                            break;
                        }
                        this.deprovision(any);
                        break;
                    }
                    case UNASSIGN: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnassign(this.getProfile(), any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            LOG.debug("PushTask not configured for delete");
                            break;
                        }
                        this.unassign(any);
                        break;
                    }
                    case LINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeLink(this.getProfile(), any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            break;
                        }
                        this.link(any, false);
                        break;
                    }
                    case UNLINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.getProfile(), any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            break;
                        }
                        this.link(any, true);
                        break;
                    }
                    case IGNORE: {
                        LOG.debug("Ignored any: {}", any);
                        break;
                    }
                }
            }
            for (PushActions action : this.profile.getActions()) {
                action.after(this.getProfile(), any, result);
            }
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            resultStatus = AuditElements.Result.SUCCESS;
            output = this.getRemoteObject(connObjecKey, provision.getObjectClass());
        }
        catch (IgnoreProvisionException e) {
            try {
                throw e;
                catch (Exception e2) {
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e2));
                    resultStatus = AuditElements.Result.FAILURE;
                    output = e2;
                    LOG.warn("Error pushing {} towards {}", new Object[]{any, ((PushTask)this.profile.getTask()).getResource(), e2});
                    Iterator iterator = this.profile.getActions().iterator();
                    while (iterator.hasNext()) {
                        PushActions action = (PushActions)iterator.next();
                        action.onError(this.getProfile(), any, result, e2);
                    }
                    throw new JobExecutionException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.notificationManager.createTasks(AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), (String)((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, (Object)output, new Object[]{any});
                this.auditManager.audit(AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), (String)((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, (Object)output, new Object[]{any});
                throw throwable;
            }
        }
        this.notificationManager.createTasks(AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), (String)((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, (Object)output, new Object[]{any});
        this.auditManager.audit(AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), (String)((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, (Object)output, new Object[]{any});
    }

    private ResourceOperation getResourceOperation(UnmatchingRule rule) {
        switch (rule) {
            case ASSIGN: 
            case PROVISION: {
                return ResourceOperation.CREATE;
            }
        }
        return ResourceOperation.NONE;
    }

    private ResourceOperation getResourceOperation(MatchingRule rule) {
        switch (rule) {
            case UPDATE: {
                return ResourceOperation.UPDATE;
            }
            case DEPROVISION: 
            case UNASSIGN: {
                return ResourceOperation.DELETE;
            }
        }
        return ResourceOperation.NONE;
    }

    protected Any<?> update(Any<?> any, Boolean enabled) {
        Collection resourceNames;
        boolean changepwd;
        if (any instanceof User) {
            changepwd = true;
            resourceNames = this.userDAO.findAllResourceNames((User)any);
        } else if (any instanceof AnyObject) {
            changepwd = false;
            resourceNames = this.anyObjectDAO.findAllResourceNames((AnyObject)any);
        } else {
            changepwd = false;
            resourceNames = ((Group)any).getResourceNames();
        }
        ArrayList noPropResources = new ArrayList(resourceNames);
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.CREATE, (String)((PushTask)this.profile.getTask()).getResource().getKey());
        this.taskExecutor.execute((Collection)this.propagationManager.getUpdateTasks(any.getType().getKind(), (Long)any.getKey(), changepwd, null, propByRes, null, noPropResources));
        return this.getAny((Long)any.getKey());
    }
}

