/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.misc.AuditManager;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.SyncTask;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.sync.DefaultSyncActions;
import org.apache.syncope.core.provisioning.java.sync.SyncUtils;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LDAPMembershipSyncActions
extends DefaultSyncActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPMembershipSyncActions.class);
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected UserWorkflowAdapter uwfAdapter;
    @Autowired
    protected PropagationManager propagationManager;
    @Autowired
    private PropagationTaskExecutor taskExecutor;
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private SyncUtils syncUtils;
    protected Map<Long, Long> membersBeforeGroupUpdate = Collections.emptyMap();

    protected String getGroupMembershipAttrName(Connector connector) {
        ConnConfProperty groupMembership = (ConnConfProperty)IterableUtils.find((Iterable)connector.getConnInstance().getConf(), (Predicate)new Predicate<ConnConfProperty>(){

            public boolean evaluate(ConnConfProperty property) {
                return "groupMemberAttribute".equals(property.getSchema().getName()) && property.getValues() != null && !property.getValues().isEmpty();
            }
        });
        return groupMembership == null ? "uniquemember" : (String)groupMembership.getValues().get(0);
    }

    public <A extends AnyTO, M extends AnyPatch> SyncDelta beforeUpdate(ProvisioningProfile<?, ?> profile, SyncDelta delta, A any, M anyPatch) throws JobExecutionException {
        Group group;
        if (any instanceof GroupTO && (group = (Group)this.groupDAO.find(Long.valueOf(any.getKey()))) != null) {
            List membs = this.groupDAO.findUMemberships(group);
            this.membersBeforeGroupUpdate = new HashMap<Long, Long>(membs.size());
            for (UMembership memb : membs) {
                this.membersBeforeGroupUpdate.put((Long)((User)memb.getLeftEnd()).getKey(), (Long)memb.getKey());
            }
        }
        return super.beforeUpdate(profile, delta, any, anyPatch);
    }

    protected UserPatch getUserPatch(Long userKey, GroupTO groupTO) {
        UserPatch userPatch = new UserPatch();
        if (this.membersBeforeGroupUpdate.containsKey(userKey)) {
            this.membersBeforeGroupUpdate.remove(userKey);
        } else {
            userPatch.setKey(userKey.longValue());
            userPatch.getMemberships().add(((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).membershipTO(new MembershipTO.Builder().group(groupTO.getKey(), null).build()).build());
        }
        return userPatch;
    }

    protected List<Object> getMembAttrValues(SyncDelta delta, Connector connector) {
        List result = Collections.emptyList();
        String groupMemberName = this.getGroupMembershipAttrName(connector);
        Attribute membAttr = delta.getObject().getAttributeByName(groupMemberName);
        if (membAttr == null) {
            OperationOptionsBuilder oob = new OperationOptionsBuilder();
            oob.setAttributesToGet(new String[]{groupMemberName});
            ConnectorObject remoteObj = connector.getObject(ObjectClass.GROUP, delta.getUid(), oob.build());
            if (remoteObj == null) {
                LOG.debug("Object for '{}' not found", (Object)delta.getUid().getUidValue());
            } else {
                membAttr = remoteObj.getAttributeByName(groupMemberName);
            }
        }
        if (membAttr != null && membAttr.getValue() != null) {
            result = membAttr.getValue();
        }
        return result;
    }

    protected void userUpdate(UserPatch userPatch, String resourceName) {
        AuditElements.Result result;
        if (userPatch.getKey() == 0L) {
            return;
        }
        WorkflowResult updated = null;
        try {
            updated = this.uwfAdapter.update(userPatch);
            List tasks = this.propagationManager.getUserUpdateTasks(updated, false, Collections.singleton(resourceName));
            this.taskExecutor.execute((Collection)tasks);
            result = AuditElements.Result.SUCCESS;
        }
        catch (PropagationException e) {
            result = AuditElements.Result.FAILURE;
            LOG.error("Could not propagate {}", (Object)userPatch, (Object)e);
        }
        catch (Exception e) {
            result = AuditElements.Result.FAILURE;
            LOG.error("Could not perform update {}", (Object)userPatch, (Object)e);
        }
        this.notificationManager.createTasks(AuditElements.EventCategoryType.SYNCHRONIZATION, this.getClass().getSimpleName(), null, "update", result, null, (Object)(updated == null ? null : (UserPatch)((Pair)updated.getResult()).getKey()), new Object[]{userPatch, resourceName});
        this.auditManager.audit(AuditElements.EventCategoryType.SYNCHRONIZATION, this.getClass().getSimpleName(), null, "update", result, null, (Object)(updated == null ? null : (UserPatch)((Pair)updated.getResult()).getKey()), new Object[]{userPatch, resourceName});
    }

    protected void synchronizeMemberships(ProvisioningProfile<?, ?> profile, SyncDelta delta, GroupTO groupTO) throws JobExecutionException {
        ProvisioningTask task = profile.getTask();
        ExternalResource resource = task.getResource();
        Connector connector = profile.getConnector();
        for (Object object : this.getMembAttrValues(delta, connector)) {
            Long userKey = this.syncUtils.findMatchingAnyKey(this.anyTypeDAO.findUser(), object.toString(), profile.getTask().getResource(), profile.getConnector());
            if (userKey == null) continue;
            UserPatch userPatch = this.getUserPatch(userKey, groupTO);
            this.userUpdate(userPatch, (String)resource.getKey());
        }
        for (Map.Entry entry : this.membersBeforeGroupUpdate.entrySet()) {
            UserPatch userPatch = new UserPatch();
            userPatch.setKey(((Long)entry.getKey()).longValue());
            userPatch.getMemberships().add(((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.DELETE)).membershipTO(new MembershipTO.Builder().group(groupTO.getKey(), null).build()).build());
            this.userUpdate(userPatch, (String)resource.getKey());
        }
    }

    @Override
    public <A extends AnyTO> void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, A any, ProvisioningReport result) throws JobExecutionException {
        if (!(profile.getTask() instanceof SyncTask)) {
            return;
        }
        if (!(any instanceof GroupTO) || profile.getTask().getResource().getProvision(this.anyTypeDAO.findUser()) == null || profile.getTask().getResource().getProvision(this.anyTypeDAO.findUser()).getMapping() == null) {
            super.after(profile, delta, any, result);
        } else {
            this.synchronizeMemberships(profile, delta, (GroupTO)any);
        }
    }
}

