/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import java.util.List;
import org.apache.tapestry5.hibernate.HibernateConfigurer;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.internal.hibernate.HibernateCoreMessages;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSessionSourceImpl
implements HibernateSessionSource {
    private final SessionFactory sessionFactory;
    private final Configuration configuration;

    public HibernateSessionSourceImpl(Logger logger, List<HibernateConfigurer> hibernateConfigurers) {
        long startTime = System.currentTimeMillis();
        this.configuration = new AnnotationConfiguration();
        for (HibernateConfigurer configurer : hibernateConfigurers) {
            configurer.configure(this.configuration);
        }
        long configurationComplete = System.currentTimeMillis();
        this.sessionFactory = this.configuration.buildSessionFactory();
        long factoryCreated = System.currentTimeMillis();
        logger.info(HibernateCoreMessages.startupTiming(configurationComplete - startTime, factoryCreated - startTime));
        logger.info(HibernateCoreMessages.entityCatalog(this.sessionFactory.getAllClassMetadata().keySet()));
    }

    @PostInjection
    public void listenForShutdown(RegistryShutdownHub hub) {
        hub.addRegistryShutdownListener(new Runnable(){

            public void run() {
                HibernateSessionSourceImpl.this.sessionFactory.close();
            }
        });
    }

    @Override
    public Session create() {
        return this.sessionFactory.openSession();
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

