/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import org.apache.tapestry5.hibernate.HibernateSessionManager;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class HibernateSessionManagerImpl
implements HibernateSessionManager,
ThreadCleanupListener {
    private final Session session;
    private Transaction transaction;

    public HibernateSessionManagerImpl(HibernateSessionSource source) {
        this.session = source.create();
        this.startNewTransaction();
    }

    private void startNewTransaction() {
        this.transaction = this.session.beginTransaction();
    }

    public void abort() {
        this.transaction.rollback();
        this.startNewTransaction();
    }

    public void commit() {
        this.transaction.commit();
        this.startNewTransaction();
    }

    public Session getSession() {
        return this.session;
    }

    public void threadDidCleanup() {
        this.transaction.rollback();
        this.session.close();
    }
}

