/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.tika.metadata;

/**
 * A collection of Microsoft Office documents property names.
 */
public interface MSOffice {

    String KEYWORDS = "Keywords";

    String COMMENTS = "Comments";

    String LAST_AUTHOR = "Last-Author";

    String APPLICATION_NAME = "Application-Name";

    String CHARACTER_COUNT = "Character Count";

    String LAST_PRINTED = "Last-Printed";

    String LAST_SAVED = "Last-Save-Date";

    String PAGE_COUNT = "Page-Count";

    String REVISION_NUMBER = "Revision-Number";

    String WORD_COUNT = "Word-Count";

    String TEMPLATE = "Template";

    String AUTHOR = "Author";

    String TOTAL_TIME = "Total-Time";

    String SLIDE_COUNT = "Slide-Count";

    String PRESENTATION_FORMAT = "Presentation-Format";

    String PARAGRAPH_COUNT = "Paragraph-Count";

    String NOTES = "Notes";

    String MANAGER = "Manager";

    String LINE_COUNT = "Line-Count";

    String CHARACTER_COUNT_WITH_SPACES = "Character-Count-With-Spaces";

    String APPLICATION_VERSION = "Application-Version";

    String VERSION = "Version";

    String CONTENT_STATUS = "Content-Status";

    String CATEGORY = "Category";

    String COMPANY = "Company";

    String SECURITY = "Security";

    String EDIT_TIME = "Edit-Time";

    String CREATION_DATE = "Creation-Date";

}
