/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.CorruptedFileException;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedBytesSelector;
import org.apache.tika.extractor.EmbeddedDocumentBytesHandler;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.BoundedInputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RUnpackExtractor
extends ParsingEmbeddedDocumentExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsingEmbeddedDocumentExtractor.class);
    private static final File ABSTRACT_PATH = new File("");
    private EmbeddedBytesSelector embeddedBytesSelector = EmbeddedBytesSelector.ACCEPT_ALL;
    private long bytesExtracted = 0L;
    private final long maxEmbeddedBytesForExtraction;

    public RUnpackExtractor(ParseContext context, long maxEmbeddedBytesForExtraction) {
        super(context);
        this.maxEmbeddedBytesForExtraction = maxEmbeddedBytesForExtraction;
    }

    @Override
    public void parseEmbedded(InputStream stream, ContentHandler handler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
        if (outputHtml) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "package-entry");
            handler.startElement("http://www.w3.org/1999/xhtml", "div", "div", attributes);
        }
        String name = metadata.get("resourceName");
        if (this.isWriteFileNameToContent() && name != null && name.length() > 0 && outputHtml) {
            handler.startElement("http://www.w3.org/1999/xhtml", "h1", "h1", new AttributesImpl());
            char[] chars = name.toCharArray();
            handler.characters(chars, 0, chars.length);
            handler.endElement("http://www.w3.org/1999/xhtml", "h1", "h1");
        }
        try (TemporaryResources tmp = new TemporaryResources();){
            EmbeddedDocumentBytesHandler bytesHandler;
            Object container;
            TikaInputStream newStream = TikaInputStream.get((InputStream)CloseShieldInputStream.wrap((InputStream)stream), tmp, metadata);
            if (stream instanceof TikaInputStream && (container = ((TikaInputStream)((Object)stream)).getOpenContainer()) != null) {
                newStream.setOpenContainer(container);
            }
            if ((bytesHandler = this.context.get(EmbeddedDocumentBytesHandler.class)) != null) {
                this.parseWithBytes(newStream, handler, metadata);
            } else {
                this.parse(newStream, handler, metadata);
            }
        }
        catch (EncryptedDocumentException ede) {
            this.recordException(ede, this.context);
        }
        catch (CorruptedFileException e) {
            throw new IOException(e);
        }
        catch (TikaException e) {
            this.recordException(e, this.context);
        }
        if (outputHtml) {
            handler.endElement("http://www.w3.org/1999/xhtml", "div", "div");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseWithBytes(TikaInputStream stream, ContentHandler handler, Metadata metadata) throws TikaException, IOException, SAXException {
        Path p = stream.getPath();
        try {
            this.parse(stream, handler, metadata);
        }
        finally {
            this.storeEmbeddedBytes(p, metadata);
        }
    }

    private void parse(TikaInputStream stream, ContentHandler handler, Metadata metadata) throws TikaException, IOException, SAXException {
        this.getDelegatingParser().parse((InputStream)((Object)stream), new EmbeddedContentHandler(new BodyContentHandler(handler)), metadata, this.context);
    }

    private void storeEmbeddedBytes(Path p, Metadata metadata) {
        if (!this.embeddedBytesSelector.select(metadata)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("skipping embedded bytes {} <-> {}", (Object)metadata.get("Content-Type"), (Object)metadata.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
            }
            return;
        }
        EmbeddedDocumentBytesHandler embeddedDocumentBytesHandler = this.context.get(EmbeddedDocumentBytesHandler.class);
        int id = metadata.getInt(TikaCoreProperties.EMBEDDED_ID);
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
            if (this.bytesExtracted >= this.maxEmbeddedBytesForExtraction) {
                throw new IOException("Bytes extracted (" + this.bytesExtracted + ") >= max allowed (" + this.maxEmbeddedBytesForExtraction + ")");
            }
            long maxToRead = this.maxEmbeddedBytesForExtraction - this.bytesExtracted;
            try (BoundedInputStream boundedIs = new BoundedInputStream(maxToRead, is);){
                embeddedDocumentBytesHandler.add(id, metadata, boundedIs);
                this.bytesExtracted += boundedIs.getPos();
                if (boundedIs.hasHitBound()) {
                    throw new IOException("Bytes extracted (" + this.bytesExtracted + ") >= max allowed (" + this.maxEmbeddedBytesForExtraction + "). Truncated bytes");
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("problem writing out embedded bytes", (Throwable)e);
        }
    }

    public void setEmbeddedBytesSelector(EmbeddedBytesSelector embeddedBytesSelector) {
        this.embeddedBytesSelector = embeddedBytesSelector;
    }

    public EmbeddedBytesSelector getEmbeddedBytesSelector() {
        return this.embeddedBytesSelector;
    }
}

