/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.extractor;

import java.io.Serializable;
import java.util.Objects;

public class EmbeddedDocumentBytesConfig
implements Serializable {
    private static final long serialVersionUID = -3861669115439125268L;
    public static EmbeddedDocumentBytesConfig SKIP = new EmbeddedDocumentBytesConfig(false);
    private final boolean extractEmbeddedDocumentBytes;
    private int zeroPadName = 0;
    private SUFFIX_STRATEGY suffixStrategy = SUFFIX_STRATEGY.NONE;
    private String embeddedIdPrefix = "-";
    private String emitter;
    private boolean includeOriginal = false;

    public EmbeddedDocumentBytesConfig() {
        this.extractEmbeddedDocumentBytes = true;
    }

    public EmbeddedDocumentBytesConfig(boolean extractEmbeddedDocumentBytes) {
        this.extractEmbeddedDocumentBytes = extractEmbeddedDocumentBytes;
    }

    public static EmbeddedDocumentBytesConfig getSKIP() {
        return SKIP;
    }

    public boolean isExtractEmbeddedDocumentBytes() {
        return this.extractEmbeddedDocumentBytes;
    }

    public int getZeroPadName() {
        return this.zeroPadName;
    }

    public SUFFIX_STRATEGY getSuffixStrategy() {
        return this.suffixStrategy;
    }

    public String getEmbeddedIdPrefix() {
        return this.embeddedIdPrefix;
    }

    public String getEmitter() {
        return this.emitter;
    }

    public boolean isIncludeOriginal() {
        return this.includeOriginal;
    }

    public void setZeroPadName(int zeroPadName) {
        this.zeroPadName = zeroPadName;
    }

    public void setSuffixStrategy(SUFFIX_STRATEGY suffixStrategy) {
        this.suffixStrategy = suffixStrategy;
    }

    public void setSuffixStrategy(String suffixStrategy) {
        this.setSuffixStrategy(SUFFIX_STRATEGY.valueOf(suffixStrategy));
    }

    public void setEmbeddedIdPrefix(String embeddedIdPrefix) {
        this.embeddedIdPrefix = embeddedIdPrefix;
    }

    public void setEmitter(String emitter) {
        this.emitter = emitter;
    }

    public void setIncludeOriginal(boolean includeOriginal) {
        this.includeOriginal = includeOriginal;
    }

    public String toString() {
        return "EmbeddedDocumentBytesConfig{extractEmbeddedDocumentBytes=" + this.extractEmbeddedDocumentBytes + ", zeroPadName=" + this.zeroPadName + ", suffixStrategy=" + this.suffixStrategy + ", embeddedIdPrefix='" + this.embeddedIdPrefix + "', emitter='" + this.emitter + "', includeOriginal=" + this.includeOriginal + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedDocumentBytesConfig that = (EmbeddedDocumentBytesConfig)o;
        if (this.extractEmbeddedDocumentBytes != that.extractEmbeddedDocumentBytes) {
            return false;
        }
        if (this.zeroPadName != that.zeroPadName) {
            return false;
        }
        if (this.includeOriginal != that.includeOriginal) {
            return false;
        }
        if (this.suffixStrategy != that.suffixStrategy) {
            return false;
        }
        if (!Objects.equals(this.embeddedIdPrefix, that.embeddedIdPrefix)) {
            return false;
        }
        return Objects.equals(this.emitter, that.emitter);
    }

    public int hashCode() {
        int result = this.extractEmbeddedDocumentBytes ? 1 : 0;
        result = 31 * result + this.zeroPadName;
        result = 31 * result + (this.suffixStrategy != null ? this.suffixStrategy.hashCode() : 0);
        result = 31 * result + (this.embeddedIdPrefix != null ? this.embeddedIdPrefix.hashCode() : 0);
        result = 31 * result + (this.emitter != null ? this.emitter.hashCode() : 0);
        result = 31 * result + (this.includeOriginal ? 1 : 0);
        return result;
    }

    public static enum SUFFIX_STRATEGY {
        NONE,
        EXISTING,
        DETECTED;


        public static SUFFIX_STRATEGY parse(String s) {
            if (s.equalsIgnoreCase("none")) {
                return NONE;
            }
            if (s.equalsIgnoreCase("existing")) {
                return EXISTING;
            }
            if (s.equalsIgnoreCase("detected")) {
                return DETECTED;
            }
            throw new IllegalArgumentException("can't parse " + s);
        }
    }
}

