/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.langdetect;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.language.detect.LanguageConfidence;
import org.apache.tika.language.detect.LanguageDetector;
import org.apache.tika.language.detect.LanguageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextLangDetector
extends LanguageDetector {
    private static final Logger LOG = LoggerFactory.getLogger(TextLangDetector.class);
    private static final String TEXT_REST_HOST = "http://localhost:8000";
    private static final String TEXT_LID_PATH = "/lid";
    private static String restHostUrlStr;
    private Set<String> languages;
    private CharArrayWriter writer;

    public TextLangDetector() {
        restHostUrlStr = TEXT_REST_HOST;
        this.languages = this.getAllLanguages();
        this.writer = new CharArrayWriter();
    }

    public LanguageDetector loadModels() throws IOException {
        return null;
    }

    public LanguageDetector loadModels(Set<String> set) throws IOException {
        return null;
    }

    public boolean hasModel(String language) {
        return this.languages.contains(language);
    }

    public LanguageDetector setPriors(Map<String, Float> languageProbabilities) throws IOException {
        return null;
    }

    public void reset() {
        this.writer.reset();
    }

    public void addText(char[] cbuf, int off, int len) {
        this.writer.write(cbuf, off, len);
        this.writer.write(32);
    }

    public List<LanguageResult> detectAll() {
        ArrayList<LanguageResult> result = new ArrayList<LanguageResult>();
        String language = this.detect(this.writer.toString());
        if (language != null) {
            result.add(new LanguageResult(language, LanguageConfidence.MEDIUM, 1.0f));
        } else {
            result.add(new LanguageResult(language, LanguageConfidence.NONE, 0.0f));
        }
        return result;
    }

    private Set<String> getAllLanguages() {
        HashSet<String> languages = new HashSet<String>();
        try {
            Response response = WebClient.create((String)(restHostUrlStr + TEXT_LID_PATH)).get();
            String json = (String)response.readEntity(String.class);
            JsonArray jsonArray = new JsonParser().parse(json).getAsJsonObject().get("all_languages").getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                languages.add(jsonElement.toString());
            }
        }
        catch (Exception e) {
            LOG.warn("problem getting and parsing json", (Throwable)e);
        }
        return languages;
    }

    private String detect(String content) {
        String language = null;
        try {
            Response response = WebClient.create((String)(restHostUrlStr + TEXT_LID_PATH)).put((Object)content);
            String json = (String)response.readEntity(String.class);
            language = new JsonParser().parse(json).getAsJsonObject().get("language").getAsString();
        }
        catch (Exception e) {
            LOG.warn("problem detecting", (Throwable)e);
        }
        return language;
    }

    protected static boolean canRun() {
        try {
            Response response = WebClient.create((String)"http://localhost:8000/lid").get();
            String json = (String)response.readEntity(String.class);
            JsonArray jsonArray = new JsonParser().parse(json).getAsJsonObject().get("all_languages").getAsJsonArray();
            return jsonArray.size() != 0;
        }
        catch (Exception e) {
            LOG.warn("Can't run", (Throwable)e);
            return false;
        }
    }
}

