/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.apple;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tika.detect.zip.StreamingDetectContext;
import org.apache.tika.detect.zip.ZipContainerDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.iwork.IWorkPackageParser;
import org.apache.tika.parser.iwork.iwana.IWork13PackageParser;
import org.apache.tika.parser.iwork.iwana.IWork18PackageParser;

public class IWorkDetector
implements ZipContainerDetector {
    private static MediaType detectIWork13(ZipFile zip) {
        if (zip.getEntry("Metadata/BuildVersionHistory.plist") != null) {
            return IWork13PackageParser.IWork13DocumentType.detect(zip);
        }
        return null;
    }

    private static MediaType detectIWork18(ZipFile zip) {
        return IWork18PackageParser.IWork18DocumentType.detect(zip);
    }

    private static MediaType detectIWork(ZipFile zip) {
        if (zip.getEntry("buildVersionHistory.plist") != null) {
            for (String entryName : IWorkPackageParser.IWORK_CONTENT_ENTRIES) {
                IWorkPackageParser.IWORKDocumentType type = IWorkPackageParser.IWORKDocumentType.detectType(zip.getEntry(entryName), zip);
                if (type == null) continue;
                return type.getType();
            }
            return MediaType.application((String)"vnd.apple.iwork");
        }
        return null;
    }

    @Override
    public MediaType detect(ZipFile zipFile, TikaInputStream tis) throws IOException {
        MediaType mt = IWorkDetector.detectIWork18(zipFile);
        if (mt != null) {
            return mt;
        }
        mt = IWorkDetector.detectIWork13(zipFile);
        if (mt != null) {
            return mt;
        }
        return IWorkDetector.detectIWork(zipFile);
    }

    @Override
    public MediaType streamingDetectUpdate(ZipArchiveEntry zae, InputStream zis, StreamingDetectContext detectContext) {
        IWorkPackageParser.IWORKDocumentType type;
        String name = zae.getName();
        EntryNames entryNames = detectContext.get(EntryNames.class);
        if (entryNames == null) {
            entryNames = new EntryNames();
            detectContext.set(EntryNames.class, entryNames);
        }
        entryNames.names.add(name);
        if (IWorkPackageParser.IWORK_CONTENT_ENTRIES.contains(name) && (type = IWorkPackageParser.IWORKDocumentType.detectType(zis)) != null) {
            return type.getType();
        }
        MediaType mt = IWork18PackageParser.IWork18DocumentType.detectIfPossible((ZipEntry)zae);
        if (mt != null) {
            return mt;
        }
        mt = IWork13PackageParser.IWork13DocumentType.detectIfPossible((ZipEntry)zae);
        if (mt != null) {
            return mt;
        }
        return null;
    }

    @Override
    public MediaType streamingDetectFinal(StreamingDetectContext detectContext) {
        EntryNames entryNames = detectContext.get(EntryNames.class);
        if (entryNames == null) {
            return null;
        }
        if (entryNames.names.contains("buildVersionHistory.plist")) {
            return MediaType.application((String)"vnd.apple.iwork");
        }
        return null;
    }

    private static class EntryNames {
        Set<String> names = new HashSet<String>();

        private EntryNames() {
        }
    }
}

