/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.LanguageIdentifier;
import org.apache.tika.language.LanguageProfile;
import org.apache.tika.language.translate.Translator;

public abstract class ExternalTranslator
implements Translator {
    public Reader runAndGetOutput(String command, String[] env, File workingDirectory) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(command, env, workingDirectory);
        InputStreamReader reader = new InputStreamReader(process.getInputStream(), Charset.defaultCharset());
        BufferedReader bufferedReader = new BufferedReader(reader);
        process.waitFor();
        return bufferedReader;
    }

    public boolean checkCommand(String checkCommandString, int ... successCodes) {
        try {
            Process process = Runtime.getRuntime().exec(checkCommandString);
            process.waitFor();
            int result = process.waitFor();
            for (int code : successCodes) {
                if (code != result) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            System.err.println("Broken pipe");
            return false;
        }
        catch (InterruptedException ie) {
            System.err.println("Interrupted");
            return false;
        }
    }

    @Override
    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        LanguageIdentifier language = new LanguageIdentifier(new LanguageProfile(text));
        String sourceLanguage = language.getLanguage();
        return this.translate(text, sourceLanguage, targetLanguage);
    }
}

