/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.language.LanguageIdentifier;
import org.apache.tika.language.LanguageProfile;
import org.apache.tika.language.translate.Translator;

public class Lingo24Translator
implements Translator {
    private static final String LINGO24_TRANSLATE_URL_BASE = "https://api.lingo24.com/mt/v1/translate";
    private static final String DEFAULT_KEY = "dummy-key";
    private WebClient client = WebClient.create((String)"https://api.lingo24.com/mt/v1/translate");
    private String userKey;
    private boolean isAvailable = true;

    public Lingo24Translator() {
        Properties config = new Properties();
        try {
            config.load(Lingo24Translator.class.getResourceAsStream("translator.lingo24.properties"));
            this.userKey = config.getProperty("translator.user-key");
            if (this.userKey.equals(DEFAULT_KEY)) {
                this.isAvailable = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isAvailable = false;
        }
    }

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) throws TikaException, IOException {
        if (!this.isAvailable) {
            return text;
        }
        Response response = this.client.accept(new String[]{"application/json"}).query("user_key", new Object[]{this.userKey}).query("source", new Object[]{sourceLanguage}).query("target", new Object[]{targetLanguage}).query("q", new Object[]{text}).get();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)response.getEntity(), IOUtils.UTF_8));
        String line = null;
        StringBuffer responseText = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            responseText.append(line);
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonResp = mapper.readTree(responseText.toString());
        if (jsonResp.findValuesAsText("errors").isEmpty()) {
            return (String)jsonResp.findValuesAsText("translation").get(0);
        }
        throw new TikaException(jsonResp.findValue("errors").get(0).asText());
    }

    @Override
    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        if (!this.isAvailable) {
            return text;
        }
        LanguageIdentifier language = new LanguageIdentifier(new LanguageProfile(text));
        String sourceLanguage = language.getLanguage();
        return this.translate(text, sourceLanguage, targetLanguage);
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }
}

