/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.loader.IO;
import org.apache.openejb.maven.plugin.AbstractDeployMojo;
import org.apache.openejb.maven.plugin.TomEEException;

@Mojo(name="deploy")
public class DeployMojo
extends AbstractDeployMojo {
    @Parameter
    protected Map<String, String> systemVariables = new HashMap<String, String>();
    @Parameter(property="tomee-plugin.binary", defaultValue="false")
    private boolean useBinaries;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Deployer deployer;
        block10: {
            byte[] archive;
            deployer = (Deployer)this.lookup("openejb/DeployerBusinessRemote");
            if (("localhost".equals(this.tomeeHost) || this.tomeeHost.startsWith("127.")) && !this.useBinaries) break block10;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.path);
                IO.copy((InputStream)fis, (OutputStream)baos);
                archive = baos.toByteArray();
            }
            catch (Exception e) {
                try {
                    throw new TomEEException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IO.close(fis);
                    IO.close((Closeable)baos);
                    throw throwable;
                }
            }
            IO.close((Closeable)fis);
            IO.close((Closeable)baos);
            try {
                Properties prop = new Properties();
                prop.putAll(this.systemVariables);
                prop.put("openejb.deployer.binaries.use", "true");
                prop.put("openejb.deployer.binaries.path", new File(this.path).getName());
                prop.put("openejb.deployer.binaries.value", archive);
                deployer.deploy(this.path, prop);
            }
            catch (OpenEJBException e) {
                throw new TomEEException(e.getMessage(), (Exception)((Object)e));
            }
        }
        try {
            if (this.systemVariables.isEmpty()) {
                deployer.deploy(this.path);
            } else {
                Properties prop = new Properties();
                prop.putAll(this.systemVariables);
                deployer.deploy(this.path, prop);
            }
        }
        catch (OpenEJBException e) {
            throw new TomEEException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

