/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin.customizer.monkey.jar;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.maven.plugin.customizer.monkey.index.Item;
import org.codehaus.plexus.util.FileUtils;

public class JarPatcher {
    public void patch(PrintStream stream, File tmp, File key, List<Item> value) {
        stream.println("  " + key);
        if (key.isDirectory()) {
            throw new IllegalArgumentException("Directory not yet supported - shouldn't occur");
        }
        if (!key.getName().endsWith(".jar")) {
            throw new IllegalArgumentException(key + " not a jar - shouldn't occur");
        }
        this.doJarPatch(stream, tmp, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJarPatch(PrintStream stream, File tmp, File jarFile, List<Item> items) {
        File exploded = new File(tmp, jarFile.getName() + ".exploded");
        try {
            int method;
            block16: {
                method = this.unjar(exploded, jarFile);
                for (Item item : items) {
                    switch (item.getAction()) {
                        case ADD_OR_UPDATE: {
                            this.replace(stream, jarFile.getName(), exploded, item.getPath(), item.getFile());
                            break;
                        }
                        case REMOVE: {
                            try {
                                FileUtils.forceDelete((File)new File(exploded, item.getPath()));
                                break;
                            }
                            catch (IOException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                    }
                }
                try {
                    FileUtils.forceDelete((File)jarFile);
                }
                catch (IOException e) {
                    if (jarFile.renameTo(new File(jarFile.getParentFile(), jarFile.getName() + "_patched"))) break block16;
                    throw new IllegalStateException(e);
                }
            }
            String name = jarFile.getName();
            this.jar(method, exploded, new File(jarFile.getParentFile(), this.jarName(name)));
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)exploded);
            }
            catch (IOException iOException) {}
        }
    }

    private String jarName(String name) {
        return name.substring(0, name.length() - ".jar".length()) + "tomee-monkey-" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".jar";
    }

    private void replace(PrintStream stream, String name, File exploded, String path, File file) {
        File existing = new File(exploded, path);
        if (!existing.isFile()) {
            stream.println("  - No " + path + " in " + name + ", creating it.");
            existing.getParentFile().mkdirs();
        } else {
            stream.println("  - Replacing " + path + " in " + name + " with " + file);
            existing.delete();
        }
        FileOutputStream os = null;
        FileInputStream is = null;
        try {
            os = new FileOutputStream(existing);
            is = new FileInputStream(file);
            IO.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IO.close(os);
                IO.close(is);
                throw throwable;
            }
        }
        IO.close((Closeable)os);
        IO.close((Closeable)is);
    }

    private int unjar(File exploded, File from) {
        int method = -1;
        JarArchiveInputStream stream = null;
        try {
            JarArchiveEntry entry;
            stream = new JarArchiveInputStream((InputStream)new FileInputStream(from));
            while ((entry = stream.getNextJarEntry()) != null) {
                File archiveEntry = new File(exploded, entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    continue;
                }
                FileOutputStream out = new FileOutputStream(archiveEntry);
                IOUtils.copy((InputStream)stream, (OutputStream)out);
                ((OutputStream)out).close();
                if (method >= 0) continue;
                method = entry.getMethod();
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                IO.close(stream);
                throw throwable;
            }
        }
        IO.close((Closeable)stream);
        return method;
    }

    private void jar(int method, File exploded, File target) {
        JarArchiveOutputStream stream = null;
        try {
            stream = new JarArchiveOutputStream((OutputStream)new FileOutputStream(target));
            String prefix = exploded.getCanonicalFile().getAbsolutePath() + File.separator;
            for (String f : exploded.list()) {
                this.jar(method, stream, new File(exploded, f).getCanonicalFile(), prefix);
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                IO.close(stream);
                throw throwable;
            }
        }
        IO.close((Closeable)stream);
    }

    private void jar(int method, JarArchiveOutputStream jar, File f, String prefix) throws IOException {
        String path = f.getPath().replace(prefix, "").replace(File.separator, "/");
        ZipArchiveEntry zip = new ZipArchiveEntry(f, path);
        zip.setMethod(method);
        JarArchiveEntry archiveEntry = new JarArchiveEntry(zip);
        jar.putArchiveEntry((ArchiveEntry)archiveEntry);
        if (f.isDirectory()) {
            jar.closeArchiveEntry();
            File[] files = f.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.jar(method, jar, child.getCanonicalFile(), prefix);
                }
            }
        } else {
            FileInputStream is = new FileInputStream(f);
            IOUtils.copy((InputStream)is, (OutputStream)jar);
            ((InputStream)is).close();
            jar.closeArchiveEntry();
        }
    }
}

