/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.tools.wsdl2java.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tuscany.tools.wsdl2java.generate.WSDL2JavaGenerator;
import org.apache.tuscany.tools.wsdl2java.plugin.WSDLFileOption;

public class WSDL2JavaGeneratorMojo
extends AbstractMojo {
    private String wsdlDir;
    private File wsdlFile;
    private String javaPackage;
    private String targetDirectory;
    private WSDLFileOption[] wsdlFiles;
    private List compilerSourceRoots;
    private static final FileFilter FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile() || !pathname.isHidden();
        }
    };

    public void execute() throws MojoExecutionException {
        if (null != this.wsdlFiles) {
            for (int i = 0; i < this.wsdlFiles.length; ++i) {
                System.err.println("wsdlFiles" + this.wsdlFiles[i].getFileName());
                WSDLFileOption wf = this.wsdlFiles[i];
                if (null == wf.getTargetDirectory()) {
                    wf.setTargetDirectory(this.targetDirectory);
                }
                if (null == wf.getJavaPackage()) {
                    wf.setJavaPackage(this.javaPackage);
                }
                if (wf.getFileName() == null || wf.getFileName().length() == 0L) {
                    throw new MojoExecutionException("no fileName specfied for wsdl.");
                }
                if (wf.getFileName().canRead() && wf.getFileName().isFile()) continue;
                throw new MojoExecutionException("file can not be read:" + wf.getFileName());
            }
        } else if (this.wsdlFile == null) {
            File[] files = new File(this.wsdlDir).listFiles(FILTER);
            this.wsdlFiles = new WSDLFileOption[files.length];
            for (int i = files.length - 1; i > -1; --i) {
                this.wsdlFiles[i] = new WSDLFileOption();
                this.wsdlFiles[i].setFileName(files[i]);
                this.wsdlFiles[i].setJavaPackage(this.javaPackage);
                this.wsdlFiles[i].setPorts(null);
                this.wsdlFiles[i].setTargetDirectory(this.targetDirectory);
            }
        } else {
            this.wsdlFiles = new WSDLFileOption[]{new WSDLFileOption()};
            this.wsdlFiles[0].setFileName(this.wsdlFile);
            this.wsdlFiles[0].setJavaPackage(this.javaPackage);
            this.wsdlFiles[0].setPorts(null);
            this.wsdlFiles[0].setTargetDirectory(this.targetDirectory);
        }
        int genOptions = 0;
        for (int i = 0; i < this.wsdlFiles.length; ++i) {
            File file = this.wsdlFiles[i].getFileName();
            File marker = new File(this.targetDirectory, ".gen#" + file.getName() + ".wsdl2java");
            if (file.lastModified() > marker.lastModified()) {
                this.getLog().info((CharSequence)("Generating Java service interfaces from " + file));
                WSDL2JavaGenerator.generateFromWSDL((String)file.toString(), (String[])this.wsdlFiles[i].getPorts(), (String)this.wsdlFiles[i].getTargetDirectory(), (String)this.wsdlFiles[i].getJavaPackage(), null, (int)genOptions);
            }
            try {
                marker.createNewFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            marker.setLastModified(System.currentTimeMillis());
        }
        this.compilerSourceRoots.add(this.targetDirectory);
    }
}

