/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.aspectj;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public abstract class TracingAspect {
    @Pointcut(value="")
    protected abstract void entry();

    @Pointcut(value="")
    protected abstract void withinScope();

    @Pointcut(value="call(* java..*.*(..))")
    protected void exit() {
    }

    @Pointcut(value="entry() && !cflowbelow(entry())")
    void start() {
    }

    @Pointcut(value="withinScope() && entry()")
    void trace() {
    }

    @Pointcut(value="!handler(*) && !preinitialization(new(..))")
    protected void supportsAfterAdvice() {
    }

    @Before(value="start()")
    public void beforeStart() {
        this.startLog();
    }

    @Before(value="trace() && supportsAfterAdvice()")
    public void beforeTrace(JoinPoint jp) {
        this.logEnter(jp);
    }

    @AfterReturning(pointcut="trace() && supportsAfterAdvice()", returning="result")
    public void afterReturning(JoinPoint jp, Object result) {
        this.logExit(jp, result);
    }

    @AfterThrowing(pointcut="trace() && supportsAfterAdvice()", throwing="e")
    public void afterThrowing(JoinPoint jp, Throwable e) {
        this.logThrowable(jp, e);
    }

    @After(value="start()")
    public void afterStart() {
        this.completeLog();
    }

    protected abstract void logEnter(JoinPoint var1);

    protected abstract void logExit(JoinPoint var1, Object var2);

    protected abstract void logThrowable(JoinPoint var1, Throwable var2);

    protected abstract void startLog();

    protected abstract void completeLog();
}

