/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCloneBuilderImpl
implements CompositeBuilder {
    public CompositeCloneBuilderImpl(Monitor monitor) {
    }

    @Override
    public void build(Composite composite) throws CompositeBuilderException {
        this.expandCompositeImplementations(composite);
    }

    private void expandCompositeImplementations(Composite composite) {
        for (Component component : composite.getComponents()) {
            Composite clone;
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            Composite compositeImplementation = (Composite)implementation;
            try {
                clone = (Composite)compositeImplementation.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            component.setImplementation(clone);
            this.expandCompositeImplementations(clone);
        }
    }

    private void collectNestedComposites(Composite composite, List<Composite> nested) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            Composite nestedComposite = (Composite)implementation;
            nested.add(nestedComposite);
            this.collectNestedComposites(nestedComposite, nested);
        }
    }

    private void fuseCompositeImplementations(Composite composite) {
        ArrayList<Composite> nested = new ArrayList<Composite>();
        this.collectNestedComposites(composite, nested);
        for (Composite nestedComposite : nested) {
            for (Component component : nestedComposite.getComponents()) {
                Implementation implementation = component.getImplementation();
                if (implementation instanceof Composite) continue;
                composite.getComponents().add(component);
            }
        }
        Iterator<Component> i = composite.getComponents().iterator();
        while (i.hasNext()) {
            Component component = i.next();
            if (!(component.getImplementation() instanceof Composite)) continue;
            i.remove();
        }
    }
}

