/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.impl.AbstractServiceImpl;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.policy.PolicySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl
extends AbstractServiceImpl
implements Service,
Cloneable {
    private List<Binding> bindings = new ArrayList<Binding>();
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private Callback callback;
    private List<PolicySet> applicablePolicySets = new ArrayList<PolicySet>();

    @Override
    public List<PolicySet> getApplicablePolicySets() {
        return this.applicablePolicySets;
    }

    protected ServiceImpl() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ServiceImpl clone = (ServiceImpl)super.clone();
        clone.bindings = new ArrayList<Binding>();
        clone.bindings.addAll(this.getBindings());
        return clone;
    }

    @Override
    public List<Binding> getBindings() {
        return this.bindings;
    }

    @Override
    public <B> B getBinding(Class<B> bindingClass) {
        for (Binding binding : this.bindings) {
            if (!bindingClass.isInstance(binding)) continue;
            return bindingClass.cast(binding);
        }
        return null;
    }

    @Override
    public <B> B getCallbackBinding(Class<B> bindingClass) {
        if (this.callback != null) {
            for (Binding binding : this.callback.getBindings()) {
                if (!bindingClass.isInstance(binding)) continue;
                return bindingClass.cast(binding);
            }
        }
        return null;
    }

    @Override
    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    @Override
    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public void setPolicySets(List<PolicySet> policySets) {
        this.policySets = policySets;
    }

    @Override
    public InterfaceContract getInterfaceContract(Binding binding) {
        return this.getInterfaceContract();
    }
}

