/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.util.PolicyComputationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDocumentProcessor
extends BaseAssemblyProcessor
implements URLArtifactProcessor<Composite> {
    private XMLInputFactory inputFactory;
    private DocumentBuilderFactory documentBuilderFactory;
    private List scaDefnSink;
    private Collection<PolicySet> domainPolicySets = null;
    private int scaDefnsCount = 0;

    @Deprecated
    public CompositeDocumentProcessor(StAXArtifactProcessor staxProcessor, XMLInputFactory inputFactory, List scaDefnsSink, Monitor monitor) {
        super(null, null, null, staxProcessor, null, monitor);
        this.inputFactory = inputFactory;
        this.scaDefnSink = scaDefnsSink;
    }

    public CompositeDocumentProcessor(StAXArtifactProcessor staxProcessor, XMLInputFactory inputFactory, DocumentBuilderFactory documentBuilderFactory, List scaDefnsSink, Monitor monitor) {
        super(null, null, null, staxProcessor, null, monitor);
        this.documentBuilderFactory = documentBuilderFactory;
        this.inputFactory = inputFactory;
        this.scaDefnSink = scaDefnsSink;
    }

    public CompositeDocumentProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor staxProcessor, Monitor monitor) {
        super(null, null, null, staxProcessor, null, monitor);
        this.inputFactory = modelFactories.getFactory(ValidatingXMLInputFactory.class);
        this.documentBuilderFactory = modelFactories.getFactory(DocumentBuilderFactory.class);
    }

    @Override
    public Composite read(URL contributionURL, URI uri, URL url) throws ContributionReadException {
        InputStream scdlStream = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            try {
                scdlStream = connection.getInputStream();
            }
            catch (IOException e) {
                if (e.getClass() == IOException.class && connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 500) {
                    this.error("HttpServerError", (Object)url, ((HttpURLConnection)connection).getResponseMessage());
                }
                throw e;
            }
        }
        catch (IOException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error("ContributionReadException", (Object)url, e);
            throw ce;
        }
        return this.read(uri, scdlStream);
    }

    public Composite read(URI uri, InputStream scdlStream) throws ContributionReadException {
        try {
            if (this.scaDefnSink != null) {
                this.fillDomainPolicySets(this.scaDefnSink);
            }
            Composite composite = null;
            try {
                if (this.domainPolicySets != null) {
                    byte[] transformedArtifactContent = PolicyComputationUtils.addApplicablePolicySets(scdlStream, this.domainPolicySets, this.documentBuilderFactory);
                    scdlStream = new ByteArrayInputStream(transformedArtifactContent);
                }
            }
            catch (IOException e) {
                ContributionReadException ce = new ContributionReadException(e);
                this.error("ContributionReadException", (Object)scdlStream, e);
                throw ce;
            }
            catch (Exception e) {
                ContributionReadException ce = new ContributionReadException(e);
                this.error("ContributionReadException", (Object)scdlStream, e);
            }
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(scdlStream);
            reader.nextTag();
            composite = (Composite)this.extensionProcessor.read(reader);
            if (composite != null) {
                composite.setURI(uri.toString());
            }
            Composite composite2 = composite;
            return composite2;
        }
        catch (XMLStreamException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error("ContributionReadException", (Object)this.inputFactory, e);
            throw ce;
        }
        finally {
            try {
                if (scdlStream != null) {
                    scdlStream.close();
                    scdlStream = null;
                }
            }
            catch (IOException ioe) {}
        }
    }

    @Override
    public void resolve(Composite composite, ModelResolver resolver) throws ContributionResolveException {
        if (composite != null) {
            this.extensionProcessor.resolve(composite, resolver);
        }
    }

    @Override
    public String getArtifactType() {
        return ".composite";
    }

    @Override
    public Class<Composite> getModelType() {
        return Composite.class;
    }

    private void fillDomainPolicySets(List scaDefnsSink) {
        Hashtable<QName, PolicySet> domainPolicySetMap = null;
        if (scaDefnsSink.size() > this.scaDefnsCount) {
            domainPolicySetMap = new Hashtable<QName, PolicySet>();
            if (this.domainPolicySets != null) {
                for (PolicySet policySet : this.domainPolicySets) {
                    domainPolicySetMap.put(policySet.getName(), policySet);
                }
            }
            for (Object object : scaDefnsSink) {
                if (!(object instanceof SCADefinitions)) continue;
                for (PolicySet policySet : ((SCADefinitions)object).getPolicySets()) {
                    domainPolicySetMap.put(policySet.getName(), policySet);
                }
            }
            this.domainPolicySets = domainPolicySetMap.values();
            this.scaDefnsCount = scaDefnsSink.size();
        }
    }
}

