/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredOperationProcessor
implements StAXArtifactProcessor<ConfiguredOperation>,
Constants {
    private AssemblyFactory assemblyFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private PolicyFactory policyFactory;
    private Monitor monitor;

    public ConfiguredOperationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.monitor = monitor;
    }

    @Override
    public ConfiguredOperation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        ConfiguredOperation configuredOp = this.assemblyFactory.createConfiguredOperation();
        configuredOp.setName(reader.getAttributeValue(null, "name"));
        configuredOp.setContractName(reader.getAttributeValue(null, "service"));
        configuredOp.setUnresolved(true);
        this.policyProcessor.readPolicies(configuredOp, reader);
        while (reader.hasNext() && (reader.next() != 2 || !OPERATION_QNAME.equals(reader.getName()))) {
        }
        return configuredOp;
    }

    @Override
    public void write(ConfiguredOperation configuredOperation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "operation");
        this.policyProcessor.writePolicyAttributes(configuredOperation, writer);
        writer.writeAttribute("name", configuredOperation.getName());
        if (configuredOperation.getContractName() != null) {
            writer.writeAttribute("service", configuredOperation.getContractName());
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(ConfiguredOperation configuredOperation, ModelResolver resolver) throws ContributionResolveException {
    }

    @Override
    public QName getArtifactType() {
        return OPERATION_QNAME;
    }

    @Override
    public Class<ConfiguredOperation> getModelType() {
        return ConfiguredOperation.class;
    }
}

