/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.atom.provider;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.Parser;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.tuscany.sca.binding.atom.collection.NotFoundException;
import org.apache.tuscany.sca.binding.atom.provider.AtomBindingUtil;
import org.apache.tuscany.sca.binding.atom.provider.AtomReferenceBindingProvider;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.osoa.sca.ServiceRuntimeException;

class AtomBindingInvoker
implements Invoker,
DataExchangeSemantics {
    private static final Factory abderaFactory = Abdera.getNewFactory();
    private static final Parser abderaParser = Abdera.getNewParser();
    Operation operation;
    String uri;
    HttpClient httpClient;
    String authorizationHeader;
    AtomReferenceBindingProvider provider;

    AtomBindingInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
        this.operation = operation;
        this.uri = uri;
        this.httpClient = httpClient;
        this.authorizationHeader = authorizationHeader;
        this.provider = bindingProvider;
    }

    public Message invoke(Message msg) {
        throw new UnsupportedOperationException(this.operation.getName());
    }

    public boolean allowsPassByReference() {
        return true;
    }

    public static class PutMediaInvoker
    extends AtomBindingInvoker {
        public PutMediaInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        public Message invoke(Message msg) {
            return super.invoke(msg);
        }
    }

    public static class PostMediaInvoker
    extends AtomBindingInvoker {
        public PostMediaInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        public Message invoke(Message msg) {
            return super.invoke(msg);
        }
    }

    public static class QueryInvoker
    extends AtomBindingInvoker {
        public QueryInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            String queryString = (String)((Object[])msg.getBody())[0];
            GetMethod getMethod = new GetMethod(this.uri);
            if (this.authorizationHeader != null) {
                getMethod.setRequestHeader("Authorization", this.authorizationHeader);
            }
            getMethod.setQueryString(queryString);
            boolean parsing = false;
            try {
                this.httpClient.executeMethod((HttpMethod)getMethod);
                int status = getMethod.getStatusCode();
                if (status == 200) {
                    Document doc = abderaParser.parse(getMethod.getResponseBodyAsStream());
                    parsing = true;
                    Feed feed = (Feed)doc.getRoot();
                    if (this.provider.supportsFeedEntries()) {
                        msg.setBody(feed);
                    } else {
                        ArrayList<Entry<Object, Object>> entries = new ArrayList<Entry<Object, Object>>();
                        for (org.apache.abdera.model.Entry feedEntry : feed.getEntries()) {
                            Entry<Object, Object> entry = AtomBindingUtil.entry(feedEntry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator());
                            entries.add(entry);
                        }
                        msg.setBody(entries.toArray(new Entry[entries.size()]));
                    }
                } else if (status == 404) {
                    if (this.provider.supportsFeedEntries()) {
                        msg.setFaultBody(new NotFoundException());
                    } else {
                        msg.setFaultBody(new org.apache.tuscany.sca.data.collection.NotFoundException());
                    }
                } else {
                    msg.setFaultBody(new ServiceRuntimeException("HTTP status code: " + status));
                }
            }
            catch (Exception e) {
                msg.setFaultBody(new ServiceRuntimeException(e));
            }
            finally {
                if (!parsing) {
                    getMethod.releaseConnection();
                }
            }
            return msg;
        }
    }

    public static class GetAllInvoker
    extends AtomBindingInvoker {
        public GetAllInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            block17: {
                GetMethod getMethod = new GetMethod(this.uri);
                if (this.authorizationHeader != null) {
                    getMethod.setRequestHeader("Authorization", this.authorizationHeader);
                }
                boolean parsing = false;
                try {
                    this.httpClient.executeMethod((HttpMethod)getMethod);
                    int status = getMethod.getStatusCode();
                    if (status == 200) {
                        Document doc = abderaParser.parse(getMethod.getResponseBodyAsStream());
                        parsing = true;
                        Feed feed = null;
                        try {
                            feed = (Feed)doc.getRoot();
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Invalid feed format :" + this.uri);
                        }
                        if (this.provider.supportsFeedEntries()) {
                            msg.setBody(feed);
                        } else {
                            ArrayList<Entry<Object, Object>> entries = new ArrayList<Entry<Object, Object>>();
                            for (org.apache.abdera.model.Entry feedEntry : feed.getEntries()) {
                                Entry<Object, Object> entry = AtomBindingUtil.entry(feedEntry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator());
                                entries.add(entry);
                            }
                            msg.setBody(entries.toArray(new Entry[entries.size()]));
                        }
                        break block17;
                    }
                    if (status == 404) {
                        if (this.provider.supportsFeedEntries()) {
                            msg.setFaultBody(new NotFoundException());
                        } else {
                            msg.setFaultBody(new org.apache.tuscany.sca.data.collection.NotFoundException());
                        }
                    } else {
                        msg.setFaultBody(new ServiceRuntimeException("HTTP status code: " + status));
                    }
                }
                catch (Exception e) {
                    msg.setFaultBody(new ServiceRuntimeException(e));
                }
                finally {
                    if (!parsing) {
                        getMethod.releaseConnection();
                    }
                }
            }
            return msg;
        }
    }

    public static class DeleteInvoker
    extends AtomBindingInvoker {
        public DeleteInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            String id = (String)((Object[])msg.getBody())[0];
            DeleteMethod deleteMethod = new DeleteMethod(this.uri + "/" + id);
            if (this.authorizationHeader != null) {
                deleteMethod.setRequestHeader("Authorization", this.authorizationHeader);
            }
            try {
                this.httpClient.executeMethod((HttpMethod)deleteMethod);
                int status = deleteMethod.getStatusCode();
                if (status == 200) {
                    msg.setBody(null);
                } else if (status == 404) {
                    if (this.provider.supportsFeedEntries()) {
                        msg.setFaultBody(new NotFoundException());
                    } else {
                        msg.setFaultBody(new org.apache.tuscany.sca.data.collection.NotFoundException());
                    }
                } else {
                    msg.setFaultBody(new ServiceRuntimeException("HTTP status code: " + status));
                }
            }
            catch (Exception e) {
                msg.setFaultBody(new ServiceRuntimeException(e));
            }
            finally {
                deleteMethod.releaseConnection();
            }
            return msg;
        }
    }

    public static class PutInvoker
    extends AtomBindingInvoker {
        public PutInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            org.apache.abdera.model.Entry feedEntry;
            String id;
            Object[] args = (Object[])msg.getBody();
            if (this.provider.supportsFeedEntries()) {
                id = (String)args[0];
                feedEntry = (org.apache.abdera.model.Entry)args[1];
            } else {
                id = (String)args[0];
                Entry<Object, Object> entry = new Entry<Object, Object>(id, args[1]);
                feedEntry = AtomBindingUtil.feedEntry(entry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator(), abderaFactory);
            }
            PutMethod putMethod = new PutMethod(this.uri + "/" + id);
            if (this.authorizationHeader != null) {
                putMethod.setRequestHeader("Authorization", this.authorizationHeader);
            }
            try {
                StringWriter writer = new StringWriter();
                feedEntry.writeTo((Writer)writer);
                putMethod.setRequestHeader("Content-type", "application/atom+xml; charset=utf-8");
                putMethod.setRequestEntity((RequestEntity)new StringRequestEntity(writer.toString()));
                this.httpClient.executeMethod((HttpMethod)putMethod);
                int status = putMethod.getStatusCode();
                if (status == 200 || status == 201 || status == 412) {
                    msg.setBody(null);
                } else if (status == 404) {
                    if (this.provider.supportsFeedEntries()) {
                        msg.setFaultBody(new NotFoundException());
                    } else {
                        msg.setFaultBody(new org.apache.tuscany.sca.data.collection.NotFoundException());
                    }
                } else {
                    msg.setFaultBody(new ServiceRuntimeException("HTTP status code: " + status));
                }
            }
            catch (Exception e) {
                msg.setFaultBody(new ServiceRuntimeException(e));
            }
            finally {
                putMethod.releaseConnection();
            }
            return msg;
        }
    }

    public static class PostInvoker
    extends AtomBindingInvoker {
        public PostInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            org.apache.abdera.model.Entry feedEntry;
            Object[] args = (Object[])msg.getBody();
            if (this.provider.supportsFeedEntries()) {
                feedEntry = (org.apache.abdera.model.Entry)args[0];
            } else {
                Entry<Object, Object> entry = new Entry<Object, Object>(args[0], args[1]);
                feedEntry = AtomBindingUtil.feedEntry(entry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator(), abderaFactory);
            }
            PostMethod postMethod = new PostMethod(this.uri);
            if (this.authorizationHeader != null) {
                postMethod.setRequestHeader("Authorization", this.authorizationHeader);
            }
            boolean parsing = false;
            try {
                StringWriter writer = new StringWriter();
                feedEntry.writeTo((Writer)writer);
                postMethod.setRequestHeader("Content-type", "application/atom+xml;type=entry");
                postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(writer.toString()));
                this.httpClient.executeMethod((HttpMethod)postMethod);
                int status = postMethod.getStatusCode();
                if (status == 200 || status == 201) {
                    Document doc = abderaParser.parse(postMethod.getResponseBodyAsStream());
                    parsing = true;
                    org.apache.abdera.model.Entry createdEntry = (org.apache.abdera.model.Entry)doc.getRoot();
                    if (this.provider.supportsFeedEntries()) {
                        msg.setBody(createdEntry);
                    } else {
                        msg.setBody(createdEntry.getId().toString());
                    }
                } else if (status == 404) {
                    if (this.provider.supportsFeedEntries()) {
                        msg.setFaultBody(new NotFoundException());
                    } else {
                        msg.setFaultBody(new org.apache.tuscany.sca.data.collection.NotFoundException());
                    }
                } else {
                    msg.setFaultBody(new ServiceRuntimeException("HTTP status code: " + status));
                }
            }
            catch (Exception e) {
                msg.setFaultBody(new ServiceRuntimeException(e));
            }
            finally {
                if (!parsing) {
                    postMethod.releaseConnection();
                }
            }
            return msg;
        }
    }

    public static class GetInvoker
    extends AtomBindingInvoker {
        public GetInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            String id = (String)((Object[])msg.getBody())[0];
            GetMethod getMethod = new GetMethod(this.uri + "/" + id);
            if (this.authorizationHeader != null) {
                getMethod.setRequestHeader("Authorization", this.authorizationHeader);
            }
            boolean parsing = false;
            try {
                this.httpClient.executeMethod((HttpMethod)getMethod);
                int status = getMethod.getStatusCode();
                if (status == 200) {
                    Document doc = abderaParser.parse(getMethod.getResponseBodyAsStream());
                    parsing = true;
                    org.apache.abdera.model.Entry feedEntry = (org.apache.abdera.model.Entry)doc.getRoot();
                    if (this.provider.supportsFeedEntries()) {
                        msg.setBody(feedEntry);
                    } else {
                        Entry<Object, Object> entry = AtomBindingUtil.entry(feedEntry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator());
                        msg.setBody(entry.getData());
                    }
                } else if (status == 404) {
                    if (this.provider.supportsFeedEntries()) {
                        msg.setFaultBody(new NotFoundException());
                    } else {
                        msg.setFaultBody(new org.apache.tuscany.sca.data.collection.NotFoundException());
                    }
                } else {
                    msg.setFaultBody(new ServiceRuntimeException("HTTP status code: " + status));
                }
            }
            catch (Exception e) {
                msg.setFaultBody(new ServiceRuntimeException(e));
            }
            finally {
                if (!parsing) {
                    getMethod.releaseConnection();
                }
            }
            return msg;
        }
    }
}

