/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.atom.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Service;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.writer.WriterFactory;
import org.apache.tuscany.sca.binding.atom.provider.AtomBindingUtil;
import org.apache.tuscany.sca.binding.http.HTTPCacheContext;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeWire;

class AtomBindingListenerServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(AtomBindingListenerServlet.class.getName());
    private static final long serialVersionUID = 1L;
    private static final Factory abderaFactory = Abdera.getNewFactory();
    private static final Parser abderaParser = Abdera.getNewParser();
    private static final String ETAG = "ETag";
    private static final String LASTMODIFIED = "Last-Modified";
    private static final String LOCATION = "Location";
    private static final String CONTENTLOCATION = "Content-Location";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
    private RuntimeWire wire;
    private Invoker getFeedInvoker;
    private Invoker getAllInvoker;
    private Invoker queryInvoker;
    private Invoker getInvoker;
    private Invoker postInvoker;
    private Invoker postMediaInvoker;
    private Invoker putInvoker;
    private Invoker putMediaInvoker;
    private Invoker deleteInvoker;
    private MessageFactory messageFactory;
    private String title;
    private String description;
    private Mediator mediator;
    private DataType<?> itemClassType;
    private DataType<?> itemXMLType;
    private boolean supportsFeedEntries;

    AtomBindingListenerServlet(RuntimeWire wire, MessageFactory messageFactory, Mediator mediator, String title, String description) {
        this.wire = wire;
        this.messageFactory = messageFactory;
        this.mediator = mediator;
        this.title = title;
        this.description = description;
        Operation getOperation = null;
        for (InvocationChain invocationChain : this.wire.getInvocationChains()) {
            invocationChain.setAllowsPassByReference(true);
            Operation operation = invocationChain.getTargetOperation();
            String operationName = operation.getName();
            if (operationName.equals("getFeed")) {
                this.getFeedInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("getAll")) {
                this.getAllInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("query")) {
                this.queryInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("get")) {
                this.getInvoker = invocationChain.getHeadInvoker();
                getOperation = operation;
                continue;
            }
            if (operationName.equals("put")) {
                this.putInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("putMedia")) {
                this.putMediaInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("post")) {
                this.postInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("postMedia")) {
                this.postMediaInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (!operationName.equals("delete")) continue;
            this.deleteInvoker = invocationChain.getHeadInvoker();
        }
        if (getOperation != null) {
            this.itemXMLType = new DataTypeImpl<Class<String>>(String.class.getName(), String.class, String.class);
            Class<?> itemClass = getOperation.getOutputType().getPhysical();
            if (itemClass == Entry.class) {
                this.supportsFeedEntries = true;
            }
            this.itemClassType = getOperation.getOutputType();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HTTPCacheContext cacheContext = null;
        try {
            cacheContext = HTTPCacheContext.getCacheContextFromRequest(request);
        }
        catch (java.text.ParseException e) {
            // empty catch block
        }
        String path = URLDecoder.decode(AtomBindingListenerServlet.getRequestPath(request), "UTF-8");
        logger.fine("get " + request.getRequestURI());
        if (path != null && path.equals("/atomsvc")) {
            response.setContentType("application/atomsvc+xml; charset=utf-8");
            String href = request.getRequestURL().toString();
            href = href.substring(0, href.length() - "/atomsvc".length());
            String workspaceURL = new String(href);
            int pathIndex = workspaceURL.indexOf(request.getServletPath());
            if (-1 != pathIndex) {
                workspaceURL = workspaceURL.substring(0, pathIndex) + "/";
            }
            Service service = abderaFactory.newService();
            Workspace workspace = abderaFactory.newWorkspace();
            if (this.title != null) {
                workspace.setTitle(this.title);
            } else {
                workspace.setTitle("workspace");
            }
            workspace.setBaseUri(new IRI(workspaceURL));
            Collection collection = workspace.addCollection("collection", href);
            Feed feed = this.getFeed(request);
            if (feed != null) {
                String title = feed.getTitle();
                if (title != null) {
                    collection.setTitle(title);
                } else {
                    collection.setTitle("entries");
                }
                collection.addAccepts("application/atom+xml;type=feed");
                collection.addAccepts("application/json;type=feed");
                collection.addAccepts("application/atom+xml;type=entry");
                collection.addAccepts("application/json;type=entry");
                List categories = feed.getCategories();
                if (categories != null) {
                    collection.addCategories(categories, false, null);
                } else {
                    collection.addCategories().setFixed(false);
                }
            } else {
                collection.setTitle("entries");
                collection.addAccepts("application/atom+xml; type=entry");
                collection.addAccepts("application/json;type=entry");
                collection.addCategories().setFixed(false);
            }
            workspace.addCollection(collection);
            service.addWorkspace(workspace);
            try {
                service.getDocument().writeTo((OutputStream)response.getOutputStream());
            }
            catch (IOException ioe) {
                throw new ServletException((Throwable)ioe);
            }
        }
        if (path == null || path.length() == 0 || path.equals("/")) {
            Feed feed = this.getFeed(request);
            if (feed != null) {
                String acceptType;
                String preferredType;
                String feedETag = null;
                if (feed.getId() != null) {
                    feedETag = "\"" + feed.getId().toString() + "\"";
                }
                Date feedUpdated = feed.getUpdated();
                String predicate = request.getHeader("If-Match");
                if (predicate != null && !predicate.equals(feedETag)) {
                    response.sendError(412);
                    return;
                }
                predicate = request.getHeader("If-None-Match");
                if (predicate != null && predicate.equals(feedETag)) {
                    response.sendError(304);
                    return;
                }
                if (feedUpdated != null) {
                    Date predicateDate;
                    predicate = request.getHeader("If-Unmodified-Since");
                    if (predicate != null) {
                        try {
                            predicateDate = dateFormat.parse(predicate);
                            if (predicateDate.compareTo(this.exactSeconds(feedUpdated)) < 0) {
                                response.sendError(412);
                                return;
                            }
                        }
                        catch (java.text.ParseException e) {
                            // empty catch block
                        }
                    }
                    if ((predicate = request.getHeader("If-Modified-Since")) != null) {
                        try {
                            predicateDate = dateFormat.parse(predicate);
                            if (predicateDate.compareTo(this.exactSeconds(feedUpdated)) >= 0) {
                                response.sendError(304);
                                return;
                            }
                        }
                        catch (java.text.ParseException e) {
                            // empty catch block
                        }
                    }
                }
                if (feedETag != null) {
                    response.addHeader(ETAG, feedETag);
                }
                if (feedUpdated != null) {
                    response.addHeader(LASTMODIFIED, dateFormat.format(feedUpdated));
                }
                if ((preferredType = AtomBindingListenerServlet.getContentPreference(acceptType = request.getHeader("Accept"))) != null && (preferredType.indexOf("json") > -1 || preferredType.indexOf("JSON") > -1)) {
                    response.setContentType("application/json;type=feed");
                    try {
                        Abdera abdera = new Abdera();
                        WriterFactory wf = abdera.getWriterFactory();
                        org.apache.abdera.writer.Writer json = wf.getWriter("json");
                        feed.writeTo(json, (Writer)response.getWriter());
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                } else {
                    response.setContentType("application/atom+xml;type=feed");
                    try {
                        feed.getDocument().writeTo((OutputStream)response.getOutputStream());
                    }
                    catch (IOException ioe) {
                        throw new ServletException((Throwable)ioe);
                    }
                }
            } else {
                response.sendError(404);
            }
        } else if (path.startsWith("/")) {
            Entry feedEntry;
            Message requestMessage = this.messageFactory.createMessage();
            String id = path.substring(1);
            requestMessage.setBody(new Object[]{id});
            Message responseMessage = this.getInvoker.invoke(requestMessage);
            if (responseMessage.isFault()) {
                Object body = responseMessage.getBody();
                if (body.getClass().getName().endsWith(".NotFoundException")) {
                    response.sendError(404);
                    return;
                }
                throw new ServletException((Throwable)responseMessage.getBody());
            }
            if (this.supportsFeedEntries) {
                feedEntry = (Entry)responseMessage.getBody();
            } else {
                org.apache.tuscany.sca.data.collection.Entry<Object, Object> entry = new org.apache.tuscany.sca.data.collection.Entry<Object, Object>(id, responseMessage.getBody());
                feedEntry = AtomBindingUtil.feedEntry(entry, this.itemClassType, this.itemXMLType, this.mediator, abderaFactory);
            }
            if (feedEntry != null) {
                String acceptType;
                String preferredType;
                Link link;
                Date entryUpdated;
                String entryETag = null;
                if (feedEntry.getId() != null) {
                    entryETag = feedEntry.getId().toString();
                }
                if ((entryUpdated = feedEntry.getUpdated()) != null) {
                    response.addHeader(LASTMODIFIED, dateFormat.format(entryUpdated));
                }
                if ((link = feedEntry.getSelfLink()) != null) {
                    response.addHeader(LOCATION, link.getHref().toString());
                } else {
                    link = feedEntry.getLink("Edit");
                    if (link != null) {
                        response.addHeader(LOCATION, link.getHref().toString());
                    }
                }
                String predicate = request.getHeader("If-Match");
                if (predicate != null && !predicate.equals(entryETag)) {
                    response.sendError(412);
                    return;
                }
                predicate = request.getHeader("If-None-Match");
                if (predicate != null && predicate.equals(entryETag)) {
                    response.sendError(304);
                    return;
                }
                if (entryUpdated != null) {
                    Date predicateDate;
                    predicate = request.getHeader("If-Unmodified-Since");
                    if (predicate != null) {
                        try {
                            predicateDate = dateFormat.parse(predicate);
                            if (predicateDate.compareTo(entryUpdated) < 0) {
                                response.sendError(304);
                                return;
                            }
                        }
                        catch (java.text.ParseException e) {
                            // empty catch block
                        }
                    }
                    if ((predicate = request.getHeader("If-Modified-Since")) != null) {
                        try {
                            predicateDate = dateFormat.parse(predicate);
                            if (predicateDate.compareTo(entryUpdated) > 0) {
                                response.sendError(304);
                                return;
                            }
                        }
                        catch (java.text.ParseException e) {
                            // empty catch block
                        }
                    }
                }
                if (entryETag != null) {
                    response.addHeader(ETAG, entryETag);
                }
                if (entryUpdated != null) {
                    response.addHeader(LASTMODIFIED, dateFormat.format(entryUpdated));
                }
                if ((preferredType = AtomBindingListenerServlet.getContentPreference(acceptType = request.getHeader("Accept"))) != null && (preferredType.indexOf("json") > -1 || preferredType.indexOf("JSON") > -1)) {
                    response.setContentType("application/json;type=entry");
                    try {
                        Abdera abdera = new Abdera();
                        WriterFactory wf = abdera.getWriterFactory();
                        org.apache.abdera.writer.Writer json = wf.getWriter("json");
                        feedEntry.writeTo(json, (Writer)response.getWriter());
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                } else {
                    response.setContentType("application/atom+xml;type=entry");
                    try {
                        feedEntry.writeTo(this.getWriter(response));
                    }
                    catch (IOException ioe) {
                        throw new ServletException((Throwable)ioe);
                    }
                }
            } else {
                response.sendError(404);
            }
        } else {
            response.sendError(404);
        }
    }

    protected Feed getFeed(HttpServletRequest request) throws ServletException {
        Message responseMessage;
        if (this.supportsFeedEntries) {
            Message responseMessage2;
            Message requestMessage = this.messageFactory.createMessage();
            if (request.getQueryString() != null) {
                requestMessage.setBody(new Object[]{request.getQueryString()});
                responseMessage2 = this.queryInvoker.invoke(requestMessage);
            } else {
                responseMessage2 = this.getFeedInvoker.invoke(requestMessage);
            }
            if (responseMessage2.isFault()) {
                throw new ServletException((Throwable)responseMessage2.getBody());
            }
            return (Feed)responseMessage2.getBody();
        }
        Message requestMessage = this.messageFactory.createMessage();
        if (request.getQueryString() != null) {
            requestMessage.setBody(new Object[]{request.getQueryString()});
            responseMessage = this.queryInvoker.invoke(requestMessage);
        } else {
            responseMessage = this.getAllInvoker.invoke(requestMessage);
        }
        if (responseMessage.isFault()) {
            throw new ServletException((Throwable)responseMessage.getBody());
        }
        org.apache.tuscany.sca.data.collection.Entry[] collection = (org.apache.tuscany.sca.data.collection.Entry[])responseMessage.getBody();
        if (collection != null) {
            Feed feed = abderaFactory.newFeed();
            if (this.title != null) {
                feed.setTitle(this.title);
            } else {
                feed.setTitle("Feed");
            }
            if (this.description != null) {
                feed.setSubtitle(this.description);
            }
            feed.setId("Feed" + feed.hashCode());
            Date responseLastModified = new Date(0L);
            for (org.apache.tuscany.sca.data.collection.Entry entry : collection) {
                Entry feedEntry = AtomBindingUtil.feedEntry(entry, this.itemClassType, this.itemXMLType, this.mediator, abderaFactory);
                Date entryUpdated = feedEntry.getUpdated();
                if (entryUpdated != null && entryUpdated.compareTo(responseLastModified) > 0) {
                    responseLastModified = entryUpdated;
                }
                feed.addEntry(feedEntry);
            }
            if (responseLastModified.compareTo(new Date(0L)) == 0) {
                responseLastModified = new Date();
            }
            return feed;
        }
        return null;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user = this.processAuthorizationHeader(request);
        if (user == null) {
            this.unauthorized(response);
            return;
        }
        String path = URLDecoder.decode(AtomBindingListenerServlet.getRequestPath(request), "UTF-8");
        if (path == null || path.length() == 0 || path.equals("/")) {
            Message responseMessage;
            Entry createdFeedEntry = null;
            String contentType = request.getContentType();
            if (contentType != null && contentType.startsWith("application/atom+xml")) {
                Message requestMessage;
                Entry feedEntry;
                try {
                    Document doc = abderaParser.parse((Reader)request.getReader());
                    feedEntry = (Entry)doc.getRoot();
                }
                catch (ParseException pe) {
                    throw new ServletException((Throwable)pe);
                }
                if (this.supportsFeedEntries) {
                    requestMessage = this.messageFactory.createMessage();
                    requestMessage.setBody(new Object[]{feedEntry});
                    Message responseMessage2 = this.postInvoker.invoke(requestMessage);
                    if (responseMessage2.isFault()) {
                        throw new ServletException((Throwable)responseMessage2.getBody());
                    }
                    createdFeedEntry = (Entry)responseMessage2.getBody();
                } else {
                    requestMessage = this.messageFactory.createMessage();
                    org.apache.tuscany.sca.data.collection.Entry<Object, Object> entry = AtomBindingUtil.entry(feedEntry, this.itemClassType, this.itemXMLType, this.mediator);
                    requestMessage.setBody(new Object[]{entry.getKey(), entry.getData()});
                    responseMessage = this.postInvoker.invoke(requestMessage);
                    if (responseMessage.isFault()) {
                        throw new ServletException((Throwable)responseMessage.getBody());
                    }
                    entry.setKey(responseMessage.getBody());
                    createdFeedEntry = AtomBindingUtil.feedEntry(entry, this.itemClassType, this.itemXMLType, this.mediator, abderaFactory);
                }
            } else if (contentType != null) {
                String title = request.getHeader("Title");
                String slug = request.getHeader("Slug");
                Message requestMessage = this.messageFactory.createMessage();
                requestMessage.setBody(new Object[]{title, slug, contentType, request.getInputStream()});
                responseMessage = this.postMediaInvoker.invoke(requestMessage);
                if (responseMessage.isFault()) {
                    throw new ServletException((Throwable)responseMessage.getBody());
                }
                createdFeedEntry = (Entry)responseMessage.getBody();
                String summary = createdFeedEntry.getSummary();
                AtomBindingListenerServlet.addPropertiesToHeader(response, summary);
            } else {
                response.sendError(415);
            }
            if (createdFeedEntry != null) {
                Link editMediaLink;
                Link editLink;
                Link link;
                Date entryUpdated;
                IRI feedId = createdFeedEntry.getId();
                if (feedId != null) {
                    response.addHeader(ETAG, "\"" + feedId.toString() + "\"");
                }
                if ((entryUpdated = createdFeedEntry.getUpdated()) != null) {
                    response.addHeader(LASTMODIFIED, dateFormat.format(entryUpdated));
                }
                if ((link = createdFeedEntry.getSelfLink()) != null) {
                    response.addHeader(LOCATION, link.getHref().toString());
                }
                if ((editLink = createdFeedEntry.getEditLink()) != null) {
                    response.addHeader(LOCATION, editLink.getHref().toString());
                }
                if ((editMediaLink = createdFeedEntry.getEditMediaLink()) != null) {
                    response.addHeader(CONTENTLOCATION, editMediaLink.getHref().toString());
                }
                response.setStatus(201);
                response.setContentType("application/atom+xml;type=entry");
                try {
                    createdFeedEntry.writeTo(this.getWriter(response));
                }
                catch (ParseException pe) {
                    throw new ServletException((Throwable)pe);
                }
            } else {
                response.sendError(404);
            }
        } else {
            response.sendError(404);
        }
    }

    private Writer getWriter(HttpServletResponse response) throws UnsupportedEncodingException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
        return writer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user = this.processAuthorizationHeader(request);
        if (user == null) {
            this.unauthorized(response);
            return;
        }
        String path = URLDecoder.decode(AtomBindingListenerServlet.getRequestPath(request), "UTF-8");
        if (path != null && path.startsWith("/")) {
            String id = path.substring(1);
            String contentType = request.getContentType();
            if (contentType != null && contentType.startsWith("application/atom+xml")) {
                Message requestMessage;
                Entry feedEntry;
                try {
                    Document doc = abderaParser.parse((Reader)request.getReader());
                    feedEntry = (Entry)doc.getRoot();
                }
                catch (ParseException pe) {
                    throw new ServletException((Throwable)pe);
                }
                if (this.supportsFeedEntries) {
                    requestMessage = this.messageFactory.createMessage();
                    requestMessage.setBody(new Object[]{id, feedEntry});
                    Message responseMessage = this.putInvoker.invoke(requestMessage);
                    if (!responseMessage.isFault()) return;
                    Object body = responseMessage.getBody();
                    if (!body.getClass().getName().endsWith(".NotFoundException")) throw new ServletException((Throwable)responseMessage.getBody());
                    response.sendError(404);
                    return;
                } else {
                    requestMessage = this.messageFactory.createMessage();
                    org.apache.tuscany.sca.data.collection.Entry<Object, Object> entry = AtomBindingUtil.entry(feedEntry, this.itemClassType, this.itemXMLType, this.mediator);
                    requestMessage.setBody(new Object[]{entry.getKey(), entry.getData()});
                    Message responseMessage = this.putInvoker.invoke(requestMessage);
                    if (!responseMessage.isFault()) return;
                    Object body = responseMessage.getBody();
                    if (!body.getClass().getName().endsWith(".NotFoundException")) throw new ServletException((Throwable)responseMessage.getBody());
                    response.sendError(404);
                }
                return;
            }
            if (contentType != null) {
                Message requestMessage = this.messageFactory.createMessage();
                requestMessage.setBody(new Object[]{id, contentType, request.getInputStream()});
                Message responseMessage = this.putMediaInvoker.invoke(requestMessage);
                Object body = responseMessage.getBody();
                if (!responseMessage.isFault()) return;
                if (!body.getClass().getName().endsWith(".NotFoundException")) throw new ServletException((Throwable)responseMessage.getBody());
                response.sendError(404);
                return;
            } else {
                response.sendError(415);
            }
            return;
        }
        response.sendError(404);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user = this.processAuthorizationHeader(request);
        if (user == null) {
            this.unauthorized(response);
            return;
        }
        String path = URLDecoder.decode(AtomBindingListenerServlet.getRequestPath(request), "UTF-8");
        String id = path != null && path.startsWith("/") ? path.substring(1) : "";
        Message requestMessage = this.messageFactory.createMessage();
        requestMessage.setBody(new Object[]{id});
        Message responseMessage = this.deleteInvoker.invoke(requestMessage);
        if (responseMessage.isFault()) {
            Object body = responseMessage.getBody();
            if (body.getClass().getName().endsWith(".NotFoundException")) {
                response.sendError(404);
            } else {
                throw new ServletException((Throwable)responseMessage.getBody());
            }
        }
    }

    private static String getRequestPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        int contextPathLength = request.getContextPath().length();
        int servletPathLenght = servletPath.contains(contextPath) ? servletPath.length() - contextPath.length() : servletPath.length();
        String requestPath = requestURI.substring(contextPathLength + servletPathLenght);
        return requestPath;
    }

    private String processAuthorizationHeader(HttpServletRequest request) throws ServletException {
        return "admin";
    }

    private boolean authenticate(String user, String password) {
        return "admin".equals(user) && "admin".equals(password);
    }

    private void unauthorized(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "BASIC realm=\"Tuscany\"");
        response.sendError(401);
    }

    private static String getContentPreference(String acceptType) {
        if (acceptType == null || acceptType.length() < 1) {
            return "application/atom+xml";
        }
        StringTokenizer st = new StringTokenizer(acceptType, ",");
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        return "application/atom+xml";
    }

    private static void addPropertiesToHeader(HttpServletResponse response, String properties) {
        if (properties == null) {
            return;
        }
        StringTokenizer props = new StringTokenizer(properties, ",");
        while (props.hasMoreTokens()) {
            String prop = props.nextToken();
            StringTokenizer keyVal = new StringTokenizer(prop, "=");
            String key = null;
            String val = null;
            if (keyVal.hasMoreTokens()) {
                key = keyVal.nextToken();
            }
            if (keyVal.hasMoreTokens()) {
                val = keyVal.nextToken();
            }
            if (key == null || val == null) continue;
            response.addHeader(key, val);
        }
    }

    private Date exactSeconds(Date date) {
        return new Date(date.getTime() / 1000L * 1000L);
    }
}

