/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.atom.provider;

import org.apache.abdera.model.Entry;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.tuscany.sca.binding.atom.AtomBinding;
import org.apache.tuscany.sca.binding.atom.provider.AtomBindingInvoker;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AtomReferenceBindingProvider
implements ReferenceBindingProvider {
    private RuntimeComponentReference reference;
    private AtomBinding binding;
    private String authorizationHeader = null;
    private HttpClient httpClient;
    private Mediator mediator;
    private DataType<?> itemClassType;
    private DataType<?> itemXMLType;
    private boolean supportsFeedEntries;

    AtomReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, AtomBinding binding, Mediator mediator) {
        this.reference = reference;
        this.binding = binding;
        this.mediator = mediator;
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
        connectionManager.getParams().setConnectionTimeout(60000);
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
    }

    @Override
    public Invoker createInvoker(Operation operation) {
        String operationName = operation.getName();
        if (operationName.equals("get")) {
            DataType outputType;
            this.itemXMLType = new DataTypeImpl<Class<String>>(String.class.getName(), String.class, String.class);
            Class<?> itemClass = operation.getOutputType().getPhysical();
            this.itemClassType = outputType = operation.getOutputType();
            if (this.itemClassType.getPhysical() == Entry.class) {
                this.supportsFeedEntries = true;
            }
            return new AtomBindingInvoker.GetInvoker(operation, this.binding.getURI(), this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("post")) {
            return new AtomBindingInvoker.PostInvoker(operation, this.binding.getURI(), this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("put")) {
            return new AtomBindingInvoker.PutInvoker(operation, this.binding.getURI(), this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("delete")) {
            return new AtomBindingInvoker.DeleteInvoker(operation, this.binding.getURI(), this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("getFeed") || operationName.equals("getAll")) {
            return new AtomBindingInvoker.GetAllInvoker(operation, this.binding.getURI(), this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("postMedia")) {
            return new AtomBindingInvoker.PostMediaInvoker(operation, this.binding.getURI(), this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("putMedia")) {
            return new AtomBindingInvoker.PutMediaInvoker(operation, this.binding.getURI(), this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("query")) {
            return new AtomBindingInvoker.QueryInvoker(operation, this.binding.getURI(), this.httpClient, this.authorizationHeader, this);
        }
        return new AtomBindingInvoker(operation, this.binding.getURI(), this.httpClient, this.authorizationHeader, this);
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.reference.getInterfaceContract();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return false;
    }

    Mediator getMediator() {
        return this.mediator;
    }

    DataType<?> getItemClassType() {
        return this.itemClassType;
    }

    DataType<?> getItemXMLType() {
        return this.itemXMLType;
    }

    boolean supportsFeedEntries() {
        return this.supportsFeedEntries;
    }
}

