/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.binding.corba.CorbaBinding;
import org.apache.tuscany.sca.binding.corba.impl.CorbaBindingImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<CorbaBinding> {
    private PolicyFactory policyFactory;
    private PolicyAttachPointProcessor policyProcessor;

    public CorbaBindingProcessor(ModelFactoryExtensionPoint modelFactories) {
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
    }

    @Override
    public QName getArtifactType() {
        return CorbaBinding.BINDING_CORBA_QNAME;
    }

    @Override
    public CorbaBinding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String id;
        String uri;
        String name;
        CorbaBindingImpl binding = new CorbaBindingImpl();
        this.policyProcessor.readPolicies(binding, reader);
        binding.setHost(reader.getAttributeValue(null, "host"));
        String port = reader.getAttributeValue(null, "port");
        if (port != null) {
            binding.setPort(Integer.parseInt(port));
        }
        if ((name = reader.getAttributeValue(null, "name")) != null) {
            binding.setName(name);
        }
        if ((uri = CorbaBindingProcessor.getURIString(reader, "uri")) != null) {
            binding.setURI(uri);
        }
        if ((id = reader.getAttributeValue(null, "id")) != null) {
            binding.setId(id);
        }
        return binding;
    }

    @Override
    public void write(CorbaBinding model, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.0", "binding.corba");
        if (model.getName() != null) {
            writer.writeAttribute("name", model.getName());
        }
        if (model.getURI() != null) {
            writer.writeAttribute("uri", model.getURI());
        }
        if (model.getHost() != null) {
            writer.writeAttribute("host", model.getHost());
        }
        if (model.getPort() != -1) {
            writer.writeAttribute("port", String.valueOf(model.getPort()));
        }
        if (model.getId() != null) {
            writer.writeAttribute("id", model.getId());
        }
        writer.writeEndElement();
    }

    @Override
    public Class<CorbaBinding> getModelType() {
        return CorbaBinding.class;
    }

    @Override
    public void resolve(CorbaBinding model, ModelResolver resolver) throws ContributionResolveException {
    }
}

