/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.binding.corba.CorbaBinding;
import org.apache.tuscany.sca.binding.corba.impl.CorbaInvoker;
import org.apache.tuscany.sca.binding.corba.impl.util.OperationMapper;
import org.apache.tuscany.sca.host.corba.CorbaHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.omg.CORBA.Object;

public class CorbaReferenceBindingProvider
implements ReferenceBindingProvider {
    private static final Logger logger = Logger.getLogger(CorbaReferenceBindingProvider.class.getName());
    private CorbaBinding binding;
    private CorbaHost host;
    private RuntimeComponentReference reference;
    private Object remoteObject;
    private Class<?> referenceClass;
    private Map<Method, String> operationsMap = null;

    public CorbaReferenceBindingProvider(CorbaBinding binding, CorbaHost host, RuntimeComponentReference reference) {
        this.binding = binding;
        this.host = host;
        this.reference = reference;
        this.referenceClass = ((JavaInterface)reference.getInterfaceContract().getInterface()).getJavaClass();
        this.operationsMap = OperationMapper.mapMethodToOperationName(this.referenceClass);
    }

    public Invoker createInvoker(Operation operation) {
        try {
            if (this.remoteObject == null) {
                this.remoteObject = this.host.lookup(this.binding.getCorbaname());
            }
            return new CorbaInvoker(this.reference, this.remoteObject, this.referenceClass, this.operationsMap);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception during creating CORBA invoker", e);
            return null;
        }
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.reference.getInterfaceContract();
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }
}

